/*
 * Decompiled with CFR 0.152.
 */
package animalscriptapi.primitives;

import animalscriptapi.primitives.Primitive;
import animalscriptapi.primitives.generators.GeneratorInterface;
import animalscriptapi.properties.QueueProperties;
import animalscriptapi.util.DisplayOptions;
import animalscriptapi.util.Node;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VisualQueue<T>
extends Primitive {
    private LinkedList<T> queue;
    private List<T> initContent;
    private Node upperLeft;
    private QueueProperties properties;

    public VisualQueue(GeneratorInterface g, Node upperLeftCorner, List<T> content, String name, DisplayOptions display, QueueProperties qp) {
        super(g, display);
        if (upperLeftCorner == null) {
            throw new IllegalArgumentException("The coordinate of the upper left Node shouldn't be null!");
        }
        this.upperLeft = upperLeftCorner;
        this.initContent = content;
        this.queue = new LinkedList();
        if (this.initContent != null) {
            this.queue.addAll(this.initContent);
        }
        this.properties = qp;
        this.setName(name);
    }

    public void enqueue(T elem) {
        this.queue.offer(elem);
    }

    public T dequeue() {
        return this.queue.poll();
    }

    public T front() {
        return this.queue.peek();
    }

    public T tail() {
        return this.queue.getLast();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public Node getUpperLeft() {
        return this.upperLeft;
    }

    @Override
    public void setName(String newName) {
        this.properties.setName(newName);
        super.setName(newName);
    }

    public List<T> getInitContent() {
        return this.initContent;
    }

    public QueueProperties getProperties() {
        return this.properties;
    }

    public LinkedList<T> getQueue() {
        return this.queue;
    }
}

