/*
 * Decompiled with CFR 0.152.
 */
package animalscriptapi.animalscript;

import animalscriptapi.animalscript.AnimalGenerator;
import animalscriptapi.primitives.Polyline;
import animalscriptapi.primitives.generators.Language;
import animalscriptapi.primitives.generators.PolylineGenerator;
import animalscriptapi.properties.PolylineProperties;
import animalscriptapi.util.Node;
import java.awt.Color;

public class AnimalPolylineGenerator
extends AnimalGenerator
implements PolylineGenerator {
    private static int count = 1;

    public AnimalPolylineGenerator(Language aLang) {
        super(aLang);
    }

    public void create(Polyline poly) {
        if (this.isNameUsed(poly.getName()) || poly.getName() == "") {
            poly.setName("Polyline" + count);
            ++count;
        }
        this.lang.addItem(poly);
        StringBuilder str = new StringBuilder();
        str.append("polyline \"" + poly.getName() + "\"");
        Node[] nodes = poly.getNodes();
        int i = 0;
        while (i < nodes.length) {
            str.append(" " + AnimalGenerator.makeNodeDef(nodes[i]));
            ++i;
        }
        PolylineProperties props = poly.getProperties();
        if (props.get("color") != null) {
            str.append(" color ");
            str.append(AnimalGenerator.makeColorDef(((Color)props.get("color")).getRed(), ((Color)props.get("color")).getGreen(), ((Color)props.get("color")).getBlue()));
        }
        if (props.get("depth") != null) {
            str.append(" depth " + ((Integer)props.get("depth")).toString());
        }
        if (props.get("fwArrow") != null && ((Boolean)props.get("fwArrow")).booleanValue()) {
            str.append(" fwarrow");
        }
        if (props.get("bwArrow") != null && ((Boolean)props.get("bwArrow")).booleanValue()) {
            str.append(" bwarrow");
        }
        str.append(AnimalGenerator.makeDisplayOptionsDef(poly.getDisplayOptions(), props));
        this.lang.addLine(str);
    }
}

