/*
 * Decompiled with CFR 0.152.
 */
package animalscriptapi.animalscript;

import animal.main.Animal;
import animalscriptapi.animalscript.AnimalGenerator;
import animalscriptapi.exceptions.IllegalDirectionException;
import animalscriptapi.primitives.Group;
import animalscriptapi.primitives.ListBasedStack;
import animalscriptapi.primitives.ListElement;
import animalscriptapi.primitives.Primitive;
import animalscriptapi.primitives.Rect;
import animalscriptapi.primitives.generators.Language;
import animalscriptapi.primitives.generators.ListBasedStackGenerator;
import animalscriptapi.properties.ListElementProperties;
import animalscriptapi.properties.RectProperties;
import animalscriptapi.util.Coordinates;
import animalscriptapi.util.Hidden;
import animalscriptapi.util.Node;
import animalscriptapi.util.Timing;
import java.awt.Color;
import java.awt.Font;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimalListBasedStackGenerator<T>
extends AnimalGenerator
implements ListBasedStackGenerator<T> {
    private static int count = 1;
    private Node upperLeft;
    private ListElementProperties lp;
    private ListElement top;
    private Rect emptyStack;
    private boolean hidden;
    private boolean hiddenProp;
    private boolean emptyHidden;
    private boolean highlightedTopCell;
    private boolean highlightedTopElem;
    private LinkedList<Primitive> list;
    private final int distance = 70;
    int ulx;
    int uly;

    public AnimalListBasedStackGenerator(Language aLang) {
        super(aLang);
    }

    @Override
    public void create(ListBasedStack<T> lbs) {
        if (this.isNameUsed(lbs.getName()) || lbs.getName() == "") {
            lbs.setName("ListBasedStack" + count);
            ++count;
        }
        this.upperLeft = lbs.getUpperLeft();
        if (this.upperLeft instanceof Coordinates) {
            this.ulx = ((Coordinates)this.upperLeft).getX();
            this.uly = ((Coordinates)this.upperLeft).getY();
        }
        Object stackColor = lbs.getProperties().get("color");
        this.hiddenProp = (Boolean)lbs.getProperties().get("hidden");
        this.hidden = lbs.getDisplayOptions() instanceof Hidden;
        RectProperties rp = new RectProperties();
        rp.set("hidden", this.hiddenProp);
        rp.set("color", stackColor);
        this.emptyStack = this.lang.newRect(this.upperLeft, new Coordinates(this.ulx + 20, this.uly + 40), "", lbs.getDisplayOptions(), rp);
        this.lp = new ListElementProperties();
        this.lp.set("color", stackColor);
        this.lp.set("pointerAreaColor", stackColor);
        this.lp.set("position", 4);
        this.lp.set("textColor", lbs.getProperties().get("elementColor"));
        this.lp.set("boxFillColor", Color.WHITE);
        this.lp.set("pointerAreaFillColor", Color.WHITE);
        this.lp.set("depth", lbs.getProperties().get("depth"));
        this.lp.set("hidden", this.hiddenProp);
        this.list = new LinkedList();
        List content = lbs.getInitContent();
        if (content != null) {
            ListIterator li = content.listIterator();
            this.lang.nextStep(0);
            while (li.hasNext()) {
                this.push(lbs, li.next(), null, null);
            }
        }
    }

    @Override
    public void pop(ListBasedStack<T> lbs, Timing delay, Timing duration) {
        this.top.hide(delay);
        this.list.removeLast();
        if (!this.list.isEmpty()) {
            this.top = (ListElement)this.list.getLast();
            Group newStack = this.lang.newGroup(this.list, "");
            try {
                this.lang.nextStep(0);
                newStack.moveTo("NW", "translate", this.upperLeft, delay, duration);
            }
            catch (IllegalDirectionException e) {
                e.printStackTrace();
            }
        } else if (!this.hidden && !this.hiddenProp) {
            this.emptyStack.show(delay);
            this.emptyHidden = false;
        }
    }

    @Override
    public void push(ListBasedStack<T> lbs, T elem, Timing delay, Timing duration) {
        ListElement le;
        if (!this.emptyHidden) {
            this.emptyStack.hide(delay);
            this.emptyHidden = true;
        }
        if (this.top != null && this.highlightedTopElem) {
            this.unhighlightTopElem(lbs, delay, duration);
        }
        if (this.top != null && this.highlightedTopCell) {
            this.unhighlightTopCell(lbs, delay, duration);
        }
        String text = elem.toString();
        this.lp.set("text", text);
        int topTextWidth = Animal.getStringWidth(text, new Font("SansSerif", 0, 16));
        if (!this.list.isEmpty()) {
            Group formerStack = this.lang.newGroup(this.list, "");
            formerStack.moveBy("translate", topTextWidth + 70, 0, delay, duration);
            this.lang.nextStep(0);
        }
        this.lang.nextStep(0);
        this.top = le = this.lang.newListElement(this.upperLeft, 1, null, null, this.top, "", this.hidden ? new Hidden() : null, this.lp);
        this.list.add(le);
    }

    @Override
    public void top(ListBasedStack<T> lbs, Timing delay, Timing duration) {
        this.highlightTopCell(lbs, delay, duration);
        this.highlightTopElem(lbs, delay, duration);
    }

    @Override
    public void isEmpty(ListBasedStack<T> lbs, Timing delay, Timing duration) {
    }

    @Override
    public void highlightTopCell(ListBasedStack<T> lbs, Timing delay, Timing duration) {
        this.top.changeColor("fillColor", (Color)lbs.getProperties().get("cellHighlight"), delay, duration);
        this.top.changeColor("pointer background color", (Color)lbs.getProperties().get("cellHighlight"), delay, duration);
        this.highlightedTopCell = true;
    }

    @Override
    public void highlightTopElem(ListBasedStack<T> lbs, Timing delay, Timing duration) {
        this.top.changeColor("textcolor", (Color)lbs.getProperties().get("elemHighlight"), delay, duration);
        this.highlightedTopElem = true;
    }

    @Override
    public void unhighlightTopCell(ListBasedStack<T> lbs, Timing delay, Timing duration) {
        this.top.changeColor("fillColor", Color.WHITE, delay, duration);
        this.top.changeColor("pointer background color", Color.WHITE, delay, duration);
        this.highlightedTopCell = false;
    }

    @Override
    public void unhighlightTopElem(ListBasedStack<T> lbs, Timing delay, Timing duration) {
        this.top.changeColor("textcolor", (Color)this.lp.get("textColor"), delay, duration);
        this.highlightedTopElem = false;
    }
}

