/*
 * Decompiled with CFR 0.152.
 */
package animalscriptapi.animalscript;

import animal.main.Animal;
import animalscriptapi.animalscript.AnimalGenerator;
import animalscriptapi.primitives.ConceptualStack;
import animalscriptapi.primitives.Group;
import animalscriptapi.primitives.Polyline;
import animalscriptapi.primitives.Primitive;
import animalscriptapi.primitives.Rect;
import animalscriptapi.primitives.Text;
import animalscriptapi.primitives.generators.ConceptualStackGenerator;
import animalscriptapi.primitives.generators.Language;
import animalscriptapi.properties.PolylineProperties;
import animalscriptapi.properties.RectProperties;
import animalscriptapi.properties.TextProperties;
import animalscriptapi.util.Coordinates;
import animalscriptapi.util.Hidden;
import animalscriptapi.util.Node;
import animalscriptapi.util.Timing;
import java.awt.Color;
import java.awt.Font;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimalConceptualStackGenerator<T>
extends AnimalGenerator
implements ConceptualStackGenerator<T> {
    private static int count = 1;
    private Node upperLeft;
    private LinkedList<Primitive> rectangles;
    private LinkedList<Primitive> texts;
    private TextProperties tp;
    private RectProperties rp;
    private int maxWidth = 0;
    private int ulx;
    private int uly;
    private int fontSize;
    private int heightOffset;
    private Text topText;
    private Rect topRect;
    private Group rectanglesToMove;
    private Group textsToMove;
    private Polyline pLine;
    private Object fontObject;
    private boolean hidden;
    private boolean hiddenProp;
    private boolean highlightedTopText;
    private boolean highlightedTopRect;
    private boolean alternateFilled;
    private boolean odd;
    private final int widthOffset = 2;

    public AnimalConceptualStackGenerator(Language aLang) {
        super(aLang);
    }

    @Override
    public void create(ConceptualStack<T> cs) {
        if (this.isNameUsed(cs.getName()) || cs.getName() == "") {
            cs.setName("ConceptualStack" + count);
            ++count;
        }
        this.lang.addItem(cs);
        this.upperLeft = cs.getUpperLeft();
        if (this.upperLeft instanceof Coordinates) {
            this.ulx = ((Coordinates)this.upperLeft).getX();
            this.uly = ((Coordinates)this.upperLeft).getY();
        }
        PolylineProperties plp = new PolylineProperties();
        plp.set("color", cs.getProperties().get("color"));
        Integer stackDepth = (Integer)cs.getProperties().get("depth");
        if (stackDepth.compareTo(Integer.MAX_VALUE) < 0) {
            plp.set("depth", stackDepth);
        } else {
            plp.set("depth", stackDepth - 1);
        }
        this.hiddenProp = (Boolean)cs.getProperties().get("hidden");
        this.hidden = cs.getDisplayOptions() instanceof Hidden;
        plp.set("hidden", this.hiddenProp);
        Node[] vertices = new Node[]{this.upperLeft, new Coordinates(this.ulx + 20, this.uly), new Coordinates(this.ulx + 20, this.uly + 10), new Coordinates(this.ulx + 40, this.uly + 10), new Coordinates(this.ulx + 40, this.uly), new Coordinates(this.ulx + 60, this.uly)};
        this.pLine = this.lang.newPolyline(vertices, "", cs.getDisplayOptions(), plp);
        this.tp = new TextProperties();
        this.tp.set("color", cs.getProperties().get("elementColor"));
        this.tp.set("depth", plp.get("depth"));
        this.tp.set("centered", true);
        this.fontObject = cs.getProperties().get("font");
        this.fontSize = ((Font)this.fontObject).getSize();
        this.heightOffset = this.fontSize / 2;
        this.tp.set("font", this.fontObject);
        this.tp.set("hidden", this.hiddenProp);
        this.rp = new RectProperties();
        this.rp.set("color", cs.getProperties().get("dividingLineColor"));
        this.rp.set("depth", (Integer)this.tp.get("depth") + 1);
        this.alternateFilled = (Boolean)cs.getProperties().get("alternateFilled");
        this.rp.set("filled", true);
        this.rp.set("hidden", this.hiddenProp);
        this.rectangles = new LinkedList();
        this.texts = new LinkedList();
        List content = cs.getInitContent();
        if (content != null) {
            ListIterator li = content.listIterator();
            while (li.hasNext()) {
                this.push(cs, li.next(), null, null);
            }
        }
    }

    @Override
    public void pop(ConceptualStack<T> cs, Timing delay, Timing duration) {
        this.topText.hide(delay);
        this.topRect.hide(delay);
        this.rectangles.removeLast();
        this.texts.removeLast();
        this.odd = !this.odd;
        String text = this.topText.getText();
        int width = Animal.getStringWidth(text, (Font)this.fontObject) + 4;
        if (!this.texts.isEmpty()) {
            this.topRect = (Rect)this.rectangles.getLast();
            this.topText = (Text)this.texts.getLast();
            this.textsToMove = this.lang.newGroup(this.texts, "");
            this.rectanglesToMove = this.lang.newGroup(this.rectangles, "");
            this.textsToMove.moveBy("translate", 0, -(this.fontSize + this.heightOffset), delay, duration);
            this.rectanglesToMove.moveBy("translate", 0, -(this.fontSize + this.heightOffset), delay, duration);
            this.pLine.moveBy("translateNodes 3 4", 0, -(this.fontSize + this.heightOffset), delay, duration);
            if (width == this.maxWidth) {
                this.narrowStack(delay, duration);
            }
        } else {
            this.pLine.moveBy("translateNodes 3 4", 0, 10 - (this.fontSize + this.heightOffset), delay, duration);
            this.pLine.moveBy("translateNodes 4 5 6", 20 - this.maxWidth, 0, delay, duration);
            this.maxWidth = 0;
        }
    }

    private void narrowStack(Timing delay, Timing duration) {
        int newMaxWidth = 0;
        Iterator it = this.texts.iterator();
        while (it.hasNext()) {
            int width = Animal.getStringWidth(((Text)it.next()).getText(), (Font)this.fontObject) + 4;
            if (width <= newMaxWidth) continue;
            newMaxWidth = width;
        }
        this.rectanglesToMove.moveBy("translate #2", newMaxWidth - this.maxWidth, 0, delay, duration);
        this.textsToMove.moveBy("translate", (newMaxWidth - this.maxWidth) / 2, 0, delay, duration);
        this.pLine.moveBy("translateNodes 4 5 6", newMaxWidth - this.maxWidth, 0, delay, duration);
        this.maxWidth = newMaxWidth;
    }

    @Override
    public void push(ConceptualStack<T> cs, T elem, Timing delay, Timing duration) {
        String text = elem.toString();
        int width = Animal.getStringWidth(text, (Font)this.fontObject) + 4;
        if (!this.texts.isEmpty()) {
            this.textsToMove = this.lang.newGroup(this.texts, "");
            this.rectanglesToMove = this.lang.newGroup(this.rectangles, "");
            this.textsToMove.moveBy("translate", 0, this.fontSize + this.heightOffset, delay, duration);
            this.rectanglesToMove.moveBy("translate", 0, this.fontSize + this.heightOffset, delay, duration);
            this.pLine.moveBy("translateNodes 3 4", 0, this.fontSize + this.heightOffset, delay, duration);
            if (this.maxWidth < width) {
                this.expandStack(width, delay, duration);
            }
        } else {
            this.maxWidth = width;
            this.pLine.moveBy("translateNodes 4 5 6", this.maxWidth - 20, 0, delay, duration);
            this.pLine.moveBy("translateNodes 3 4", 0, this.fontSize + this.heightOffset - 10, delay, duration);
        }
        if (this.topText != null && this.highlightedTopText) {
            this.unhighlightTopElem(cs, delay, duration);
        }
        if (this.topRect != null && this.highlightedTopRect) {
            this.unhighlightTopCell(cs, delay, duration);
        }
        this.rp.set("fillColor", this.odd && this.alternateFilled ? cs.getProperties().get("alternateFillColor") : Color.WHITE);
        this.topText = this.lang.newText(new Coordinates(this.ulx + 20 + this.maxWidth / 2, this.uly), text, "", this.hidden ? new Hidden() : delay, this.tp);
        this.topRect = this.lang.newRect(new Coordinates(this.ulx + 20, this.uly), new Coordinates(this.ulx + 20 + this.maxWidth, this.uly + this.fontSize + this.heightOffset), "", this.hidden ? new Hidden() : delay, this.rp);
        this.odd = !this.odd;
        this.texts.add(this.topText);
        this.rectangles.add(this.topRect);
    }

    private void expandStack(int width, Timing delay, Timing duration) {
        this.rectanglesToMove.moveBy("translate #2", width - this.maxWidth, 0, delay, duration);
        this.textsToMove.moveBy("translate", (width - this.maxWidth) / 2, 0, delay, duration);
        this.pLine.moveBy("translateNodes 4 5 6", width - this.maxWidth, 0, delay, duration);
        this.maxWidth = width;
    }

    @Override
    public void top(ConceptualStack<T> cs, Timing delay, Timing duration) {
        this.highlightTopCell(cs, delay, duration);
        this.highlightTopElem(cs, delay, duration);
    }

    @Override
    public void isEmpty(ConceptualStack<T> cs, Timing delay, Timing duration) {
    }

    @Override
    public void highlightTopCell(ConceptualStack<T> cs, Timing delay, Timing duration) {
        this.topRect.changeColor("fillColor", (Color)cs.getProperties().get("cellHighlight"), delay, duration);
        this.highlightedTopRect = true;
    }

    @Override
    public void highlightTopElem(ConceptualStack<T> cs, Timing delay, Timing duration) {
        this.topText.changeColor("color", (Color)cs.getProperties().get("elemHighlight"), delay, duration);
        this.highlightedTopText = true;
    }

    @Override
    public void unhighlightTopCell(ConceptualStack<T> cs, Timing delay, Timing duration) {
        this.topRect.changeColor("fillColor", this.alternateFilled && !this.odd ? (Color)this.rp.get("fillColor") : Color.WHITE, delay, duration);
        this.highlightedTopRect = false;
    }

    @Override
    public void unhighlightTopElem(ConceptualStack<T> cs, Timing delay, Timing duration) {
        this.topText.changeColor("color", (Color)this.tp.get("color"), delay, duration);
        this.highlightedTopText = false;
    }
}

