/*
 * Decompiled with CFR 0.152.
 */
package animalscriptapi.animalscript;

import animalscriptapi.animalscript.AnimalGenerator;
import animalscriptapi.primitives.ArrayBasedStack;
import animalscriptapi.primitives.ArrayMarker;
import animalscriptapi.primitives.StringArray;
import animalscriptapi.primitives.generators.ArrayBasedStackGenerator;
import animalscriptapi.primitives.generators.Language;
import animalscriptapi.properties.ArrayMarkerProperties;
import animalscriptapi.properties.ArrayProperties;
import animalscriptapi.util.ArrayDisplayOptions;
import animalscriptapi.util.Node;
import animalscriptapi.util.Timing;
import java.awt.Color;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimalArrayBasedStackGenerator<T>
extends AnimalGenerator
implements ArrayBasedStackGenerator<T> {
    private static int count = 1;
    private Node upperLeft;
    private ArrayProperties ap;
    private StringArray array;
    private String[] data;
    private int top = -1;
    private int capacity;
    private ArrayMarker am;
    private boolean hiddenProp;
    private boolean am_hidden;
    private boolean highlightedTopElem;
    private boolean highlightedTopCell;

    public AnimalArrayBasedStackGenerator(Language aLang) {
        super(aLang);
    }

    @Override
    public void create(ArrayBasedStack<T> abs) {
        if (this.isNameUsed(abs.getName()) || abs.getName() == "") {
            abs.setName("ArrayBasedStack" + count);
            ++count;
        }
        this.upperLeft = abs.getUpperLeft();
        this.ap = new ArrayProperties();
        this.ap.set("color", abs.getProperties().get("color"));
        this.ap.set("fillColor", Color.WHITE);
        this.ap.set("elementColor", abs.getProperties().get("elementColor"));
        this.ap.set("elemHighlight", abs.getProperties().get("elemHighlight"));
        this.ap.set("cellHighlight", abs.getProperties().get("cellHighlight"));
        this.ap.set("depth", abs.getProperties().get("depth"));
        this.hiddenProp = (Boolean)abs.getProperties().get("hidden");
        this.ap.set("hidden", this.hiddenProp);
        this.capacity = abs.getCapacity();
        this.data = new String[this.capacity];
        int i = 0;
        while (i < this.capacity) {
            this.data[i] = "";
            ++i;
        }
        List content = abs.getInitContent();
        if (content != null) {
            if (content.size() > abs.getCapacity()) {
                throw new ArrayIndexOutOfBoundsException("The initial content of the ArrayBasedStack has " + content.size() + " elements, but it may" + " not have more elements as the capacity of the ArrayBasedStack" + " = " + abs.getCapacity());
            }
            int i2 = 0;
            while (i2 < content.size()) {
                this.data[i2] = content.get(i2).toString();
                ++this.top;
                ++i2;
            }
        }
        ArrayDisplayOptions ado = (ArrayDisplayOptions)abs.getDisplayOptions();
        this.array = this.lang.newStringArray(this.upperLeft, this.data, "", ado, this.ap);
        ArrayMarkerProperties amp = new ArrayMarkerProperties();
        amp.set("label", "top");
        amp.set("color", this.ap.get("color"));
        amp.set("depth", this.ap.get("depth"));
        amp.set("hidden", this.hiddenProp);
        if (this.top == -1) {
            this.am = this.lang.newArrayMarker(this.array, 0, "top", ado == null ? null : ado.getOffset(), amp);
            this.am.hide();
            this.am_hidden = true;
        } else {
            this.am = this.lang.newArrayMarker(this.array, this.top, "top", ado == null ? null : ado.getOffset(), amp);
        }
    }

    @Override
    public void isFull(ArrayBasedStack<T> abs, Timing delay, Timing duration) {
    }

    @Override
    public void pop(ArrayBasedStack<T> abs, Timing delay, Timing duration) {
        if (this.highlightedTopCell) {
            this.unhighlightTopCell(abs, delay, duration);
        }
        if (this.highlightedTopElem) {
            this.unhighlightTopElem(abs, delay, duration);
        }
        --this.top;
        if (this.top == -1) {
            this.am.hide(delay);
            this.am_hidden = true;
        } else {
            this.lang.nextStep(0);
            this.am.move(this.top, delay, duration);
        }
        this.array.put(this.top + 1, "", delay, duration);
    }

    @Override
    public void push(ArrayBasedStack<T> abs, T elem, Timing delay, Timing duration) {
        if (this.highlightedTopCell) {
            this.unhighlightTopCell(abs, delay, duration);
        }
        if (this.highlightedTopElem) {
            this.unhighlightTopElem(abs, delay, duration);
        }
        ++this.top;
        this.lang.nextStep(0);
        this.am.move(this.top, delay, duration);
        this.array.put(this.top, elem.toString(), delay, duration);
        if (this.am_hidden && !this.hiddenProp) {
            this.am.show(delay);
            this.am_hidden = false;
        }
    }

    @Override
    public void top(ArrayBasedStack<T> abs, Timing delay, Timing duration) {
        this.highlightTopCell(abs, delay, duration);
        this.highlightTopElem(abs, delay, duration);
    }

    @Override
    public void isEmpty(ArrayBasedStack<T> abs, Timing delay, Timing duration) {
    }

    @Override
    public void highlightTopCell(ArrayBasedStack<T> abs, Timing delay, Timing duration) {
        this.array.highlightCell(this.top, delay, duration);
        this.highlightedTopCell = true;
    }

    @Override
    public void highlightTopElem(ArrayBasedStack<T> abs, Timing delay, Timing duration) {
        this.array.highlightElem(this.top, delay, duration);
        this.highlightedTopElem = true;
    }

    @Override
    public void unhighlightTopCell(ArrayBasedStack<T> abs, Timing delay, Timing duration) {
        this.array.unhighlightCell(this.top, delay, duration);
        this.highlightedTopCell = false;
    }

    @Override
    public void unhighlightTopElem(ArrayBasedStack<T> abs, Timing delay, Timing duration) {
        this.array.unhighlightElem(this.top, delay, duration);
        this.highlightedTopElem = false;
    }
}

