/*
 * Decompiled with CFR 0.152.
 */
package animalscriptapi.animalscript;

import animalscriptapi.animalscript.AnimalGenerator;
import animalscriptapi.animalscript.AnimalScript;
import animalscriptapi.interactionsupport.DocumentationLink;
import animalscriptapi.interactionsupport.InteractiveElement;
import animalscriptapi.interactionsupport.InteractiveQuestion;
import animalscriptapi.interactionsupport.MultipleChoiceQuestion;
import animalscriptapi.interactionsupport.MultipleSelectionQuestion;
import animalscriptapi.interactionsupport.TrueFalseQuestion;
import animalscriptapi.interactionsupport.generators.InteractiveElementGenerator;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Set;

public class AVInteractionTextGenerator
extends AnimalGenerator
implements InteractiveElementGenerator {
    private StringBuilder idc = new StringBuilder(24096);
    private String fileName = "intDefFile.txt";

    public AVInteractionTextGenerator(AnimalScript as) {
        this(as, "intDefFile.txt");
    }

    public AVInteractionTextGenerator(AnimalScript as, String key) {
        super(as);
        as.addLine("interactionDefinition \"" + key + "\"");
        this.fileName = key;
    }

    public void createInteractiveElementCode(InteractiveElement element) {
        if (element instanceof TrueFalseQuestion) {
            this.createTFQuestionCode((TrueFalseQuestion)element);
        } else if (element instanceof MultipleChoiceQuestion) {
            this.createMCQuestionCode((MultipleChoiceQuestion)element);
        } else if (element instanceof MultipleSelectionQuestion) {
            this.createMSQuestionCode((MultipleSelectionQuestion)element);
        } else if (element instanceof DocumentationLink) {
            this.createDocumentationLinkCode((DocumentationLink)element);
        }
    }

    public void createDocumentationLink(DocumentationLink docuLink) {
        StringBuilder sb = new StringBuilder(127);
        sb.append("documentation \"").append(docuLink.getID()).append("\"");
        this.lang.addLine(sb.toString());
    }

    public void createDocumentationLinkCode(DocumentationLink docuLink) {
        this.idc.append("documentation \"").append(docuLink.getID());
        this.idc.append("\"\n\"").append(docuLink.getTargetURI().toString());
        this.idc.append("\"\nendtext\n\n");
    }

    public void createTFQuestion(TrueFalseQuestion q) {
        StringBuilder sb = new StringBuilder(127);
        sb.append("tfQuestion \"").append(q.getID()).append("\"");
        this.lang.addLine(sb.toString());
    }

    private void createStandardCode(String tag, InteractiveQuestion question) {
        this.idc.append(tag).append(" \"").append(question.getID()).append("\"");
        if (question.getPointsPossible() > 0) {
            this.idc.append("\n  points ").append(question.getPointsPossible());
        }
        if (question.getQuestionGroup() != null) {
            this.idc.append("\n  questionGroup \"");
            this.idc.append(question.getQuestionGroup()).append("\"");
        }
        if (question.getNrRepeats() > -1) {
            this.idc.append("\n  nrRepeats ").append(question.getNrRepeats());
        }
        this.idc.append("\n\"").append(question.getPrompt());
        this.idc.append("\"\nendtext");
    }

    public void createTFQuestionCode(TrueFalseQuestion tfQuestion) {
        this.createStandardCode("tfQuestion", tfQuestion);
        this.idc.append("\n  answer\n");
        this.idc.append(tfQuestion.getAnswerStatus() ? "t" : "f");
        this.idc.append("\nendAnswer");
        String comment = tfQuestion.getFeedbackForOption(!tfQuestion.getAnswerStatus());
        if (comment != null) {
            this.idc.append("\n  comment\n\"").append(comment);
            this.idc.append("\"\n  endComment");
        }
        this.idc.append("\n\n");
    }

    public void createMCQuestion(MultipleChoiceQuestion mcQuestion) {
        StringBuilder sb = new StringBuilder(127);
        sb.append("mcQuestion \"").append(mcQuestion.getID()).append("\"");
        this.lang.addLine(sb.toString());
    }

    public void createMCQuestionCode(MultipleChoiceQuestion mcQuestion) {
        String comment = null;
        String prompt = null;
        this.createStandardCode("mcQuestion", mcQuestion);
        Set<String> answerKeys = mcQuestion.getAnswerSet();
        for (String key : answerKeys) {
            int points;
            prompt = mcQuestion.getAnswerString(key);
            if (prompt != null) {
                this.idc.append("\n\"").append(prompt).append("\"\nendChoice");
            }
            if ((points = mcQuestion.getPointsForOption(key)) != 0) {
                this.idc.append("\n  points ").append(points);
            }
            if ((comment = mcQuestion.getFeedbackForOption(key)) == null) continue;
            this.idc.append("\n  comment\n\"").append(comment).append("\"");
            this.idc.append("\n  endComment");
        }
        this.idc.append("\n  answer\n").append(mcQuestion.getCorrectAnswerID());
        this.idc.append("\nendAnswer\n\n");
    }

    public void createMSQuestion(MultipleSelectionQuestion msQuestion) {
        StringBuilder sb = new StringBuilder(127);
        sb.append("msQuestion \"").append(msQuestion.getID()).append("\"");
        this.lang.addLine(sb.toString());
    }

    public void createMSQuestionCode(MultipleSelectionQuestion msQuestion) {
        String comment = null;
        String prompt = null;
        this.createStandardCode("mcQuestion", msQuestion);
        Set<String> answerKeys = msQuestion.getAnswerSet();
        String singleFakeCorrectID = null;
        for (String key : answerKeys) {
            int points;
            prompt = msQuestion.getAnswerString(key);
            if (prompt != null) {
                this.idc.append("\n\"").append(prompt).append("\"\nendChoice");
            }
            if ((points = msQuestion.getPointsForOption(key)) != 0) {
                this.idc.append("\n  points ").append(points);
            }
            if ((comment = msQuestion.getFeedbackForOption(key)) != null) {
                this.idc.append("\n  comment\n\"").append(comment).append("\"");
                this.idc.append("\n  endComment");
            }
            if (msQuestion.getCorrectnessStatus(key) != Boolean.TRUE) continue;
            singleFakeCorrectID = key;
        }
        this.idc.append("\n  answer\n").append(singleFakeCorrectID);
        this.idc.append("\nendAnswer\n\n");
    }

    public void finalizeInteractiveElements() {
        try {
            BufferedWriter fw = new BufferedWriter(new FileWriter(this.fileName));
            fw.write(this.idc.toString());
            ((Writer)fw).close();
        }
        catch (Exception ex) {
            System.err.println("Error while writing file:");
            System.err.println("Filename: " + this.fileName);
            System.err.println(ex.getMessage());
        }
    }
}

