/*
 * Decompiled with CFR 0.152.
 */
package animalscript.core;

import animal.graphics.PTArc;
import animal.graphics.PTBoxPointer;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTPoint;
import animal.graphics.PTPolygon;
import animal.graphics.PTPolyline;
import animal.graphics.PTRectangle;
import animal.graphics.PTSquare;
import animal.graphics.PTText;
import animal.graphics.PTTriangle;
import animal.graphics.meta.PolygonalShape;
import animal.main.Animal;
import animal.main.AnimalConfiguration;
import animal.misc.MessageDisplay;
import animal.misc.ParseSupport;
import animal.misc.XProperties;
import animalscript.core.AnimalParseSupport;
import animalscript.core.AnimalScriptInterface;
import animalscript.core.BasicParser;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import translator.ExtendedResourceBundle;

public class BaseObjectParser
extends BasicParser
implements AnimalScriptInterface {
    private String[] registeredLanguages = null;

    public BaseObjectParser() {
        this.handledKeywords = new Hashtable();
        this.rulesHash = new XProperties();
        this.handledKeywords.put("arc", "parseArcInput");
        this.handledKeywords.put("circle", "parseArcInput");
        this.handledKeywords.put("circleseg", "parseArcInput");
        this.handledKeywords.put("circlesegment", "parseArcInput");
        this.handledKeywords.put("ellipseseg", "parseArcInput");
        this.handledKeywords.put("ellipsesegment", "parseArcInput");
        this.handledKeywords.put("ellipse", "parseArcInput");
        this.handledKeywords.put("listelement", "parseListElementInput");
        this.handledKeywords.put("point", "parsePointInput");
        this.handledKeywords.put("polyline", "parsePolylineInput");
        this.handledKeywords.put("line", "parsePolylineInput");
        this.handledKeywords.put("square", "parseSquareInput");
        this.handledKeywords.put("rectangle", "parseRectangleInput");
        this.handledKeywords.put("rect", "parseRectangleInput");
        this.handledKeywords.put("relrect", "parseRectangleInput");
        this.handledKeywords.put("relrectangle", "parseRectangleInput");
        this.handledKeywords.put("triangle", "parseTriangleInput");
        this.handledKeywords.put("polygon", "parsePolygonInput");
        this.handledKeywords.put("text", "parseTextInput");
        this.handledKeywords.put("resource", "parseLanguageSupport");
        this.handledKeywords.put("supports", "parseLanguageSupport");
    }

    public boolean generateNewStep(String command) {
        return !sameStep && !command.equalsIgnoreCase("supports") && !command.equalsIgnoreCase("resource");
    }

    public void parseArcInput() throws IOException {
        boolean circleType;
        StringBuilder oids = new StringBuilder();
        PTArc pt = new PTArc();
        String localType = ParseSupport.parseWord(stok, "Arc type").toLowerCase();
        String s = AnimalParseSupport.parseText(stok, "Arc object name");
        pt.setObjectName(s);
        pt.setCenter(AnimalParseSupport.parseNodeInfo(stok, String.valueOf(localType) + " center", null));
        ParseSupport.parseMandatoryWord(stok, String.valueOf(localType) + " keyword 'radius'", "radius");
        pt.setClosed(false);
        pt.setFilled(false);
        boolean completeObjectMode = localType.equalsIgnoreCase("circle") || localType.equalsIgnoreCase("ellipse");
        boolean bl = circleType = localType.equalsIgnoreCase("circle") || localType.equalsIgnoreCase("circleseg") || localType.equalsIgnoreCase("circlesegment");
        if (circleType) {
            pt.setRadius(ParseSupport.parseInt(stok, String.valueOf(localType) + " radius <int>", 1));
            pt.setCircle(true);
            BaseObjectParser.getObjectProperties().put(String.valueOf(localType) + ".radius", pt.getXRadius());
        } else {
            Point node = AnimalParseSupport.parseNodeInfo(stok, String.valueOf(localType) + " radius node", null);
            pt.setRadius(node);
            BaseObjectParser.getObjectProperties().put(String.valueOf(localType) + ".xRadius", pt.getXRadius());
            BaseObjectParser.getObjectProperties().put(String.valueOf(localType) + ".yRadius", pt.getYRadius());
        }
        if (!completeObjectMode) {
            if (ParseSupport.parseOptionalWord(stok, String.valueOf(localType) + " keyword 'angle'", "angle")) {
                pt.setArcAngle(ParseSupport.parseInt(stok, String.valueOf(localType) + " angle"));
                BaseObjectParser.getObjectProperties().put(String.valueOf(localType) + ".angle", pt.getArcAngle());
            } else {
                pt.setArcAngle(BaseObjectParser.getObjectProperties().getIntProperty(String.valueOf(localType) + ".angle", 720));
            }
            if (ParseSupport.parseOptionalWord(stok, String.valueOf(localType) + " keyword 'starts'", "starts")) {
                pt.setStartAngle(ParseSupport.parseInt(stok, String.valueOf(localType) + " start angle"));
                BaseObjectParser.getObjectProperties().put(String.valueOf(localType) + ".startAngle", pt.getStartAngle());
            } else {
                pt.setStartAngle(BaseObjectParser.getObjectProperties().getIntProperty(String.valueOf(localType) + ".startAngle", 0));
            }
            if (ParseSupport.parseOptionalWord(stok, String.valueOf(localType) + " keyword 'clockwise'", "clockwise")) {
                pt.setClockwise(true);
                BaseObjectParser.getObjectProperties().put(String.valueOf(localType) + ".clockwise", true);
            }
            if (ParseSupport.parseOptionalWord(stok, String.valueOf(localType) + " keyword 'counterclockwise'", "counterclockwise")) {
                pt.setClockwise(false);
                BaseObjectParser.getObjectProperties().put(String.valueOf(localType) + ".clockwise", false);
            }
        } else {
            pt.setClosed(true);
            pt.setArcAngle(720);
            pt.setStartAngle(0);
        }
        pt.setColor(AnimalParseSupport.parseAndSetColor(stok, localType, "color"));
        AnimalParseSupport.parseAndSetDepth(stok, pt, localType);
        if (!completeObjectMode) {
            pt.setClosed(ParseSupport.parseOptionalWord(stok, String.valueOf(localType) + " closed", "closed"));
        }
        if (pt.isClosed()) {
            if (ParseSupport.parseOptionalWord(stok, String.valueOf(localType) + " filled", "filled")) {
                pt.setFilled(true);
                pt.setFillColor(AnimalParseSupport.parseAndSetColor(stok, localType, "fillColor"));
            }
        } else {
            if (ParseSupport.parseOptionalWord(stok, String.valueOf(localType) + " fw arrow", "fwArrow")) {
                pt.setFWArrow(true);
            }
            if (ParseSupport.parseOptionalWord(stok, String.valueOf(localType) + " bw arrow", "bwArrow")) {
                pt.setBWArrow(true);
            }
        }
        BasicParser.addGraphicObject(pt, anim);
        oids.append(pt.getNum(false));
        BaseObjectParser.getObjectIDs().put(s, pt.getNum(false));
        BaseObjectParser.getObjectTypes().put(s, BaseObjectParser.getTypeIdentifier("arc"));
        AnimalParseSupport.showComponents(stok, oids.toString(), localType, true);
    }

    public void parseLanguageSupport() throws IOException {
        String localType = ParseSupport.parseWord(stok, "language command").toLowerCase();
        if (localType.equals("supports")) {
            this.registeredLanguages = ParseSupport.parseOIDs(stok, null, false);
            this.chooseLanguage();
        } else if (localType.equals("resource") || localType.equals("bundle") || localType.equals("resourcebundle")) {
            String bundleFileName = AnimalParseSupport.parseText(stok, "Resource base filename");
            if (bundleFileName.indexOf(File.separatorChar) == -1 && AnimalConfiguration.getDefaultConfiguration().getCurrentDirectory() != null) {
                bundleFileName = String.valueOf(AnimalConfiguration.getDefaultConfiguration().getCurrentDirectory()) + System.getProperty("file.separator") + bundleFileName;
            }
            ParseSupport.setResourceBundle(new ExtendedResourceBundle(String.valueOf(bundleFileName) + "." + chosenLanguage));
        }
    }

    public void parseListElementInput() throws IOException {
        int y;
        int x;
        PTBoxPointer ref;
        Rectangle targetBox;
        PTGraphicObject targetObj;
        int targetNr;
        String prevOID;
        int i = 1;
        StringBuilder oids = new StringBuilder();
        String textContained = null;
        PTBoxPointer ptBoxPointer = null;
        String localType = ParseSupport.parseWord(stok, "ListElement type").toLowerCase();
        String s = AnimalParseSupport.parseText(stok, "ListElement object name");
        Point upperLeftBorder = AnimalParseSupport.parseNodeInfo(stok, String.valueOf(localType) + " left boundary", null);
        if (ParseSupport.parseOptionalWord(stok, String.valueOf(localType) + " keyword 'text'", "text")) {
            textContained = AnimalParseSupport.parseText(stok, String.valueOf(localType) + " text component", null, false, chosenLanguage);
        }
        ptBoxPointer = textContained != null ? new PTBoxPointer(upperLeftBorder.x, upperLeftBorder.y, textContained) : new PTBoxPointer(upperLeftBorder.x, upperLeftBorder.y);
        ptBoxPointer.getTextComponent().setFont(new Font("SansSerif", 0, 16));
        ptBoxPointer.setObjectName(s);
        ParseSupport.parseMandatoryWord(stok, String.valueOf(localType) + " keyword 'pointers'", "pointers");
        ptBoxPointer.setPointerCount(ParseSupport.parseInt(stok, String.valueOf(localType) + " nr pointers", 0, 255));
        if (ParseSupport.parseOptionalWord(stok, String.valueOf(localType) + " keyword 'position'", "position")) {
            String pos = ParseSupport.parseWord(stok, String.valueOf(localType) + " pointer position").toLowerCase();
            if (pos.equalsIgnoreCase("top")) {
                ptBoxPointer.setPointerPosition(3);
            } else if (pos.equalsIgnoreCase("left")) {
                ptBoxPointer.setPointerPosition(2);
            } else if (pos.equalsIgnoreCase("none")) {
                ptBoxPointer.setPointerPosition(0);
            } else if (pos.equalsIgnoreCase("right")) {
                ptBoxPointer.setPointerPosition(1);
            } else {
                ptBoxPointer.setPointerPosition(4);
            }
        } else {
            ptBoxPointer.setPointerPosition(4);
        }
        if (ptBoxPointer.getPointerCount() == 0) {
            ptBoxPointer.makeNullPointer();
        }
        i = 1;
        while (i <= ptBoxPointer.getPointerCount()) {
            if (ParseSupport.parseOptionalWord(stok, String.valueOf(localType) + " keyword 'ptr'" + i, "ptr" + i)) {
                if (ParseSupport.parseOptionalChar(stok, "listelement node '('", '(') || ParseSupport.parseOptionalWord(stok, "listelement pointer target", "offset")) {
                    stok.pushBack();
                    ptBoxPointer.setTip(i - 1, AnimalParseSupport.parseNodeInfo(stok, "pointer target " + i, null));
                } else {
                    ParseSupport.parseMandatoryWord(stok, "listelement pointer keyword 'to'", "to");
                    prevOID = AnimalParseSupport.parseText(stok, "ListElement previous");
                    targetNr = BaseObjectParser.getObjectIDs().getIntProperty(prevOID);
                    PTGraphicObject ptTarget = animState.getCloneByNum(targetNr);
                    if (ptTarget != null) {
                        Rectangle targetBBox = null;
                        targetBBox = ptTarget instanceof PTBoxPointer ? ((PTBoxPointer)ptTarget).getBoundingBoxWithoutPointers() : ptTarget.getBoundingBox();
                        Point tipOrigin = ptBoxPointer.getTipOrigin(i - 1);
                        int dx = targetBBox.x - tipOrigin.x;
                        int dy = targetBBox.y - tipOrigin.y;
                        if (ptTarget instanceof PTBoxPointer) {
                            PTBoxPointer pointer = (PTBoxPointer)ptTarget;
                            dy = pointer.getPointerCount() >= i ? pointer.getTipOrigin((int)(i - 1)).y - tipOrigin.y : pointer.getTipOrigin((int)0).y - tipOrigin.y;
                        }
                        if (targetBBox.x < upperLeftBorder.x) {
                            ptBoxPointer.setTipRelative(i - 1, dx + targetBBox.width, dy);
                        } else {
                            ptBoxPointer.setTipRelative(i - 1, dx, dy);
                        }
                    }
                }
            } else {
                Rectangle pointerArea = ptBoxPointer.getPointerArea().getBoundingBox();
                Point tipOrigin = ptBoxPointer.getTipOrigin(i - 1);
                int dx = tipOrigin.x;
                dx = i % 2 == 1 ? (dx -= pointerArea.x - 1) : (dx -= pointerArea.x + pointerArea.width - 1);
                ptBoxPointer.setTipRelative(i - 1, dx, 0);
            }
            ++i;
        }
        if (ParseSupport.parseOptionalWord(stok, String.valueOf(localType) + " keyword 'prev'", "prev")) {
            prevOID = AnimalParseSupport.parseText(stok, "ListElement previous");
            targetNr = BaseObjectParser.getObjectIDs().getIntProperty(prevOID);
            targetObj = animState.getCloneByNum(targetNr);
            if (targetObj != null) {
                targetBox = null;
                if (targetObj instanceof PTBoxPointer) {
                    ref = (PTBoxPointer)targetObj;
                    x = 0;
                    y = ref.getTipOrigin((int)(ref.getPointerCount() - 1)).y;
                    targetBox = ref.getPointerArea().getBoundingBox();
                    x = targetBox.x + targetBox.width;
                    ptBoxPointer.setTip(ptBoxPointer.getPointerCount() - 1, new Point(x, y));
                } else {
                    ptBoxPointer.setTip(ptBoxPointer.getPointerCount() - 1, this.findPositionFor(targetObj.getBoundingBox(), upperLeftBorder));
                }
            }
        }
        if (ParseSupport.parseOptionalWord(stok, String.valueOf(localType) + " keyword 'prev'", "next")) {
            String nextOID = AnimalParseSupport.parseText(stok, "ListElement next");
            targetNr = BaseObjectParser.getObjectIDs().getIntProperty(nextOID);
            targetObj = animState.getCloneByNum(targetNr);
            if (targetObj != null) {
                targetBox = null;
                if (targetObj instanceof PTBoxPointer) {
                    ref = (PTBoxPointer)targetObj;
                    x = 0;
                    y = ref.getTipOrigin((int)0).y;
                    targetBox = ref.getPointerArea().getBoundingBox();
                    x = targetBox.x;
                    ptBoxPointer.setTip(0, new Point(x, y));
                } else {
                    ptBoxPointer.setTip(0, this.findPositionFor(targetObj.getBoundingBox(), upperLeftBorder));
                }
            }
        }
        Color baseColor = AnimalParseSupport.parseAndSetColor(stok, localType, "color");
        ptBoxPointer.setColor(baseColor);
        ptBoxPointer.getTextBox().setColor(baseColor);
        ptBoxPointer.getTextBox().setFillColor(AnimalParseSupport.parseAndSetColor(stok, localType, "boxFillColor", "white"));
        ptBoxPointer.getPointerArea().setColor(AnimalParseSupport.parseAndSetColor(stok, localType, "pointerAreaColor"));
        ptBoxPointer.getPointerArea().setFillColor(AnimalParseSupport.parseAndSetColor(stok, localType, "pointerAreaFillColor", "white"));
        ptBoxPointer.getTextComponent().setColor(AnimalParseSupport.parseAndSetColor(stok, localType, "textColor"));
        AnimalParseSupport.parseAndSetDepth(stok, ptBoxPointer, localType);
        BasicParser.addGraphicObject(ptBoxPointer, anim);
        oids.append(ptBoxPointer.getNum(false));
        BaseObjectParser.getObjectIDs().put(s, ptBoxPointer.getNum(false));
        BaseObjectParser.getObjectTypes().put(s, BaseObjectParser.getTypeIdentifier("listelement"));
        AnimalParseSupport.showComponents(stok, oids.toString(), localType, true);
    }

    private Point findPositionFor(Rectangle targetObjectBox, Point upperLeftBorder) {
        int baseX = upperLeftBorder.x;
        int baseY = upperLeftBorder.y;
        int boxX = targetObjectBox.x;
        int boxY = targetObjectBox.y;
        int height = targetObjectBox.height;
        int width = targetObjectBox.width;
        int x = 0;
        int y = 0;
        x = baseX < boxX ? boxX : (baseX < boxX + width ? boxX + (width >> 1) : boxX + width);
        y = baseY < boxY ? boxY : (baseY < boxY + height ? boxY + (height >> 1) : boxY + height);
        if (x == boxX + (width >> 1) && y == boxY + (height >> 1)) {
            y = boxY;
        }
        return new Point(x, y);
    }

    public void parsePointInput() throws IOException {
        StringBuilder oids = new StringBuilder();
        ParseSupport.parseMandatoryWord(stok, "Point keyword 'point'", "point");
        String s = AnimalParseSupport.parseText(stok, "Point object name");
        Point p = AnimalParseSupport.parseNodeInfo(stok, "point coordinates / offset", null);
        PTPoint pt = new PTPoint(p.x, p.y, 1);
        pt.setObjectName(s);
        pt.setColor(AnimalParseSupport.parseAndSetColor(stok, "point", "color"));
        AnimalParseSupport.parseAndSetDepth(stok, pt, "point");
        BasicParser.addGraphicObject(pt, anim);
        oids.append(pt.getNum(false));
        BaseObjectParser.getObjectIDs().put(s, pt.getNum(false));
        BaseObjectParser.getObjectTypes().put(s, BaseObjectParser.getTypeIdentifier("point"));
        AnimalParseSupport.showComponents(stok, oids.toString(), "point", true);
    }

    public void parsePolylineInput() throws IOException {
        int i = 1;
        Point currentNode = null;
        PTPolyline pt = new PTPolyline();
        StringBuilder oids = new StringBuilder();
        String localType = ParseSupport.parseWord(stok, "Polyline type").toLowerCase();
        String s = AnimalParseSupport.parseText(stok, "Polyline object name");
        currentNode = AnimalParseSupport.parseNodeInfo(stok, String.valueOf(localType) + "node 1", null);
        PTPoint node1 = new PTPoint(currentNode);
        pt.addNode(node1);
        if (localType.equalsIgnoreCase("square")) {
            int sideLength = ParseSupport.parseInt(stok, String.valueOf(localType) + " side length");
            pt.addNode(new PTPoint(node1.getX(), node1.getY() + --sideLength));
            pt.addNode(new PTPoint(node1.getX() + sideLength, node1.getY() + sideLength));
            pt.addNode(new PTPoint(node1.getX() + sideLength, node1.getY()));
        } else {
            currentNode = AnimalParseSupport.parseNodeInfo(stok, String.valueOf(localType) + "node 2", null);
            PTPoint node2 = new PTPoint(currentNode);
            ++i;
            if (localType.equalsIgnoreCase("rectangle") || localType.equalsIgnoreCase("rect")) {
                pt.addNode(new PTPoint(node1.getX(), node2.getY()));
                pt.addNode(new PTPoint(node2.getX(), node2.getY()));
                pt.addNode(new PTPoint(node2.getX(), node1.getY()));
            } else if (localType.equalsIgnoreCase("relrect") || localType.equalsIgnoreCase("relrectangle")) {
                pt.addNode(new PTPoint(node1.getX(), node1.getY() + node2.getY() - 1));
                pt.addNode(new PTPoint(node1.getX() + node2.getX() - 1, node1.getY() + node2.getY() - 1));
                pt.addNode(new PTPoint(node1.getX() + node2.getX() - 1, node1.getY()));
            } else {
                pt.addNode(node2);
                if (ParseSupport.nextTokenIsNodeToken(stok)) {
                    currentNode = AnimalParseSupport.parseNodeInfo(stok, String.valueOf(localType) + "node 3", null);
                    PTPoint node3 = new PTPoint(currentNode);
                    ++i;
                    pt.addNode(node3);
                    if (!localType.equalsIgnoreCase("triangle")) {
                        while (ParseSupport.nextTokenIsNodeToken(stok)) {
                            currentNode = AnimalParseSupport.parseNodeInfo(stok, String.valueOf(localType) + "node " + ++i, null);
                            pt.addNode(new PTPoint(currentNode));
                        }
                    }
                } else {
                    stok.pushBack();
                }
            }
        }
        pt.setObjectName(s);
        pt.setColor(AnimalParseSupport.parseAndSetColor(stok, localType, "color"));
        AnimalParseSupport.parseAndSetDepth(stok, pt, localType);
        if (!localType.equalsIgnoreCase("line") && !localType.equalsIgnoreCase("polyline")) {
            boolean filled = ParseSupport.parseOptionalWord(stok, String.valueOf(localType) + " filled", "filled");
            Color fillColor = null;
            if (filled) {
                fillColor = AnimalParseSupport.parseColor(stok, "fillColor");
            }
            MessageDisplay.errorMsg("You used a polyline, but it was closed  and/or filled; please replace by polygon!", 4);
            PTPolygon shape = pt.convertToPolygon();
            shape.setFilled(filled);
            if (fillColor != null) {
                shape.setFillColor(fillColor);
            }
            BasicParser.addGraphicObject(shape, anim);
            oids.append(shape.getNum(false));
            BaseObjectParser.getObjectIDs().put(s, shape.getNum(false));
            BaseObjectParser.getObjectTypes().put(s, BaseObjectParser.getTypeIdentifier("polygon"));
            AnimalParseSupport.showComponents(stok, oids.toString(), localType, true);
            return;
        }
        pt.setFWArrow(ParseSupport.parseOptionalWord(stok, String.valueOf(localType) + " fw arrow", "fwArrow"));
        pt.setBWArrow(ParseSupport.parseOptionalWord(stok, String.valueOf(localType) + " bw arrow", "bwArrow"));
        BasicParser.addGraphicObject(pt, anim);
        oids.append(pt.getNum(false));
        BaseObjectParser.getObjectIDs().put(s, pt.getNum(false));
        BaseObjectParser.getObjectTypes().put(s, BaseObjectParser.getTypeIdentifier("polyline"));
        AnimalParseSupport.showComponents(stok, oids.toString(), localType, true);
    }

    public void parsePolygonInput() throws IOException {
        int i = 1;
        Point currentNode = null;
        PTPolygon pt = new PTPolygon();
        StringBuilder oids = new StringBuilder();
        String localType = ParseSupport.parseWord(stok, "Polygon type").toLowerCase();
        String s = AnimalParseSupport.parseText(stok, "Polygon object name");
        currentNode = AnimalParseSupport.parseNodeInfo(stok, String.valueOf(localType) + "node 1", null);
        PTPoint node1 = new PTPoint(currentNode);
        pt.addNode(node1);
        if (localType.equalsIgnoreCase("square")) {
            int sideLength = ParseSupport.parseInt(stok, String.valueOf(localType) + " side length");
            pt.addNode(new PTPoint(node1.getX(), node1.getY() + --sideLength));
            pt.addNode(new PTPoint(node1.getX() + sideLength, node1.getY() + sideLength));
            pt.addNode(new PTPoint(node1.getX() + sideLength, node1.getY()));
        } else {
            currentNode = AnimalParseSupport.parseNodeInfo(stok, String.valueOf(localType) + "node 2", null);
            PTPoint node2 = new PTPoint(currentNode);
            ++i;
            if (localType.equalsIgnoreCase("rectangle") || localType.equalsIgnoreCase("rect")) {
                pt.addNode(new PTPoint(node1.getX(), node2.getY()));
                pt.addNode(new PTPoint(node2.getX(), node2.getY()));
                pt.addNode(new PTPoint(node2.getX(), node1.getY()));
            } else if (localType.equalsIgnoreCase("relrect") || localType.equalsIgnoreCase("relrectangle")) {
                pt.addNode(new PTPoint(node1.getX(), node1.getY() + node2.getY() - 1));
                pt.addNode(new PTPoint(node1.getX() + node2.getX() - 1, node1.getY() + node2.getY() - 1));
                pt.addNode(new PTPoint(node1.getX() + node2.getX() - 1, node1.getY()));
            } else {
                pt.addNode(node2);
                if (ParseSupport.nextTokenIsNodeToken(stok)) {
                    currentNode = AnimalParseSupport.parseNodeInfo(stok, String.valueOf(localType) + "node 3", null);
                    PTPoint node3 = new PTPoint(currentNode);
                    ++i;
                    pt.addNode(node3);
                    if (!localType.equalsIgnoreCase("triangle")) {
                        while (ParseSupport.nextTokenIsNodeToken(stok)) {
                            currentNode = AnimalParseSupport.parseNodeInfo(stok, String.valueOf(localType) + "node " + ++i, null);
                            pt.addNode(new PTPoint(currentNode));
                        }
                    }
                } else {
                    stok.pushBack();
                }
            }
        }
        pt.setObjectName(s);
        pt.setColor(AnimalParseSupport.parseAndSetColor(stok, localType, "color"));
        AnimalParseSupport.parseAndSetDepth(stok, pt, localType);
        pt.setFilled(ParseSupport.parseOptionalWord(stok, String.valueOf(localType) + " filled", "filled"));
        if (pt.isFilled()) {
            pt.setFillColor(AnimalParseSupport.parseAndSetColor(stok, localType, "fillColor"));
        }
        BasicParser.addGraphicObject(pt, anim);
        oids.append(pt.getNum(false));
        BaseObjectParser.getObjectIDs().put(s, pt.getNum(false));
        BaseObjectParser.getObjectTypes().put(s, BaseObjectParser.getTypeIdentifier("polyline"));
        AnimalParseSupport.showComponents(stok, oids.toString(), localType, true);
    }

    public void parseRectangleInput() throws IOException {
        Point firstNode = null;
        Point secondNode = null;
        String localType = ParseSupport.parseWord(stok, "Rectangle type").toLowerCase();
        String s = AnimalParseSupport.parseText(stok, "Rectangle object name");
        firstNode = AnimalParseSupport.parseNodeInfo(stok, String.valueOf(localType) + "node 1", null);
        secondNode = AnimalParseSupport.parseNodeInfo(stok, String.valueOf(localType) + "node 2", null);
        if (localType.equalsIgnoreCase("relrect") || localType.equalsIgnoreCase("relrectangle")) {
            secondNode.translate(firstNode.x, firstNode.y);
        }
        PTRectangle rectangle = new PTRectangle(firstNode, secondNode);
        rectangle.setObjectName(s);
        this.finishPolygonParsing(rectangle, localType);
    }

    public void parseTriangleInput() throws IOException {
        String localType = ParseSupport.parseWord(stok, "Triangle type").toLowerCase();
        String s = AnimalParseSupport.parseText(stok, "Triangle object name");
        Point node1 = AnimalParseSupport.parseNodeInfo(stok, String.valueOf(localType) + "node 1", null);
        Point node2 = AnimalParseSupport.parseNodeInfo(stok, String.valueOf(localType) + "node 2", null);
        Point node3 = AnimalParseSupport.parseNodeInfo(stok, String.valueOf(localType) + "node 3", null);
        PTTriangle triangle = new PTTriangle(node1, node2, node3);
        triangle.setObjectName(s);
        this.finishPolygonParsing(triangle, localType);
    }

    private void finishPolygonParsing(PolygonalShape shape, String localType) throws IOException {
        shape.setColor(AnimalParseSupport.parseAndSetColor(stok, localType, "color"));
        AnimalParseSupport.parseAndSetDepth(stok, shape, localType);
        shape.setFilled(ParseSupport.parseOptionalWord(stok, String.valueOf(localType) + " filled", "filled"));
        if (shape.isFilled()) {
            shape.setFillColor(AnimalParseSupport.parseAndSetColor(stok, localType, "fillColor"));
        }
        BasicParser.addGraphicObject(shape, anim);
        StringBuilder oids = new StringBuilder();
        oids.append(shape.getNum(false));
        BaseObjectParser.getObjectIDs().put(shape.getObjectName(), shape.getNum(false));
        BaseObjectParser.getObjectTypes().put(shape.getObjectName(), BaseObjectParser.getTypeIdentifier("triangle"));
        AnimalParseSupport.showComponents(stok, oids.toString(), localType, true);
    }

    public void parseSquareInput() throws IOException {
        Point currentNode = null;
        String localType = ParseSupport.parseWord(stok, "Square type").toLowerCase();
        String s = AnimalParseSupport.parseText(stok, "Square object name");
        currentNode = AnimalParseSupport.parseNodeInfo(stok, String.valueOf(localType) + "node", null);
        int sideLength = ParseSupport.parseInt(stok, String.valueOf(localType) + " side length");
        PTSquare square = new PTSquare(currentNode.x, currentNode.y, --sideLength);
        square.setObjectName(s);
        this.finishPolygonParsing(square, localType);
    }

    public void parseTextInput() throws IOException {
        boolean isCentered = false;
        boolean isRightAligned = false;
        PTText pt = new PTText();
        StringBuilder oids = new StringBuilder();
        ParseSupport.parseMandatoryWord(stok, "Text type", "text");
        String s = AnimalParseSupport.parseText(stok, "Text object name");
        pt.setObjectName(s);
        pt.setText(AnimalParseSupport.parseText(stok, "Text component", "text", false, chosenLanguage));
        ParseSupport.parseOptionalWord(stok, "Text command 'at'(deprecated)", "at");
        Point basePoint = AnimalParseSupport.parseNodeInfo(stok, "text baseline", null);
        pt.setLocation(basePoint);
        BaseObjectParser.getObjectProperties().put(String.valueOf(s) + ".baseline", basePoint);
        isCentered = ParseSupport.parseOptionalWord(stok, "'centered' tag for Text", "centered");
        if (!isCentered) {
            isRightAligned = ParseSupport.parseOptionalWord(stok, "'right' tag for Text", "right");
        }
        pt.setColor(AnimalParseSupport.parseAndSetColor(stok, "text", "color"));
        AnimalParseSupport.parseAndSetDepth(stok, pt, "text");
        Font f = AnimalParseSupport.parseFontInfo(stok, "text");
        BaseObjectParser.getObjectProperties().put(String.valueOf(s) + ".font", f);
        pt.setFont(f);
        if (isCentered || isRightAligned) {
            FontMetrics fm = Animal.getConcreteFontMetrics(f);
            int translationWidth = fm.stringWidth(pt.getText());
            if (isCentered) {
                pt.translate(-(translationWidth >>> 1), 0);
            } else if (isRightAligned) {
                pt.translate(-translationWidth, 0);
            }
        }
        BasicParser.addGraphicObject(pt, anim);
        oids.append(pt.getNum(false));
        if (ParseSupport.parseOptionalWord(stok, "'boxed' tag for text", "boxed")) {
            Rectangle bBox = pt.getBoundingBox();
            int offsetX = 3;
            int offsetY = 3;
            int[] xNodes = new int[]{bBox.x - offsetX, bBox.x + bBox.width + offsetX, bBox.x + bBox.width + offsetX, bBox.x - offsetX};
            int[] yNodes = new int[]{bBox.y - offsetY, bBox.y - offsetY, bBox.y + bBox.height + offsetY, bBox.y + bBox.height + offsetY};
            PTPolygon textBox = new PTPolygon(xNodes, yNodes);
            if (pt.getDepth() == Integer.MAX_VALUE) {
                pt.setDepth(0x7FFFFFFE);
            }
            textBox.setDepth(pt.getDepth() + 1);
            textBox.setFilled(true);
            textBox.setColor(Color.black);
            textBox.setFillColor(AnimalParseSupport.parseAndSetColor(stok, "text box", "fillColor", "white"));
            textBox.setObjectName(String.valueOf(pt.getObjectName()) + ".box");
            BasicParser.addGraphicObject(textBox, anim);
            BaseObjectParser.getObjectTypes().put(String.valueOf(s) + ".box", BaseObjectParser.getTypeIdentifier("polyline"));
            oids.append(" ").append(textBox.getNum(false));
        }
        BaseObjectParser.getObjectIDs().put(s, oids.toString());
        BaseObjectParser.getObjectTypes().put(s, BaseObjectParser.getTypeIdentifier("text"));
        AnimalParseSupport.showComponents(stok, oids.toString(), "text", true);
    }

    public void chooseLanguage() {
        chosenLanguage = (String)JOptionPane.showInputDialog(null, "Choose a language", "Language Choice", 3, null, this.registeredLanguages, this.registeredLanguages[0]);
        if (chosenLanguage == null) {
            chosenLanguage = this.registeredLanguages[0];
        }
    }
}

