/*
 * Decompiled with CFR 0.152.
 */
package animalscript.core;

import animal.graphics.PTGraphicObject;
import animal.main.Link;
import animal.misc.MessageDisplay;
import animal.misc.ParseSupport;
import animal.misc.XProperties;
import animalscript.core.BasicParser;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import translator.AnimalTranslator;

public class BaseAdminProducer {
    private int locationCounter = 0;

    public void produceDelay(XProperties properties, Link currentLink) {
        if (currentLink != null && properties != null) {
            String delayMode = properties.getProperty("delay.type", "delay.time");
            if (delayMode.equals("delay.time")) {
                currentLink.setMode(2);
                currentLink.setTime(properties.getIntProperty("delay.time", 0));
            } else if (delayMode.equals("delay.clickOn")) {
                currentLink.setMode(4);
                currentLink.setTargetObjectID(properties.getIntProperty("delay.targetID", 0));
            } else {
                currentLink.setMode(1);
            }
        }
    }

    public void produceEcho(XProperties properties, XProperties objectIDs, XProperties objectProperties, int currentLine, int currentStep) {
        String echoMode = properties.getProperty("echo.mode", "text");
        StringBuilder sb = new StringBuilder(80);
        if (echoMode.equals("text")) {
            MessageDisplay.message("# " + properties.getProperty("echo.text"));
        } else if (echoMode.equals("location")) {
            Point p = properties.getPointProperty("echo.location", null);
            String invalid = "";
            if (p == null) {
                invalid = AnimalTranslator.translateMessage("invalidLocation");
            }
            if (p != null) {
                sb.append('(').append(p.x).append(", ").append(p.y).append(')');
            }
            this.showEchoMessage("echoLocation", new String[]{invalid, Integer.toString(currentLine), sb.toString()});
        } else if (echoMode.equals("boundingBox")) {
            int[] components;
            Rectangle bBox = null;
            String[] oids = properties.getStringArrayProperty("echo.boundingBoxIDs");
            BasicParser.animState.setStep(currentStep, false);
            Rectangle currentBounds = null;
            StringBuilder localBuffer = null;
            int i = 0;
            while (i < oids.length) {
                localBuffer = new StringBuilder(64);
                components = objectIDs.getIntArrayProperty(oids[i]);
                if (components != null) {
                    int j = 0;
                    while (j < components.length) {
                        int currentID = components[j];
                        if (currentID != -1) {
                            PTGraphicObject ptgo = BasicParser.animState.getCloneByNum(currentID);
                            bBox = ptgo.getBoundingBox();
                            currentBounds = currentBounds == null ? bBox : currentBounds.union(bBox);
                        } else {
                            this.showEchoMessage("echoUnknownSubcomponent", new String[]{Integer.toString(components[j]), oids[i]});
                        }
                        ++j;
                    }
                    localBuffer.append('(').append(currentBounds.x).append(", ");
                    localBuffer.append(currentBounds.y).append("), (");
                    localBuffer.append(currentBounds.x + currentBounds.width);
                    localBuffer.append(", ").append(currentBounds.y + currentBounds.height);
                    localBuffer.append(") ");
                    sb.append(AnimalTranslator.translateMessage("echoBounds", new String[]{oids[i], localBuffer.toString(), String.valueOf(currentStep), String.valueOf(currentLine)}));
                    if (i < oids.length - 1) {
                        sb.append("\n");
                    }
                } else {
                    this.showEchoMessage("echoObjectUnknown", new String[]{oids[i]});
                }
                currentBounds = null;
                MessageDisplay.message(sb.toString());
                ++i;
            }
            components = null;
        } else if (echoMode.equals("value")) {
            String[] oids = properties.getStringArrayProperty("echo.valueIDs");
            String result = null;
            int i = 0;
            while (i < oids.length) {
                result = objectProperties.getProperty(String.valueOf(oids[i]) + ".value", AnimalTranslator.translateMessage("unknownVar", new String[]{oids[i]}));
                this.showEchoMessage("echoValue", new String[]{oids[i], result});
                ++i;
            }
        } else if (echoMode.equals("ids")) {
            String[] oids = properties.getStringArrayProperty("echo.valueIDs");
            String result = null;
            int i = 0;
            while (i < oids.length) {
                result = objectIDs.getProperty(oids[i], AnimalTranslator.translateMessage("unknownVar", new String[]{oids[i]}));
                this.showEchoMessage("echoIDs", new String[]{oids[i], result});
                ++i;
            }
        } else if (echoMode.equals("visible")) {
            Enumeration<String> e = BasicParser.getCurrentlyVisible().keys();
            while (e.hasMoreElements()) {
                String value = e.nextElement();
                if (!"true".equalsIgnoreCase(BasicParser.getCurrentlyVisible().get(value))) continue;
                sb.append(" '").append(value).append("'");
            }
            this.showEchoMessage("echoVisible", new String[]{sb.toString()});
        } else if (echoMode.equals("rule")) {
            String rule = properties.getProperty("echo.ruleName");
            this.showEchoMessage("echoRule", new String[]{rule, properties.getProperty("echo.ruleValue")});
        }
        sb = null;
    }

    public void produceGrouping(XProperties properties, XProperties objectIDs, int nextGONum) {
        String targetID = properties.getProperty("group.groupID");
        String[] stringIDs = properties.getStringArrayProperty("group.targetOIDs");
        if (properties.getBoolProperty("group.mode")) {
            int[] targetIDs = ParseSupport.expandIDsFromStrings(stringIDs, objectIDs, nextGONum);
            StringBuilder sb = new StringBuilder(targetIDs.length * 5);
            int i = 0;
            while (i < targetIDs.length) {
                sb.append(targetIDs[i]).append(' ');
                ++i;
            }
            objectIDs.put(targetID, sb.toString());
        } else {
            int[] prunedIDs = objectIDs.getIntArrayProperty(targetID);
            int[] targetIDs = ParseSupport.expandIDsFromStrings(stringIDs, objectIDs, nextGONum);
            int nrEntries = 0;
            int i = 0;
            boolean[] keepThese = new boolean[nextGONum];
            i = 0;
            while (i < prunedIDs.length) {
                ++nrEntries;
                keepThese[prunedIDs[i]] = true;
                ++i;
            }
            i = 0;
            while (i < targetIDs.length) {
                if (keepThese[targetIDs[i]]) {
                    keepThese[targetIDs[i]] = false;
                    --nrEntries;
                } else {
                    MessageDisplay.errorMsg("Entry " + targetIDs[i] + " not included or removed twice", 4);
                }
                ++i;
            }
            StringBuilder resultingIDs = new StringBuilder(stringIDs.length * 3);
            i = 0;
            while (i < keepThese.length) {
                if (keepThese[i]) {
                    resultingIDs.append(i).append(" ");
                }
                ++i;
            }
            objectIDs.put(targetID, resultingIDs.toString());
        }
    }

    private void showEchoMessage(String key, String[] params) {
        MessageDisplay.message(AnimalTranslator.translateMessage(key, params));
    }

    public void produceLabel(XProperties properties, Link currentLink) {
        if (currentLink != null && properties != null) {
            currentLink.setLinkLabel(properties.getProperty("label.ID", "<<label>>"));
        }
    }

    public void produceLocation(XProperties properties, XProperties locations) {
        if (locations != null && properties != null) {
            String locationName = properties.getProperty("location.name");
            if (locationName == null) {
                locationName = "loc" + this.locationCounter++;
            }
            locations.put(locationName, properties.getPointProperty("location.point", BasicParser.origin));
        }
    }

    public void produceSwap(XProperties properties, XProperties objectIDs, int currentLine) {
        String firstName = properties.getProperty("swap.firstOID");
        String secondName = properties.getProperty("swap.secondOID");
        int firstID = objectIDs.getIntProperty(firstName, -1);
        int secondID = objectIDs.getIntProperty(secondName, -1);
        if (firstID != -1 && secondID != -2) {
            objectIDs.put(firstName, secondID);
            objectIDs.put(secondName, firstID);
        } else if (firstID == -1) {
            MessageDisplay.message("Object ID invalid: '" + firstName + "' in line " + currentLine);
        } else {
            MessageDisplay.message("Object ID invalid: '" + secondName + "' in line " + currentLine);
        }
    }
}

