/*
 * Decompiled with CFR 0.152.
 */
package animal.variables;

import animal.variables.BooleanVariable;
import animal.variables.ByteVariable;
import animal.variables.CharVariable;
import animal.variables.DoubleVariable;
import animal.variables.FloatVariable;
import animal.variables.IntVariable;
import animal.variables.LongVariable;
import animal.variables.ShortVariable;
import animal.variables.StringVariable;

public abstract class Variable {
    public static final String TYPE_BYTE = "byte";
    public static final String TYPE_SHORT = "short";
    public static final String TYPE_INT = "int";
    public static final String TYPE_LONG = "long";
    public static final String TYPE_FLOAT = "float";
    public static final String TYPE_DOUBLE = "double";
    public static final String TYPE_CHAR = "char";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_STRING = "String";
    private String name;
    private String type;
    private String frame;

    public static Variable create(String varName, String typeInfo, String initialValue, String activationFrame) {
        Variable result = null;
        if (TYPE_BOOLEAN.equals(typeInfo)) {
            result = new BooleanVariable(varName, activationFrame);
        } else if (TYPE_BYTE.equals(typeInfo)) {
            result = new ByteVariable(varName, activationFrame);
        } else if (TYPE_CHAR.equals(typeInfo)) {
            result = new CharVariable(varName, activationFrame);
        } else if (TYPE_DOUBLE.equals(typeInfo)) {
            result = new DoubleVariable(varName, activationFrame);
        } else if (TYPE_FLOAT.equals(typeInfo)) {
            result = new FloatVariable(varName, activationFrame);
        } else if (TYPE_INT.equals(typeInfo)) {
            result = new IntVariable(varName, activationFrame);
        } else if (TYPE_LONG.equals(typeInfo)) {
            result = new LongVariable(varName, activationFrame);
        } else if (TYPE_SHORT.equals(typeInfo)) {
            result = new ShortVariable(varName, activationFrame);
        } else if (TYPE_STRING.equals(typeInfo)) {
            result = new StringVariable(varName, activationFrame);
        }
        ((Variable)result).setValue(initialValue);
        return result;
    }

    public Variable(String varName, String typeInfo) {
        this(varName, typeInfo, "main");
    }

    public Variable(String varName, String typeInfo, String frameName) {
        this.setName(varName);
        this.setType(typeInfo);
        this.setFrame(frameName);
    }

    public String getFrame() {
        if (this.frame == null) {
            this.frame = "main";
        }
        return this.frame;
    }

    public void setFrame(String frame) {
        this.frame = frame;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    protected void setType(String type) {
        this.type = type;
    }

    public abstract void setValue(String var1);
}

