/*
 * Decompiled with CFR 0.152.
 */
package animal.misc;

import java.awt.Point;
import java.awt.Rectangle;

public final class MSMath {
    public static int sqr(int x) {
        return x * x;
    }

    public static double sqr(double x) {
        return x * x;
    }

    public static Point diff(Point a, Point b) {
        return new Point(a.x - b.x, a.y - b.y);
    }

    public static Point sum(Point a, Point b) {
        return new Point(a.x + b.x, a.y + b.y);
    }

    public static int innerProduct(Point a, Point b) {
        return a.x * b.x + a.y * b.y;
    }

    public static int dist(Point a, Point b) {
        return (int)Math.sqrt(MSMath.sqr(a.x - b.x) + MSMath.sqr(a.y - b.y));
    }

    public static int area(Point a, Point b, Point c) {
        return Math.abs(a.x * (b.y - c.y) + b.x * (c.y - a.y) + c.x * (a.y - b.y)) / 2;
    }

    public static int dist(Point p, Point a, Point b) {
        if (MSMath.innerProduct(MSMath.diff(p, a), MSMath.diff(b, a)) < 0) {
            return MSMath.dist(a, p);
        }
        if (MSMath.innerProduct(MSMath.diff(p, b), MSMath.diff(a, b)) < 0) {
            return MSMath.dist(b, p);
        }
        int d = MSMath.dist(a, b);
        if (d == 0) {
            return MSMath.dist(a, p);
        }
        return MSMath.area(a, b, p) / MSMath.dist(a, b) * 2;
    }

    public static int dist(Point p, Rectangle r) {
        if (r.contains(p)) {
            return 0;
        }
        Point ul = new Point(r.x, r.y);
        Point ur = new Point(r.x + r.width, r.y);
        Point ll = new Point(r.x, r.y + r.height);
        Point lr = new Point(r.x + r.width, r.y + r.height);
        int result = MSMath.dist(p, ul, ur);
        result = Math.min(result, MSMath.dist(p, ur, lr));
        result = Math.min(result, MSMath.dist(p, lr, ll));
        return Math.min(result, MSMath.dist(p, ll, ul));
    }

    public static double getAngle(Point a, Point b) {
        if (a == null || b == null) {
            return Double.NaN;
        }
        double t = -Math.atan((double)(b.y - a.y) / (double)(b.x - a.x));
        if (b.x < a.x) {
            if (t <= 0.0) {
                return t + Math.PI;
            }
            return t - Math.PI;
        }
        return t;
    }

    public static double getLength(Point a) {
        return Math.sqrt(MSMath.sqr(a.x) + MSMath.sqr(a.y));
    }
}

