/*
 * Decompiled with CFR 0.152.
 */
package animal.misc;

import animal.misc.AnimalFileFilter;
import animal.misc.AnimalFileView;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ImageFileChooser
extends JPanel {
    private static final long serialVersionUID = 4726774986152808324L;
    static JFrame frame;
    AnimalFileView fileView;
    FilePreviewer previewer;
    JFileChooser chooser = new JFileChooser();
    String currentExtension;
    public File chosenFile;
    public String filename;
    Image image = null;

    public ImageFileChooser() {
        this.fileView = new AnimalFileView();
        this.previewer = new FilePreviewer(this.chooser);
        this.chooser.setAccessory(this.previewer);
    }

    public void setAnimalLoadFilters() {
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("aml", "ASCII (compressed; preferred)"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("ama", "ASCII (uncompressed)"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("asc", "Compressed Scripting"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("asu", "Uncompressed Scripting"));
        this.chooser.removeChoosableFileFilter(this.chooser.getAcceptAllFileFilter());
        this.chooser.setFileFilter(this.chooser.getChoosableFileFilters()[0]);
    }

    public void setAnimalSaveFilters() {
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("aml", "ASCII (compressed; preferred)"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("ama", "ASCII (uncompressed)"));
        this.chooser.removeChoosableFileFilter(this.chooser.getAcceptAllFileFilter());
        this.chooser.setFileFilter(this.chooser.getChoosableFileFilters()[0]);
    }

    public void setImageFilters() {
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("apf", "APF Activated Pseudo-Format"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("bmp", "BMP Windows Bitmap format"));
        AnimalFileFilter theFilter = new AnimalFileFilter("jpg", "JPG JPEG format");
        this.chooser.addChoosableFileFilter(theFilter);
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("pcx", "PCX image format"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("pict", "PICT v2 format"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("png", "PNG image format"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("psd", "PSD Photoshop image format"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("ras", "SunRaster format"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("tga", "TGA image format"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("xbm", "XBM Bitmap format"));
        this.chooser.addChoosableFileFilter(new AnimalFileFilter("xpm", "XPM Pixelmap format"));
        this.chooser.setFileFilter(theFilter);
    }

    public void setImage(Image theImage) {
        this.image = theImage;
    }

    public Image openForLoad(JFrame aFrame) {
        this.chooser.setDialogType(0);
        int returnValue = this.chooser.showDialog(aFrame, null);
        if (returnValue == 0) {
            File theFile = this.chooser.getSelectedFile();
            if (theFile != null) {
                if (theFile.isDirectory()) {
                    JOptionPane.showMessageDialog(aFrame, "You chose this directory: " + this.chooser.getSelectedFile().getAbsolutePath());
                } else {
                    JOptionPane.showMessageDialog(aFrame, "You chose this file: " + this.chooser.getSelectedFile().getAbsolutePath());
                }
            }
        } else {
            JOptionPane.showMessageDialog(frame, "No file was chosen.");
        }
        return null;
    }

    public String openForSave(JFrame aFrame) {
        File theFile;
        this.chooser.setDialogType(1);
        int returnValue = this.chooser.showDialog(aFrame, null);
        System.err.println("Return value: " + returnValue);
        if (returnValue == 0 && (theFile = this.chooser.getSelectedFile()) != null && !theFile.isDirectory()) {
            String aFilename = this.chooser.getSelectedFile().getAbsolutePath();
            AnimalFileFilter filter = (AnimalFileFilter)this.chooser.getFileFilter();
            this.currentExtension = filter.getExtension();
            return String.valueOf(aFilename) + "." + this.currentExtension;
        }
        JOptionPane.showMessageDialog(frame, "No file was chosen.");
        return null;
    }

    public String getExtension() {
        return this.currentExtension;
    }

    public static void main(String[] s) {
        frame = new JFrame("ImageFileChooser");
        frame.pack();
        frame.setVisible(true);
        ImageFileChooser panel = new ImageFileChooser();
        panel.setAnimalLoadFilters();
        panel.openForSave(frame);
        System.exit(0);
    }

    class FilePreviewer
    extends JComponent
    implements PropertyChangeListener {
        private static final long serialVersionUID = 866103572991022625L;
        ImageIcon thumbnail = null;
        File f = null;

        public FilePreviewer(JFileChooser fc) {
            this.setPreferredSize(new Dimension(100, 50));
            fc.addPropertyChangeListener(this);
        }

        public void loadImage() {
            if (this.f != null) {
                ImageIcon tmpIcon = new ImageIcon(this.f.getPath());
                this.thumbnail = tmpIcon.getIconWidth() > 90 ? new ImageIcon(tmpIcon.getImage().getScaledInstance(90, -1, 1)) : tmpIcon;
            }
        }

        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop == "SelectedFileChangedProperty") {
                this.f = (File)e.getNewValue();
                if (this.isShowing()) {
                    this.loadImage();
                    this.repaint();
                }
            }
        }

        public void paint(Graphics g) {
            if (this.thumbnail == null) {
                this.loadImage();
            }
            if (this.thumbnail != null) {
                int x = this.getWidth() / 2 - this.thumbnail.getIconWidth() / 2;
                int y = this.getHeight() / 2 - this.thumbnail.getIconHeight() / 2;
                if (y < 0) {
                    y = 0;
                }
                if (x < 5) {
                    x = 5;
                }
                this.thumbnail.paintIcon(this, g, x, y);
            }
        }
    }
}

