/*
 * Decompiled with CFR 0.152.
 */
package animal.misc;

import animal.graphics.PTGraphicObject;
import animal.gui.AnimalMainWindow;
import animal.main.Animal;
import animal.main.AnimalConfiguration;
import animal.main.AnimalFrame;
import animal.main.Animation;
import animal.misc.MessageDisplay;
import animal.misc.ObjectTableModel;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import translator.AnimalTranslator;

public class HiddenObjectList
extends AnimalFrame
implements ListSelectionListener,
ActionListener {
    private static final long serialVersionUID = 6000473356719369903L;
    private Animation animation;
    private JTable objectTable;
    private int first = 0;
    private int last = 0;
    private JButton cancelButton;
    private JScrollPane scrollPane;
    private static final String[] rowLabels = new String[]{AnimalTranslator.translateMessage("holID"), AnimalTranslator.translateMessage("holType"), AnimalTranslator.translateMessage("holVisible"), AnimalTranslator.translateMessage("holInfo")};
    private ObjectTableModel otm = null;

    public HiddenObjectList(Animal animalInstance, Animation anim) {
        super(animalInstance, AnimalConfiguration.getDefaultConfiguration().getProperties());
        this.animation = anim;
        this.init();
    }

    public void init() {
        super.init();
        this.workContainer().setLayout(new BorderLayout(0, 0));
        this.buildTable();
        this.scrollPane = new JScrollPane(this.objectTable);
        JPanel buttonPanel = new JPanel();
        this.cancelButton = AnimalTranslator.getGUIBuilder().generateActionButton("GenericEditor.cancel", AnimalTranslator.getGUIBuilder().generateAction("GenericEditor.cancel", null, this, null, true));
        buttonPanel.add(this.cancelButton);
        this.workContainer().add("Center", this.scrollPane);
        this.workContainer().add("South", buttonPanel);
        this.setTitle("Object List");
        this.setSize(480, 320);
        this.setVisible(true);
    }

    public void setStep(int step) {
        if (this.otm == null) {
            this.initializeTableModel();
        }
        this.otm.setStep(step);
    }

    public void initializeTableModel() {
        this.otm = new ObjectTableModel();
        if (this.animation == null) {
            this.animation = Animal.get().getAnimation();
        }
        this.otm.setAnimation(this.animation);
        if (this.animation == null) {
            this.otm.setObjects(new Vector<PTGraphicObject>());
        } else {
            this.otm.setObjects(this.animation.getGraphicObjects());
        }
        this.objectTable = new JTable(this.otm);
    }

    public void buildTable() {
        this.setStep(AnimalMainWindow.getWindowCoordinator().getDrawWindow(false).getStep());
        TableColumn column = null;
        int i = 0;
        while (i < rowLabels.length) {
            column = this.objectTable.getColumnModel().getColumn(i);
            if (i == 0 || i == 2) {
                column.setPreferredWidth(20);
            } else if (i == 1) {
                column.setPreferredWidth(100);
            } else {
                column.setPreferredWidth(300);
            }
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton) {
            this.setVisible(false);
        }
    }

    public void initList(boolean getNewList) {
    }

    public int[] getObjectIDs() {
        return null;
    }

    public void cancelOperation() {
        this.setVisible(false);
    }

    public void hideSelected() {
        int[] selected = this.getObjectIDs();
        System.err.print("hide ");
        int i = 0;
        while (i < selected.length) {
            System.err.print(String.valueOf(selected[i]) + " ");
            ++i;
        }
    }

    void setStep(int step, boolean setOtherWindows) {
        this.setStep(step);
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.first = e.getFirstIndex();
            this.last = e.getLastIndex();
            MessageDisplay.message("holChanged", new Object[]{e.toString(), this.first, this.last});
        }
    }
}

