/*
 * Decompiled with CFR 0.152.
 */
package animal.misc;

import animal.exchange.AnimationImporter;
import animal.gui.AnimalMainWindow;
import animal.main.Animal;
import animal.main.AnimationWindow;
import animal.misc.MessageDisplay;
import animal.misc.XProperties;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import translator.AnimalTranslator;

public class AnimalRepositoryConnector
implements ActionListener {
    public static final String RESOURCE_FILENAME = "http://www.animal.ahrgr.de/Anims/animLister.php3";
    private XProperties properties = null;
    private JTable theTable = null;
    private String[] labels = null;
    private String[][] entries = null;
    private boolean refresh = true;
    private int urlPos = 0;
    private AbstractButton acceptButton;
    private AbstractButton cancelButton;
    private AbstractButton refreshButton;
    private JFrame theFrame;

    public boolean readTableEntries() {
        InputStream resourceStream;
        if (this.properties == null) {
            this.properties = new XProperties();
        }
        if ((resourceStream = this.getResourceStream()) == null) {
            return false;
        }
        try {
            this.properties.load(resourceStream);
        }
        catch (IOException ioException) {
            MessageDisplay.errorMsg("ioExcRepo", RESOURCE_FILENAME, 4);
        }
        int nrEntries = this.properties.getIntProperty("repository.size");
        this.entries = new String[nrEntries][6];
        this.labels = new String[]{AnimalTranslator.translateMessage("repExTitle"), AnimalTranslator.translateMessage("repExAuthor"), AnimalTranslator.translateMessage("repExSize"), AnimalTranslator.translateMessage("repExDate"), AnimalTranslator.translateMessage("repExURL"), AnimalTranslator.translateMessage("repExFormat")};
        int currentLine = 0;
        while (currentLine < nrEntries) {
            this.entries[currentLine][0] = this.convert(this.properties.getProperty(String.valueOf(currentLine) + ".title"));
            this.entries[currentLine][1] = this.properties.getProperty(String.valueOf(currentLine) + ".author");
            this.entries[currentLine][2] = this.properties.getProperty(String.valueOf(currentLine) + ".fileSize");
            this.entries[currentLine][3] = this.properties.getProperty(String.valueOf(currentLine) + ".date");
            this.entries[currentLine][4] = this.properties.getProperty(String.valueOf(currentLine) + ".URL");
            this.entries[currentLine][5] = this.properties.getProperty(String.valueOf(currentLine) + ".animationFormat");
            ++currentLine;
        }
        this.urlPos = 4;
        return true;
    }

    public String convert(String element) {
        return "<html><body>" + element + "</body></html>";
    }

    public JTable createTable() {
        if (this.labels == null || this.entries == null || this.refresh) {
            this.readTableEntries();
        }
        this.refresh = false;
        this.theTable = new JTable(this.entries, this.labels);
        this.theTable.setSelectionMode(0);
        return this.theTable;
    }

    public InputStream getResourceStream() {
        try {
            URL theURL = new URL(RESOURCE_FILENAME);
            if (theURL != null) {
                return theURL.openStream();
            }
        }
        catch (IOException e) {
            MessageDisplay.errorMsg(AnimalTranslator.translateMessage("repositoryConnectFailed"), 4);
        }
        return null;
    }

    public void actionPerformed(ActionEvent event) {
        int selectedRow;
        if (event.getSource() == this.cancelButton) {
            this.theFrame.setVisible(false);
        } else if (event.getSource() == this.refreshButton) {
            this.readTableEntries();
            this.createTable();
        } else if (event.getSource() == this.acceptButton && (selectedRow = this.theTable.getSelectedRow()) >= 0) {
            Animal.get();
            try {
                URL connector = new URL(this.entries[selectedRow][this.urlPos]);
                InputStream in = connector.openStream();
                AnimationImporter.importAnimation(in, this.entries[selectedRow][this.urlPos]);
                AnimationWindow animWin = AnimalMainWindow.getWindowCoordinator().getAnimationWindow(true);
                animWin.setVisible(true);
                animWin.startOfAnimation();
                animWin.setTitle("Animal Animation: " + this.entries[selectedRow][0]);
            }
            catch (IOException e) {
                MessageDisplay.errorMsg("repConnFailed", this.entries[selectedRow][this.urlPos], 4);
            }
        }
    }

    public boolean useRefresh() {
        return this.refresh;
    }

    public void buildGUI(String frameTitle) {
        if (this.theFrame != null) {
            this.theFrame.setVisible(true);
        } else {
            this.theFrame = new JFrame(frameTitle);
            this.theFrame.getContentPane().setLayout(new BorderLayout());
            this.theTable = this.createTable();
            JScrollPane scrollPane = new JScrollPane(this.theTable);
            this.theFrame.getContentPane().add("Center", scrollPane);
            JPanel buttonPanel = new JPanel();
            this.acceptButton = AnimalTranslator.getGUIBuilder().generateJButton("repAccept");
            this.refreshButton = AnimalTranslator.getGUIBuilder().generateJButton("repRefresh");
            this.cancelButton = AnimalTranslator.getGUIBuilder().generateJButton("repCancel");
            buttonPanel.add(this.acceptButton);
            buttonPanel.add(this.refreshButton);
            buttonPanel.add(this.cancelButton);
            this.acceptButton.addActionListener(this);
            this.refreshButton.addActionListener(this);
            this.cancelButton.addActionListener(this);
            this.theFrame.getContentPane().add("South", buttonPanel);
            this.theFrame.pack();
        }
    }

    public void setVisible(boolean isVisible) {
        if (this.theFrame != null) {
            this.theFrame.setVisible(isVisible);
        }
    }
}

