/*
 * Decompiled with CFR 0.152.
 */
package animal.main;

import animal.animator.Animator;
import animal.graphics.PTGraphicObject;
import animal.gui.GraphicVector;
import animal.gui.GraphicVectorEntry;
import animal.main.Animation;
import animal.misc.MessageDisplay;
import animal.variables.BooleanVariable;
import animal.variables.ByteVariable;
import animal.variables.CharVariable;
import animal.variables.DoubleVariable;
import animal.variables.FloatVariable;
import animal.variables.IntVariable;
import animal.variables.LongVariable;
import animal.variables.ShortVariable;
import animal.variables.StringVariable;
import animal.variables.Variable;
import java.util.TreeMap;
import java.util.Vector;
import translator.AnimalTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimationState {
    private Animation animation;
    private Vector<PTGraphicObject> allObjectClones = new Vector(400);
    private TreeMap<String, Variable> variables = new TreeMap();
    private Vector<Animator> nowAnimators = new Vector();
    private GraphicVector nowObjects = new GraphicVector();
    private int step = 0;

    public AnimationState(Animation targetAnimation) {
        this.animation = targetAnimation;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public PTGraphicObject getCloneByNum(int num) {
        PTGraphicObject result;
        if (num < 0) {
            return null;
        }
        int i = 0;
        while (i < this.allObjectClones.size()) {
            result = this.allObjectClones.elementAt(i);
            if (result.getNum(true) == num) {
                return result;
            }
            ++i;
        }
        System.err.println("clone of object " + num + " was not found in first attempt.");
        int j = 0;
        while (j < 2) {
            int i2 = 0;
            while (i2 < this.allObjectClones.size()) {
                result = this.allObjectClones.elementAt(i2);
                if (result.getNum(true) == num) {
                    return result;
                }
                ++i2;
            }
            if (j == 0) {
                if (this.animation.getGraphicObject(num) == null) break;
                int nowStep = this.step;
                this.reset();
                this.setStep(nowStep, false);
            }
            ++j;
        }
        MessageDisplay.errorMsg("cloneNotFound", new Integer[]{num, this.getStep()}, 16);
        return null;
    }

    public Vector<Animator> getCurrentAnimators() {
        return this.nowAnimators;
    }

    public GraphicVector getCurrentObjects() {
        return this.nowObjects;
    }

    public Vector<PTGraphicObject> getAllObjects() {
        return this.allObjectClones;
    }

    public TreeMap<String, Variable> getVariables() {
        this.variables.put("intey", new IntVariable("intey", 42, "main"));
        this.variables.put("doubley", new DoubleVariable("doubley", 42.4, "main"));
        this.variables.put("booley", new BooleanVariable("booley", false, "main"));
        this.variables.put("bytey", new ByteVariable("bytey", -2, "main"));
        this.variables.put("charey", new CharVariable("charey", 'X', "main"));
        this.variables.put("shortey", new ShortVariable("shortey", 17, "qs"));
        this.variables.put("longey", new LongVariable("longey", 123123123L, "main"));
        this.variables.put("floatey", new FloatVariable("floatey", -17.4f, "qw"));
        this.variables.put("stringey", new StringVariable("stringey", "StringDemo", "qr"));
        return this.variables;
    }

    public int getFirstRealStep() {
        return this.animation.getNextStep(0);
    }

    public int getLastStep() {
        return this.animation.getLastStep();
    }

    public int getNextStep() {
        return this.animation.getNextStep(this.step);
    }

    public int getPrevStep() {
        return this.animation.getPrevStep(this.step);
    }

    public int getStep() {
        return this.step;
    }

    public void reset() {
        this.allObjectClones.removeAllElements();
        if (this.animation == null) {
            return;
        }
        Vector<PTGraphicObject> go = this.animation.getGraphicObjects();
        this.allObjectClones.ensureCapacity(go.size());
        int i = 0;
        while (i < go.size()) {
            PTGraphicObject origin = go.elementAt(i);
            PTGraphicObject clonedObject = (PTGraphicObject)origin.clone();
            this.allObjectClones.addElement(clonedObject);
            ++i;
        }
        this.step = 0;
        this.allObjectClones.trimToSize();
        this.nowObjects.removeAllElements();
    }

    public boolean setStep(int targetStep, boolean delayed) {
        this.step = this.animation.verifyStep(targetStep);
        int[] path = this.animation.findWayToStep(targetStep, this.step);
        boolean result = true;
        if (path == null) {
            result = false;
        }
        this.reset();
        this.step = targetStep;
        if (path != null) {
            int i = 0;
            while (i < path.length) {
                this.nowObjects.nextStep();
                this.nowAnimators = this.animation.getAnimatorsAtStep(path[i]);
                int j = 0;
                while (j < this.nowAnimators.size()) {
                    int[] o;
                    int k;
                    int[] nums;
                    Animator a = this.nowAnimators.elementAt(j);
                    if (i < path.length - 1 || !delayed) {
                        a.init(this, 0L, 0.0);
                        a.execute();
                    }
                    if (a.isChangingAnimator() && a.isGraphicalObjectAnimator() && (nums = a.getObjectNums()) != null) {
                        k = 0;
                        while (k < nums.length) {
                            GraphicVectorEntry gve = this.nowObjects.getGVEByNum(nums[k]);
                            if (gve != null) {
                                gve.setAnimated();
                            }
                            ++k;
                        }
                    }
                    if (a.isGraphicalObjectAnimator() && (o = a.getTemporaryObjects()) != null) {
                        k = 0;
                        while (k < o.length) {
                            this.nowObjects.addElement(this.getCloneByNum(o[k]), 8);
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (!delayed) {
            this.nowAnimators = new Vector();
        }
        return result;
    }

    public void setQuickStep(int targetStep) {
        this.step = this.animation.verifyStep(targetStep);
        this.reset();
        this.nowObjects.nextStep();
        this.nowAnimators = this.animation.getAnimatorsAtStep(targetStep);
        int j = 0;
        while (j < this.nowAnimators.size()) {
            Animator a = this.nowAnimators.elementAt(j);
            a.init(this, 0L, 0.0);
            a.execute();
            ++j;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(80);
        sb.append(AnimalTranslator.translateMessage("animStateAtStep", this.step));
        return sb.toString();
    }
}

