/*
 * Decompiled with CFR 0.152.
 */
package animal.main;

import animal.animator.Move;
import animal.animator.TimedShow;
import animal.animator.VariableDeclaration;
import animal.animator.VariableUpdate;
import animal.dialog.HelpWindow;
import animal.editor.Editor;
import animal.exchange.AnimationExporter;
import animal.exchange.AnimationImporter;
import animal.graphics.PTBoxPointer;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTPoint;
import animal.graphics.PTPolyline;
import animal.graphics.meta.TextContainer;
import animal.gui.AnimalMainWindow;
import animal.gui.AnimalScriptInputWindow;
import animal.gui.AnimalStartUpProgress;
import animal.gui.AnimationControlToolBar;
import animal.gui.AnimationOverview;
import animal.gui.DrawWindow;
import animal.main.AnimalConfiguration;
import animal.main.AnimalFrame;
import animal.main.Animation;
import animal.main.AnimationCanvas;
import animal.main.AnimationState;
import animal.main.AnimationWindow;
import animal.main.ButtonController;
import animal.main.Link;
import animal.misc.AnimalFileChooser;
import animal.misc.AnimalRepositoryConnector;
import animal.misc.ComponentConfigurer;
import animal.misc.InteractionInterface;
import animal.misc.MessageDisplay;
import animal.misc.QuestionDummy;
import animal.misc.QuestionInterface;
import animal.misc.TrueFalseQuestionHandler;
import animal.misc.XProperties;
import animalscript.core.AnimalScriptParser;
import generator.AnimalGeneratorGUI;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JOptionPane;
import translator.AnimalTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Animal
extends AnimalFrame
implements ButtonController,
InteractionInterface {
    private static final long serialVersionUID = 2614942543305080965L;
    private static final String[] STARTUP_PROGRESS_LABELS = new String[]{"Creating new Animal instance", "Loading Animal properties", "Initializing default locale", "Initializing Animal", "Instantiate Animal main window", "Retrieving Animal components", "Reloading animation, if requested", "Checking command-line arguments", "Checking for command-line locale", "Loading command-line animation"};
    private static final boolean DEBUG = false;
    private static boolean LOCALE_INITIALIZED = false;
    private static boolean SHOW_PROGRESS_WINDOW = false;
    public static final String[] GLOBAL_FONTS = new String[]{"Serif", "SansSerif", "Monospaced"};
    public static final String GRAPHICOBJECTS_PREFIX = "PT";
    private static final String PROPERTY_HEADER = "Animal Properties";
    public static final int PROTOCOL_VERSION = 1;
    private static Animal animal = null;
    private static AnimalFileChooser animalFileChooser;
    private static AnimalRepositoryConnector animalRepositoryConnector;
    private static Locale currentLocale;
    private static long lastTime;
    private static int slideShowDelay;
    protected AnimalScriptInputWindow scriptInputWindow;
    protected static AnimalStartUpProgress ProgressPanel;
    private static boolean animationLoadFinished;
    private static boolean ALREADY_GOT_IT;
    private static AnimalConfiguration animalConfig;
    private static AnimalScriptParser animalScriptParser;
    private static InteractionInterface interactionHandlerFactory;
    private static AnimalGeneratorGUI generatorGUI;
    private Animation animation;
    private boolean autoloadLastFile = true;
    private boolean calcBoundingBox = false;
    private boolean compressFiles = true;
    private String defaultDirectory;
    private boolean isCompressed = true;
    private int lastChange = -1;
    private AnimalMainWindow animalMainWindow;

    static {
        animalRepositoryConnector = null;
        currentLocale = Locale.US;
        slideShowDelay = 1000;
        ProgressPanel = null;
        animationLoadFinished = false;
        ALREADY_GOT_IT = false;
        animalConfig = null;
        interactionHandlerFactory = null;
    }

    public Animal() {
        this(false, null);
    }

    public Animal(boolean appletUsage, URL codeBase) {
        super(null, null, appletUsage);
        this.setTitle("");
        runsInApplet = appletUsage;
        baseURL = codeBase;
    }

    public static int getStringWidth(String text, Font f) {
        int width = 0;
        FontMetrics fm = Animal.getConcreteFontMetrics(f);
        if (fm != null && text != null) {
            width = fm.stringWidth(text);
        }
        return width;
    }

    public static FontMetrics getConcreteFontMetrics(Font f) {
        Graphics graphics = Animal.get().getGraphics();
        if (graphics != null) {
            return graphics.getFontMetrics(f);
        }
        return Toolkit.getDefaultToolkit().getFontMetrics(f);
    }

    public static Animal get() {
        if (ALREADY_GOT_IT && animal != null) {
            return animal;
        }
        Animal.advanceProgressDisplay();
        if (animal == null) {
            animal = new Animal();
        }
        Animal.advanceProgressDisplay();
        animalConfig = Animal.getAnimalConfiguration();
        animalConfig.initializeImportFormats();
        animalConfig.initializeExportFormats();
        AnimationExporter.setAnimalConfig(animalConfig);
        AnimationImporter.setAnimalConfig(animalConfig);
        Animal.advanceProgressDisplay();
        if (!LOCALE_INITIALIZED) {
            animal.initLocale();
        }
        animalConfig.initializeInteractionHandler();
        ALREADY_GOT_IT = true;
        return animal;
    }

    public void initializeFileChooser() {
        if (!runsInApplet && animalFileChooser == null) {
            animalFileChooser = new AnimalFileChooser(Animal.getAnimalConfiguration());
            animalFileChooser.setAnimalLoadFilters();
            String defDir = Animal.getAnimalConfiguration().getProperty("animal.defaultDirectory");
            if (this.defaultDirectory != null) {
                animalFileChooser.setCurrentDirectory(defDir);
            }
        }
    }

    public AnimalMainWindow getMainWindow() {
        return this.animalMainWindow;
    }

    public static int getSlideShowDelay() {
        return slideShowDelay;
    }

    public static boolean animationLoadFinished() {
        return animationLoadFinished;
    }

    public static void setAnimationLoadFinished(boolean isFinished) {
        animationLoadFinished = isFinished;
    }

    public static void setSlideShowDelay(int delay) {
        slideShowDelay = delay;
    }

    public static void timedMessage(String text) {
        long now = System.currentTimeMillis();
        MessageDisplay.message(String.valueOf(text) + " " + (now - lastTime));
        lastTime = now;
    }

    public static InteractionInterface getInteractionHandler() {
        if (interactionHandlerFactory == null) {
            interactionHandlerFactory = Animal.get();
        }
        return interactionHandlerFactory;
    }

    @Override
    public QuestionInterface getHandlerFor(int interactionType, String questionID) {
        if (interactionType == 2) {
            return new TrueFalseQuestionHandler();
        }
        return new QuestionDummy(AnimalTranslator.translateMessage("questionNotYetSupported"));
    }

    public static void setInteractionHandlerFactory(InteractionInterface handlerInterface) {
        interactionHandlerFactory = handlerInterface;
    }

    public static AnimalConfiguration getAnimalConfiguration() {
        if (animalConfig == null) {
            animalConfig = new AnimalConfiguration();
        }
        return animalConfig;
    }

    @Override
    public String getWebRoot() {
        return Animal.getAnimalConfiguration().getProperty("animal.webroot", "http://www.animal.ahrgr.de");
    }

    @Override
    public void initialize(QuestionInterface question, boolean isConstructed, String text) {
        if (question instanceof TrueFalseQuestionHandler) {
            TrueFalseQuestionHandler localHandler = (TrueFalseQuestionHandler)question;
            localHandler.SetQuestion(text);
            localHandler.MakePanel();
        }
    }

    @Override
    public void performQuestionOperation(QuestionInterface question) {
        if (question instanceof TrueFalseQuestionHandler) {
            ((TrueFalseQuestionHandler)question).getComponent().setVisible(true);
            AnimationControlToolBar actb = AnimalMainWindow.getWindowCoordinator().getAnimationWindow(false).getAnimationControlToolBar();
            if (actb != null) {
                actb.enableControls(false);
            }
        } else {
            JOptionPane.showMessageDialog(this, AnimalTranslator.translateMessage("questionNotYetSupported"));
        }
    }

    @Override
    public void init() {
        String resourceName = "i18n/I18NGUIResources." + AnimalTranslator.getTranslator().getCurrentLocale();
        try {
            AnimalTranslator.addResource(resourceName);
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("Resource not found (ignore for now) " + resourceName);
        }
        Animal.advanceProgressDisplay();
        if (this.animalMainWindow == null) {
            this.animalMainWindow = new AnimalMainWindow(this, Animal.getAnimalConfiguration().getProperties(), false, false);
        }
        Animal.advanceProgressDisplay();
        Animal.getAnimalConfiguration().initializeAllEditors();
        Animal.advanceProgressDisplay();
        this.animalMainWindow.setVisible(true);
        this.initialized = true;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public String getAnimationFont() {
        return Animal.getAnimalConfiguration().getProperty("animal.animationFont", "SansSerif");
    }

    public void saneFontSizes() {
        Vector<PTGraphicObject> v = this.animation.getGraphicObjects();
        PTGraphicObject ptgo = null;
        TextContainer tc = null;
        int i = 0;
        while (i < v.size()) {
            Font f;
            ptgo = v.elementAt(i);
            if (ptgo != null && ptgo instanceof TextContainer && (f = (tc = (TextContainer)((Object)ptgo)).getFont()) != null) {
                int newSize = f.getSize();
                if ((newSize -= newSize % 2) < 8) {
                    newSize = 8;
                } else if (newSize > 16 && newSize < 22) {
                    newSize = 16;
                } else if (newSize > 22) {
                    newSize = 24;
                }
                Font fNeu = new Font(f.getName(), f.getStyle(), newSize);
                tc.setFont(fNeu);
            }
            ++i;
        }
        AnimalMainWindow.getWindowCoordinator().getDrawWindow(false).update();
        this.animation.doChange();
    }

    public boolean setAnimation(Animation newAnimation) {
        if (AnimalMainWindow.getWindowCoordinator().getDrawWindow(false).isInitialized()) {
            AnimalMainWindow.getWindowCoordinator().getDrawWindow(true).writeBack();
        }
        if (this.animation != null) {
            int result;
            if (AnimalMainWindow.getWindowCoordinator().getAnnotationEditor(false) != null && AnimalMainWindow.getWindowCoordinator().getAnnotationEditor(false).hasChanged() && (result = JOptionPane.showConfirmDialog(this, new String[]{AnimalTranslator.translateMessage("annotationsChanged"), AnimalTranslator.translateMessage("annotationSaveQuery")}, AnimalTranslator.translateMessage("annotationSave"), 1)) == 0) {
                AnimalMainWindow.getWindowCoordinator().getAnnotationEditor(false).saveAnnotationsAs();
            }
            if (this.hasChanged() && ((result = JOptionPane.showConfirmDialog(this, new String[]{AnimalTranslator.translateMessage("animationChanged"), AnimalTranslator.translateMessage("animationSaveQuery")}, AnimalTranslator.translateMessage("animationSave"), 1)) != 0 && result != 1 || result == 0 && !AnimationExporter.exportAnimation(this.animation))) {
                newAnimation.discard();
                return false;
            }
        }
        if (newAnimation == null) {
            newAnimation = new Animation();
        }
        newAnimation.register();
        this.animation = newAnimation;
        AnimalMainWindow.getWindowCoordinator().getAnimationWindow(false).setAnimation(newAnimation);
        if (AnimalMainWindow.getWindowCoordinator().getAnimationOverview(false) != null) {
            AnimalMainWindow.getWindowCoordinator().getAnimationOverview(false).setAnimation(newAnimation);
        }
        int firstVerifiedStep = newAnimation.verifyStep(newAnimation.getLink(0).getNextStep());
        AnimalMainWindow.getWindowCoordinator().getDrawWindow(true).setAnimation(newAnimation);
        AnimalMainWindow.getWindowCoordinator().getDrawWindow(false).setStep(firstVerifiedStep);
        AnimalMainWindow.getWindowCoordinator().getAnimationOverview(true).setStep(firstVerifiedStep, true);
        if (AnimalMainWindow.getWindowCoordinator().getTimeLineWindow(false) != null) {
            AnimalMainWindow.getWindowCoordinator().getTimeLineWindow(false).updateList(newAnimation);
        }
        this.resetChange();
        Animal.setAnimationLoadFinished(true);
        String label = newAnimation.getTitle();
        if (label == null || label.length() < 1) {
            label = AnimalTranslator.translateMessage("unnamed");
        }
        this.setFilename(label);
        AnimalMainWindow.getWindowCoordinator().getAnimationWindow(false).startOfAnimation();
        AnimalMainWindow.getWindowCoordinator().getAnimationWindow(false).setVisible(true);
        return true;
    }

    public AnimalScriptInputWindow getScriptInputWindow() {
        if (this.scriptInputWindow == null) {
            this.scriptInputWindow = new AnimalScriptInputWindow(animal);
            this.scriptInputWindow.initScriptingGUI();
        }
        return this.scriptInputWindow;
    }

    public void setAnimalScriptCode(String animationContent) {
        this.getScriptInputWindow().setScriptingContent(animationContent);
    }

    public void requestAnimationSave() {
        int result = 0;
        if (this.hasChanged() && ((result = JOptionPane.showConfirmDialog(this, new String[]{AnimalTranslator.translateMessage("animationChanged"), AnimalTranslator.translateMessage("animationSaveQuery")}, AnimalTranslator.translateMessage("animationSave"), 1)) != 0 && result != 1 || result == 0 && !AnimationExporter.exportAnimation(this.animation))) {
            this.animation.discard();
        }
    }

    public void setAnimationFont(String af) {
        if (af != null) {
            Animal.getAnimalConfiguration().getProperties().put("animal.animationFont", af);
            Vector<PTGraphicObject> v = this.animation.getGraphicObjects();
            TextContainer tc = null;
            int i = 0;
            while (i < v.size()) {
                PTGraphicObject o = v.elementAt(i);
                if (o instanceof TextContainer) {
                    PTGraphicObject ptt = v.elementAt(i);
                    tc = (TextContainer)((Object)ptt);
                    Font f = tc.getFont();
                    Font fNeu = new Font(af, f.getStyle(), f.getSize());
                    tc.setFont(fNeu);
                }
                ++i;
            }
            AnimalMainWindow.getWindowCoordinator().getDrawWindow(false).update();
            this.animation.doChange();
        }
    }

    public void simpleSetAnimation(Animation localAnimation) {
        localAnimation.register();
        this.animation = localAnimation;
        this.resetChange();
    }

    public void testAnimation(String message) {
        Link l = this.animation.getLink(0);
        AnimationState animationState = new AnimationState(this.animation);
        while (l != null && l.getStep() != Integer.MAX_VALUE) {
            animationState.setQuickStep(l.getStep());
            l = this.animation.getLink(l.getNextStep());
        }
        MessageDisplay.errorMsg(message, 2, true);
    }

    public static AnimalFileChooser getFileChooser() {
        return animalFileChooser;
    }

    private int retrieveBound(int objectBound, int minValue) {
        return objectBound < minValue ? minValue : objectBound;
    }

    private boolean saveProperties() {
        AnimationOverview animOverview;
        AnimationCanvas animationCanvas;
        AnimationWindow animationWindow;
        XProperties xprops = Animal.getAnimalConfiguration().getProperties();
        DrawWindow drawWindow = AnimalMainWindow.getWindowCoordinator().getDrawWindow(false);
        if (drawWindow != null && drawWindow.isInitialized()) {
            drawWindow.getProperties(xprops);
        }
        if ((animationWindow = AnimalMainWindow.getWindowCoordinator().getAnimationWindow(false)) != null && animationWindow.isInitialized()) {
            animationWindow.getProperties(xprops);
        }
        if ((animationCanvas = animationWindow.getAnimationCanvas()) != null) {
            animationCanvas.getProperties(xprops);
        }
        if ((animOverview = AnimalMainWindow.getWindowCoordinator().getAnimationOverview(false)) != null && animOverview.isInitialized()) {
            animOverview.getProperties(xprops);
        }
        Rectangle objectBounds = this.getBounds();
        xprops.put("animal.x", objectBounds.x);
        xprops.put("animal.y", objectBounds.y);
        xprops.put("animal.width", this.retrieveBound(objectBounds.width, 400));
        xprops.put("animal.height", this.retrieveBound(objectBounds.height, 200));
        objectBounds = AnimalMainWindow.getWindowCoordinator().getDrawWindow(false).getBounds();
        xprops.put("drawWindow.x", objectBounds.x);
        xprops.put("drawWindow.y", objectBounds.y);
        xprops.put("drawWindow.width", this.retrieveBound(objectBounds.width, 400));
        xprops.put("drawWindow.height", this.retrieveBound(objectBounds.height, 400));
        objectBounds = AnimalMainWindow.getWindowCoordinator().getAnimationOverview(false).getBounds();
        xprops.put("AnimationOverview.x", objectBounds.x);
        xprops.put("AnimationOverview.y", objectBounds.y);
        xprops.put("AnimationOverview.width", this.retrieveBound(objectBounds.width, 400));
        xprops.put("AnimationOverview.height", this.retrieveBound(objectBounds.width, 400));
        objectBounds = AnimalMainWindow.getWindowCoordinator().getAnimationWindow(false).getBounds();
        xprops.put("animationWindow.x", objectBounds.x);
        xprops.put("animationWindow.y", objectBounds.y);
        xprops.put("animationWindow.width", this.retrieveBound(objectBounds.width, 640));
        xprops.put("animationWindow.height", this.retrieveBound(objectBounds.width, 640));
        AnimationCanvas canvas = AnimalMainWindow.getWindowCoordinator().getAnimationWindow(false).getAnimationCanvas();
        if (canvas != null) {
            canvas.setMagnification(1.0);
            xprops.put("animationCanvas.width", canvas.getCurrentSize().width);
            xprops.put("animationCanvas.height", canvas.getCurrentSize().height);
        }
        xprops.put("animal.compressFiles", this.isCompressed);
        xprops.put("animal.DrawWindowVisible", drawWindow != null && drawWindow.isVisible());
        xprops.put("animal.ObjectsWindowVisible", AnimalMainWindow.getWindowCoordinator().getObjectsWindow(false) != null && AnimalMainWindow.getWindowCoordinator().getObjectsWindow(false).isVisible());
        xprops.put("animal.AnimationWindowVisible", AnimalMainWindow.getWindowCoordinator().getAnimationWindow(false) != null && AnimalMainWindow.getWindowCoordinator().getAnimationWindow(false).isVisible());
        xprops.put("animal.TimeLineWindowVisible", AnimalMainWindow.getWindowCoordinator().getTimeLineWindow(false) != null && AnimalMainWindow.getWindowCoordinator().getTimeLineWindow(false).isVisible());
        xprops.put("animal.AnimationOverviewVisible", AnimalMainWindow.getWindowCoordinator().getAnimationOverview(false) != null && AnimalMainWindow.getWindowCoordinator().getAnimationOverview(false).isVisible());
        this.defaultDirectory = animalFileChooser.getCurrentDirectoryName();
        xprops.put("animal.defaultDirectory", this.defaultDirectory);
        xprops.put("animal.autoloadLastFile", this.autoloadLastFile);
        if (Animal.getAnimalConfiguration().getProperty("animal.fileFormat", "***").equals("***")) {
            Animal.getAnimalConfiguration().setCurrentFormat("animation/animal-ascii-compressed");
        }
        xprops.put("animal.bBoxOnLoad", this.calcBoundingBox);
        try {
            xprops.store(new FileOutputStream("animal.properties"), PROPERTY_HEADER);
        }
        catch (IOException e) {
            MessageDisplay.errorMsg("errorSavingProperties", e.getMessage(), 16);
            return false;
        }
        return true;
    }

    public String getTime() {
        StringBuilder sb = new StringBuilder();
        GregorianCalendar calendar = new GregorianCalendar();
        sb.append('[').append(calendar.get(11));
        sb.append(':').append(calendar.get(12));
        sb.append(':').append(calendar.get(13)).append("] ");
        return sb.toString();
    }

    public boolean hasChanged() {
        return this.lastChange != this.animation.getLastChange();
    }

    public boolean isAutoloadLastFile() {
        return this.autoloadLastFile;
    }

    public boolean isCompressFiles() {
        return this.compressFiles;
    }

    public void resetChange() {
        this.animation.resetChange();
        AnimalMainWindow.getWindowCoordinator().getDrawWindow(false).setStep(this.animation.getNextStep(0));
        this.lastChange = this.animation.getLastChange();
    }

    public void setAutoloadLastFile(boolean b) {
        this.autoloadLastFile = b;
    }

    public void setCompressFiles(boolean b) {
        this.compressFiles = b;
    }

    public void setFilename(String filename) {
        if (filename != null) {
            this.setTitle("Animal Control Center - " + filename);
            AnimalMainWindow.getWindowCoordinator().getAnimationWindow(false).setTitle("Animal Animation: " + filename);
            AnimalMainWindow.getWindowCoordinator().getDrawWindow(false).setTitle("Animation Drawing Window: " + filename);
        } else {
            this.setTitle("Animal Control Center");
        }
    }

    public void demoAnimation() {
        Animation demoAnimation = new Animation();
        PTBoxPointer a = new PTBoxPointer(40, 20, "Alpha");
        a.setPointerPosition(1);
        a.setTip(0, 240, 30);
        demoAnimation.insertGraphicObject(a);
        demoAnimation.insertGraphicObject(new PTBoxPointer(240, 20, "Gamma"));
        demoAnimation.insertGraphicObject(new PTBoxPointer(200, 200, "Beta"));
        demoAnimation.insertAnimator(new TimedShow(1, new int[]{1, 2}, 0, "show", true));
        Move move = new Move(3, new int[]{1}, 15, "setTip", demoAnimation.insertGraphicObject(new PTPolyline(new PTPoint[]{new PTPoint(240, 30), new PTPoint(300, 100), new PTPoint(200, 210)})));
        move.setUnitIsTicks(true);
        demoAnimation.insertAnimator(move);
        move = new Move(3, new int[]{2}, 15, "translate", demoAnimation.insertGraphicObject(new PTPolyline(new PTPoint[]{new PTPoint(0, 0), new PTPoint(60, 0)})));
        move.setUnitIsTicks(true);
        demoAnimation.insertAnimator(move);
        demoAnimation.insertAnimator(new VariableDeclaration(2, "i", "int", "42", "main22a"));
        demoAnimation.insertAnimator(new VariableUpdate(3, "i", "4242"));
        move = new Move(3, new int[]{3}, 15, "setTip", demoAnimation.insertGraphicObject(new PTPolyline(new PTPoint[]{new PTPoint(250, 240), new PTPoint(300, 30)})));
        move.setUnitIsTicks(true);
        demoAnimation.insertAnimator(move);
        int line = demoAnimation.insertGraphicObject(new PTPolyline(new PTPoint[]{new PTPoint(100, 200), new PTPoint(40, 20)}));
        demoAnimation.insertAnimator(new Move(4, new int[]{3}, 2000, "translateWithFixedTip", line));
        move = new Move(4, new int[]{1}, 20, "setTip", line);
        move.setUnitIsTicks(true);
        demoAnimation.insertAnimator(move);
        demoAnimation.insertLink(new Link(0, 1));
        demoAnimation.insertLink(new Link(1, 2, 2000));
        demoAnimation.insertLink(new Link(2, 3));
        demoAnimation.insertLink(new Link(3, 4, 1000));
        demoAnimation.insertLink(new Link(4, Integer.MAX_VALUE));
        if (this.setAnimation(demoAnimation)) {
            MessageDisplay.addDebugMessage(AnimalTranslator.translateMessage("demoAnimation"));
        }
        this.setFilename(null);
    }

    public void openRepository() {
        boolean isOK = false;
        if (animalRepositoryConnector == null) {
            animalRepositoryConnector = new AnimalRepositoryConnector();
        }
        if (animalRepositoryConnector.useRefresh()) {
            isOK = animalRepositoryConnector.readTableEntries();
        }
        if (isOK) {
            animalRepositoryConnector.buildGUI(AnimalTranslator.translateMessage("repositoryTitle"));
        }
        animalRepositoryConnector.setVisible(true);
    }

    public void openGenerator() {
        if (generatorGUI == null) {
            generatorGUI = new AnimalGeneratorGUI(Animal.getCurrentLocale());
        } else {
            generatorGUI.displayWizard();
        }
    }

    public void newFile() {
        if (this.setAnimation(new Animation())) {
            this.setFilename(null);
            AnimationWindow animWin = Animal.getAnimalConfiguration().getWindowCoordinator().getAnimationWindow(false);
            animWin.setTitle(AnimalTranslator.translateMessage("animalAnimation"));
            this.resetChange();
            MessageDisplay.message(AnimalTranslator.translateMessage("newAnimation"));
        }
    }

    public void reloadFile() {
        AnimationImporter.importAnimation(Animal.getAnimalConfiguration().getCurrentFilename(), Animal.getAnimalConfiguration().getCurrentFormat());
    }

    public void setBBoxCalculation(boolean determineOnLoad) {
        this.calcBoundingBox = determineOnLoad;
    }

    @Override
    public boolean closeWindow() {
        if (!this.setAnimation(new Animation())) {
            return false;
        }
        this.saveProperties();
        System.exit(0);
        return true;
    }

    public void showTutorial() {
        HelpWindow helpWindow = new HelpWindow(this, Animal.getAnimalConfiguration().getProperties(), AnimalTranslator.translateMessage("tutorial.label"), AnimalTranslator.translateMessage("tutorialPath"));
        helpWindow.setVisible(true);
    }

    public Hashtable<String, Editor> getEditors() {
        return Animal.getAnimalConfiguration().getEditors();
    }

    public static boolean hasComponent(String componentName) {
        return Animal.get().getEditors().get(componentName) != null;
    }

    public Editor getEditor(String name) {
        return this.getEditor(name, true);
    }

    public Editor getEditor(String name, boolean yellOnError) {
        String editorName = name.startsWith(GRAPHICOBJECTS_PREFIX) ? name.substring(2) : name;
        Editor result = this.getEditors().get(editorName);
        if (result == null && !runsInApplet && yellOnError) {
            MessageDisplay.errorMsg("noEditorFor", name, 16);
        }
        return result;
    }

    public void showBoundingBox() {
        MessageDisplay.message("boundingBoxSize", new Object[]{this.getAnimation().getWidth(), this.getAnimation().getHeight()});
    }

    public void quitAnimal() {
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(this, 201));
        MessageDisplay.message(AnimalTranslator.translateMessage("thanksAndBye", AnimalConfiguration.getDefaultConfiguration().getVersionLine("versionInfoLine")));
    }

    public static AnimalScriptParser getAnimalScriptParser(boolean createNewParser) {
        if (animalScriptParser == null || createNewParser) {
            animalScriptParser = new AnimalScriptParser();
        }
        if (createNewParser) {
            animalScriptParser.clearTables();
        }
        return animalScriptParser;
    }

    public void configureComponents() {
        new ComponentConfigurer();
    }

    public static Locale getCurrentLocale() {
        return currentLocale;
    }

    public void initLocale() {
        String localeString = Animal.getAnimalConfiguration().getProperty("animal.Locale", "en_US");
        LOCALE_INITIALIZED = true;
        if (localeString == null) {
            this.setAnimalLocale(Locale.US);
        } else {
            this.setAnimalLocale(new Locale(localeString.substring(0, localeString.indexOf(95)), localeString.substring(localeString.indexOf(95) + 1)));
        }
    }

    public void setAnimalLocale(Locale targetLocale) {
        AnimalTranslator.setTranslatorLocale(targetLocale);
        Animal.getAnimalConfiguration().getProperties().put("animal.Locale", targetLocale.toString());
        if (this.isInitialized()) {
            MessageDisplay.message(AnimalTranslator.translateMessage("resLoaded"));
        }
        currentLocale = targetLocale;
        if (generatorGUI != null) {
            generatorGUI.setGeneratorLocale(targetLocale);
        }
    }

    @Override
    public boolean allowButtonAccess(int currentStep) {
        return true;
    }

    protected static void initializeProgressDisplay(String[] labels) {
        ProgressPanel = new AnimalStartUpProgress("Animal Start-Up", labels);
    }

    protected static void hideProgressDisplay() {
        if (ProgressPanel != null) {
            ProgressPanel.setInvisible();
        }
    }

    protected static void advanceProgressDisplay() {
        if (SHOW_PROGRESS_WINDOW) {
            if (ProgressPanel == null) {
                Animal.initializeProgressDisplay(STARTUP_PROGRESS_LABELS);
            }
            ProgressPanel.nextState();
        }
    }

    protected void parseArguments(String[] args) {
        if (args == null || args.length == 0) {
            return;
        }
        boolean explicitlyLoadAnimation = false;
        boolean showOnlyGenerators = false;
        boolean showGenerator = false;
        boolean topicMode = false;
        int generatorIndex = -1;
        int currentPos = 0;
        String generatorClass = null;
        int generatorType = -1;
        while (currentPos < args.length) {
            String currentArgument = args[currentPos];
            if (currentArgument.equalsIgnoreCase("-help")) {
                MessageDisplay.message(AnimalTranslator.translateMessage("animalUsage"));
            } else if (currentArgument.equals("--logOnly")) {
                MessageDisplay.message(AnimalTranslator.translateMessage("logOnlyDeprecated"));
            } else if (currentArgument.startsWith("-locale=")) {
                String lKey = currentArgument.substring(currentArgument.indexOf(61) + 1);
                if (lKey.equalsIgnoreCase("de_DE")) {
                    animal.setAnimalLocale(Locale.GERMANY);
                } else if (lKey.equalsIgnoreCase("it_IT")) {
                    animal.setAnimalLocale(Locale.ITALY);
                } else {
                    animal.setAnimalLocale(Locale.US);
                }
                Animal.advanceProgressDisplay();
            } else if (currentArgument.toLowerCase().startsWith("-generator")) {
                showOnlyGenerators = currentArgument.equalsIgnoreCase("-generatoronly");
                showGenerator = true;
                if (args.length > currentPos + 2 && args[currentPos + 1].equalsIgnoreCase("-generate")) {
                    String key = args[currentPos += 2];
                    topicMode = key.startsWith("topic=");
                    if (topicMode) {
                        String localKey;
                        String keyVal = key.substring(key.indexOf(61) + 1);
                        if (topicMode) {
                            generatorType = Integer.valueOf(keyVal);
                        }
                        if (args.length > currentPos + 1 && args[currentPos + 1].toLowerCase().startsWith("algorithm=") && (localKey = args[++currentPos].substring(args[currentPos].indexOf(61) + 1)) != null) {
                            generatorClass = localKey.substring(localKey.lastIndexOf(46) + 1);
                        }
                    } else {
                        --currentPos;
                    }
                }
            } else if (args.length >= 2 + currentPos) {
                if (Animal.getAnimalConfiguration().validImportFormat(currentArgument)) {
                    AnimationImporter.importAnimation(args[currentPos + 1], currentArgument);
                } else {
                    MessageDisplay.addDebugMessage(AnimalTranslator.translateMessage("wrongGuessInParamParsing"));
                }
                ++currentPos;
                Animal.advanceProgressDisplay();
                AnimationWindow animWin = AnimalMainWindow.getWindowCoordinator().getAnimationWindow(true);
                animWin.setVisible(true);
                animWin.startOfAnimation();
                explicitlyLoadAnimation = true;
            }
            ++currentPos;
        }
        String autoloadLastFileString = Animal.getAnimalConfiguration().getProperty("animal.autoloadLastFile", "false");
        this.autoloadLastFile = autoloadLastFileString.equalsIgnoreCase("true");
        if (showGenerator) {
            this.openGenerator();
            if (showOnlyGenerators) {
                MessageDisplay.message(AnimalTranslator.translateMessage("hideAllCurrentlyOff"));
            }
            if (topicMode) {
                int targetIndex = (int)(Math.log(generatorType) / Math.log(2.0));
                generatorGUI.setCategoryIndex(targetIndex);
                if (generatorGUI.setStateTo(0)) {
                    Animal.generatorGUI.wiz.showStep(1);
                } else {
                    generatorGUI.setCategoryIndex(-1);
                }
                if (generatorClass != null && (generatorIndex = Arrays.binarySearch(Animal.generatorGUI.keysForGeneratorInfos, generatorClass)) > -1) {
                    generatorGUI.setConcreteGenerator(generatorIndex);
                    if (generatorGUI.setStateTo(1)) {
                        Animal.generatorGUI.wiz.showStep(2);
                    } else {
                        generatorGUI.setStateTo(0);
                    }
                }
            }
        }
        if (!explicitlyLoadAnimation) {
            boolean success = false;
            if (this.autoloadLastFile) {
                success = AnimationImporter.importAnimation(animalConfig.getCurrentFilename(), Animal.getAnimalConfiguration().getCurrentFormat());
            }
            if (!success) {
                this.newFile();
            }
        }
        if (Animation.get() == null) {
            this.newFile();
        }
    }

    public static void main(String[] argv) {
        SHOW_PROGRESS_WINDOW = true;
        MessageDisplay.initialize(null, true, new XProperties());
        animal = Animal.get();
        animal.initializeFileChooser();
        Animal.advanceProgressDisplay();
        animal.init();
        Animal.advanceProgressDisplay();
        animal.parseArguments(argv);
        if (Animation.get() == null) {
            animal.newFile();
        }
        Animal.hideProgressDisplay();
        animalConfig.testIfUpToDate();
    }
}

