/*
 * Decompiled with CFR 0.152.
 */
package animal.gui;

import animal.gui.AnimalMainWindow;
import animal.main.Animal;
import animal.main.AnimalConfiguration;
import animal.main.Animation;
import animal.main.AnimationCanvas;
import animal.main.AnimationController;
import animal.main.AnimationListEntry;
import animal.main.AnimationState;
import animalscript.core.AnimalScriptParser;
import animalscript.core.BasicParser;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;
import translator.Translator;

public class MiniAnimationPlayer
implements ActionListener {
    AnimalConfiguration animalConfig;
    Animation animation;
    AnimationCanvas animationCanvas;
    boolean pause;
    boolean forwardMode;
    boolean slideShowMode;
    double ticks;
    double speed = 1.0;
    Timer timer;
    JFrame frame;
    private AbstractButton playButton;
    private AbstractButton pauseButton;
    private AbstractButton playReverseButton;
    private AbstractButton slideShowButton;
    private AbstractButton magicButton;
    AnimationController controller;

    public MiniAnimationPlayer(int width, int height) {
        this.initConfig(width, height);
    }

    public void initConfig(int width, int height) {
        Animal animal = Animal.get();
        animal.setAutoloadLastFile(false);
        this.animalConfig = Animal.getAnimalConfiguration();
        new AnimalMainWindow(animal, this.animalConfig.getProperties(), false, true);
        this.animalConfig.initializeAllEditors();
        this.animalConfig.initializeInteractionHandler();
        this.animation = new Animation();
        Animal.setAnimationLoadFinished(false);
        this.animationCanvas = new AnimationCanvas();
        this.animationCanvas.initSize();
        this.animationCanvas.setExplicitSize(new Dimension(width, height));
        this.animationCanvas.setVisible(true);
        this.frame = new JFrame("Demo Frame");
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add("Center", this.animationCanvas);
        this.frame.setSize(width, height + 50);
        this.createButtons();
        this.frame.setVisible(true);
        this.frame.repaint();
    }

    public AnimalScriptParser getParser(boolean useANewOne) {
        AnimalScriptParser aSP = Animal.getAnimalScriptParser(useANewOne);
        return aSP;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public void setAnimation(Animation newAnim) {
        this.animation = newAnim;
        if (this.controller == null) {
            this.controller = new AnimationController(this.animation, this.animationCanvas, new AnimationState(this.animation));
        } else {
            this.controller.setAnimation(this.animation);
        }
    }

    private void createButtons() {
        Translator translator = new Translator("AnimationPlayer", Locale.GERMANY);
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 0));
        this.pauseButton = translator.getGenerator().generateJButton("pauseButton", null, false, this);
        panel.add(this.pauseButton);
        this.playReverseButton = translator.getGenerator().generateJButton("playReverseButton", null, false, this);
        panel.add(this.playReverseButton);
        this.playButton = translator.getGenerator().generateJButton("playButton", null, false, this);
        panel.add(this.playButton);
        this.slideShowButton = translator.getGenerator().generateJButton("slideShowButton", null, false, this);
        panel.add(this.slideShowButton);
        this.magicButton = translator.getGenerator().generateJButton("magicButton", null, false, this);
        panel.add(this.magicButton);
        this.frame.getContentPane().add("South", panel);
    }

    public void dumpAnimation(Animation a) {
        if (a == null) {
            System.err.println("null");
        } else {
            AnimationListEntry[] entries = a.getAnimatorList();
            if (entries != null) {
                StringBuilder sbuffer = new StringBuilder(entries.length * 80);
                int i = 0;
                while (i < entries.length) {
                    AnimationListEntry ai = entries[i];
                    if (ai.mode == 1) {
                        sbuffer.append(ai.animator.toString());
                    }
                    if (ai.mode == 2) {
                        sbuffer.append(ai.link.toString());
                    }
                    sbuffer.append("\n");
                    ++i;
                }
                System.err.println(sbuffer.toString());
            }
        }
    }

    public void runDemo() {
        AnimalScriptParser parser = this.getParser(true);
        String animContents = this.readAnimationFromFile("C:\\Java\\temp.asu");
        if (BasicParser.stok == null) {
            parser.generateStreamTokenizer(animContents, false);
        }
        Animation anim = parser.importAnimationFrom(new StringReader(animContents), true);
        this.setAnimation(anim);
    }

    public String readAnimationFromFile(String filename) {
        StringBuilder fileContents = new StringBuilder(65536);
        try {
            InputStreamReader isr = null;
            isr = new InputStreamReader(new FileInputStream(filename));
            BufferedReader br = new BufferedReader(isr);
            String currentLine = null;
            while ((currentLine = br.readLine()) != null) {
                fileContents.append(currentLine).append("\n");
            }
            br.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return fileContents.toString();
    }

    public void validateButtons() {
        AnimationState cState = this.controller.getAnimationState();
        this.playButton.setEnabled(cState.getNextStep() != Integer.MAX_VALUE);
        this.slideShowButton.setEnabled(cState.getNextStep() != Integer.MAX_VALUE);
        this.playReverseButton.setEnabled(cState.getPrevStep() != 0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object source = actionEvent.getSource();
        if (source == this.pauseButton) {
            if (this.controller != null) {
                this.controller.pause();
            }
        } else if (source == this.playButton) {
            AnimationState cState;
            if (this.controller != null && (cState = this.controller.getAnimationState()).getNextStep() != Integer.MAX_VALUE) {
                this.controller.stepForward();
            }
        } else if (source == this.playReverseButton) {
            if (this.controller != null) {
                this.controller.stepBackward();
            }
        } else if (source == this.slideShowButton) {
            if (this.controller != null) {
                this.controller.play();
            }
        } else if (source == this.magicButton) {
            int currentStep = this.controller.getAnimationState().getStep();
            String secondPart = "\ntriangle \"t\" (10, 10) (20, 20) (10, 20) filled fillColor cyan\nmove \"t\" \"s\" along line (10, 10) (20, 20) within 1000 ms";
            AnimalScriptParser parser = this.getParser(false);
            parser.generateStreamTokenizer(secondPart, false);
            Animation anim2 = null;
            try {
                anim2 = parser.programImport(false);
            }
            catch (IOException e) {
                System.err.println("Could not load in animation for some reason...");
            }
            anim2.resetChange();
            this.setAnimation(anim2);
            this.controller.setStep(currentStep, true);
        } else if (source == this.timer) {
            System.err.println("MUST NOT HAPPEN THAT WE CALL timer on XXDemo!");
        }
        this.validateButtons();
    }

    public void zoom(double level) {
        this.animationCanvas.setMagnification(level);
    }

    public double getZoom() {
        return this.animationCanvas.getMagnification();
    }

    public static void main(String[] args) {
        MiniAnimationPlayer x = new MiniAnimationPlayer(640, 480);
        x.runDemo();
    }
}

