/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.graphics.PTArray;
import animal.graphics.PTText;
import java.awt.Font;

public class PTStringArray
extends PTArray {
    public static final String TYPE_LABEL = "StringArray";

    public PTStringArray() {
        this.initializeWithDefaults(this.getType());
        int targetSize = this.getSize();
        if (targetSize == 0) {
            targetSize = 10;
        }
        this.init(targetSize);
    }

    public PTStringArray(int nrEntries) {
        this();
        this.init(nrEntries);
    }

    public PTStringArray(String[] s) {
        this(s.length);
        int i = 0;
        while (i < s.length) {
            this.enterValue(i, s[i]);
            ++i;
        }
    }

    public Object clone() {
        PTStringArray targetShape = new PTStringArray();
        this.cloneCommonFeaturesInto(targetShape);
        return targetShape;
    }

    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL};
    }

    public int enterValue(int index, String val) {
        if (index >= 0 && index < this.entry.length) {
            this.entry[index].setText(val);
            int delta = index == 0 ? this.cellWidth(0) - this.entryPos[0] : this.cellWidth(index) - this.getBoundingBox((int)index).width;
            int i = index;
            while (i < this.entry.length) {
                if (i == index) {
                    this.resizeCell(i, delta, false);
                } else {
                    this.translate(i, delta, 0, true, true);
                }
                this.entryPos[i] = this.entryPos[i] + delta;
                ++i;
            }
            return 0;
        }
        return -1;
    }

    public String getValue(int index) {
        if (index >= 0 && index < this.entry.length) {
            return this.entry[index].getText();
        }
        return null;
    }

    public String getType() {
        return TYPE_LABEL;
    }

    public int getFileVersion() {
        return 3;
    }

    public void enterStringValueAt(int index, String text) {
        this.enterValue(index, text);
    }

    protected PTText createInternalValue(int cellPosition, Font targetFont) {
        return new PTText(String.valueOf((char)(97 + cellPosition)), targetFont);
    }
}

