/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.animator.MoveBase;
import animal.graphics.PTPoint;
import animal.graphics.meta.OpenArcBasedShape;
import animal.main.AnimalConfiguration;
import animal.misc.MSMath;
import animal.misc.XProperties;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class PTOpenCircleSegment
extends OpenArcBasedShape
implements Cloneable,
MoveBase {
    public static final String TYPE_LABEL = "OpenCircleSegment";
    private static final long serialVersionUID = 1311724437159551059L;
    private boolean isClockwise = false;
    private int radius;
    private int startAngle = 0;
    private int totalAngle = 45;

    public PTOpenCircleSegment() {
        this.initializeWithDefaults(this.getType());
    }

    public void paint(Graphics g) {
        double angle;
        if (this.center == null) {
            return;
        }
        g.setColor(this.color);
        g.drawArc(this.center.x - this.radius, this.center.y - this.radius, this.radius * 2, this.radius * 2, this.startAngle, this.totalAngle);
        if (this.hasFWArrow()) {
            angle = (double)(this.startAngle + this.totalAngle) * Math.PI / 180.0;
            this.drawArrow(g, angle, this.radius, this.radius, this.isClockwise());
        }
        if (this.hasBWArrow()) {
            angle = (double)this.startAngle * Math.PI / 180.0;
            this.drawArrow(g, angle, this.radius, this.radius, !this.isClockwise());
        }
    }

    public void rotate(double angle) {
        PTPoint centerNode = new PTPoint(this.center);
        centerNode.rotate(angle);
        this.center = centerNode.toPoint();
    }

    public void rotate(double angle, PTPoint centerPoint) {
        this.translate(-centerPoint.getX(), -centerPoint.getY());
        this.rotate(angle);
        this.translate(centerPoint.getX(), centerPoint.getY());
    }

    public void translate(int x, int y) {
        this.center.translate(x, y);
    }

    public void useAsMoveBase() {
    }

    public int getAngle(Point p) {
        int xdist = p.x - this.center.x;
        int ydist = p.y - this.center.y;
        if (this.radius == 0) {
            return -1;
        }
        int angle = (int)(MSMath.getAngle(this.center, new Point(this.center.x + xdist * 100 / this.radius, this.center.y + ydist * 100 / this.radius)) * 180.0 / Math.PI);
        if (angle < 0) {
            angle += 360;
        }
        return angle;
    }

    public Rectangle getBoundingBox() {
        return new Rectangle(this.center.x - this.radius, this.center.y - this.radius, this.radius * 2, this.radius * 2);
    }

    public int getFileVersion() {
        return 1;
    }

    public int getLength() {
        return Math.abs(this.getTotalAngle());
    }

    public Point getPointAtLength(int alpha) {
        double x = (double)alpha * Math.PI / 180.0;
        return new Point((int)((double)this.center.x + (double)this.radius * Math.cos(x)), (int)((double)this.center.y - (double)this.radius * Math.sin(x)));
    }

    public int getRadius() {
        return this.radius;
    }

    public int getStartAngle() {
        return this.startAngle;
    }

    public int getTotalAngle() {
        return this.totalAngle;
    }

    public String getType() {
        return TYPE_LABEL;
    }

    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL};
    }

    public void initializeWithDefaults(String primitiveName) {
        super.initializeWithDefaults(primitiveName);
        AnimalConfiguration config = AnimalConfiguration.getDefaultConfiguration();
        this.isClockwise = config.getDefaultBooleanValue(this.getType(), "clockwise", false);
        this.hasForwardArrow = config.getDefaultBooleanValue(this.getType(), "fwArrow", false);
        this.hasBackwardArrow = config.getDefaultBooleanValue(this.getType(), "bwArrow", false);
    }

    public boolean isClockwise() {
        return this.isClockwise;
    }

    public void setClockwise(boolean isOrientationClockwise) {
        if (this.isClockwise != isOrientationClockwise) {
            if (isOrientationClockwise) {
                this.setTotalAngle((this.getTotalAngle() - 360) % 360);
            } else {
                this.setTotalAngle((360 + this.getTotalAngle()) % 360);
            }
        }
        this.isClockwise = isOrientationClockwise;
    }

    public void setRadius(int r) {
        this.radius = r;
    }

    public void setStartAngle(int angle) {
        this.startAngle = angle;
    }

    public void setTotalAngle(int angle) {
        this.totalAngle = angle;
    }

    public void updateDefaults(XProperties defaultProperties) {
        super.updateDefaults(defaultProperties);
        defaultProperties.put(String.valueOf(this.getType()) + ".clockwise", this.isClockwise());
        defaultProperties.put(String.valueOf(this.getType()) + ".radius", this.getRadius());
        defaultProperties.put(String.valueOf(this.getType()) + ".startAngle", this.getStartAngle());
        defaultProperties.put(String.valueOf(this.getType()) + ".totalAngle", this.getTotalAngle());
    }

    public Object clone() {
        PTOpenCircleSegment targetShape = new PTOpenCircleSegment();
        this.cloneCommonFeaturesInto(targetShape);
        return targetShape;
    }

    protected void cloneCommonFeaturesInto(PTOpenCircleSegment targetShape) {
        super.cloneCommonFeaturesInto(targetShape);
        targetShape.setCenter(this.getCenter().x, this.getCenter().y);
        targetShape.setClockwise(this.isClockwise);
        targetShape.setRadius(this.getRadius());
        targetShape.setStartAngle(this.getStartAngle());
        targetShape.setTotalAngle(this.getTotalAngle());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PTOpenCircleSegment ");
        if (this.getObjectName() != null) {
            sb.append("\"").append(this.getObjectName()).append("\" ");
        }
        sb.append("center= (");
        sb.append(this.center.x).append(", ").append(this.center.y).append("), radius=");
        sb.append(this.radius).append(" starts at ");
        sb.append(this.getStartAngle()).append(", angle=").append(this.getTotalAngle());
        if (this.isClockwise) {
            sb.append(" clockwise");
        }
        if (this.hasForwardArrow) {
            sb.append(" fwArrow");
        }
        if (this.hasBackwardArrow) {
            sb.append(" bwArrow");
        }
        return sb.toString();
    }
}

