/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.editor.SpecialSelector;
import animal.handler.GraphicObjectHandler;
import animal.main.AnimalConfiguration;
import animal.main.Animation;
import animal.misc.EditableObject;
import animal.misc.MessageDisplay;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;

public abstract class PTGraphicObject
extends EditableObject
implements PropertyChangeListener {
    public static final String NAME_LABEL = "name";
    public static final String NODE_LABEL = "node";
    public static final String EMPTY_STRING = "";
    private static final long serialVersionUID = -20443585871477440L;
    public static Hashtable<String, String> registeredTypes = new Hashtable(43);
    public static Hashtable<String, GraphicObjectHandler> registeredHandlers = new Hashtable(43);
    protected int num;
    protected Color color = Color.BLACK;
    protected int depth = Integer.MAX_VALUE;
    protected String objectName = null;
    String numericIDs;

    public void initializeWithDefaults(String primitiveName) {
        AnimalConfiguration config = AnimalConfiguration.getDefaultConfiguration();
        this.depth = config.getDefaultIntValue(primitiveName, "depth", 50);
        this.color = config.getDefaultColor(primitiveName, "color", Color.BLACK);
    }

    public abstract void paint(Graphics var1);

    public void propertyChange(PropertyChangeEvent e) {
        if (this.getHandler() != null) {
            this.getHandler().propertyChange(this, e);
        } else {
            MessageDisplay.errorMsg("propertyChangePTGOIllegal", new String[]{this.getClass().getName()}, 8);
        }
    }

    public abstract void translate(int var1, int var2);

    public String baseOperationName(String method) {
        return method;
    }

    public boolean isCompatibleMethod(String method) {
        return false;
    }

    public boolean enableMultiSelectionFor(String operation) {
        return false;
    }

    public abstract Rectangle getBoundingBox();

    public Color getColor() {
        if (this.color == null) {
            this.color = AnimalConfiguration.getDefaultConfiguration().getDefaultColor(this.getType(), "color", Color.BLACK);
        }
        return this.color;
    }

    public int getDepth() {
        if (this.depth < 0) {
            this.depth = AnimalConfiguration.getDefaultConfiguration().getDefaultIntValue(this.getType(), "depth", 50);
        }
        return this.depth;
    }

    public int getFileVersion() {
        return 1;
    }

    public GraphicObjectHandler getHandler() {
        return registeredHandlers.get(this.getType());
    }

    public abstract String[] handledKeywords();

    public Point getLocation() {
        return this.getBoundingBox().getLocation();
    }

    public int getNum(boolean unique) {
        if (this.num == 0 && unique) {
            this.num = Animation.get().getUniqueGraphicObjectNum();
        }
        return this.num;
    }

    public String getNumericIDs() {
        return this.numericIDs;
    }

    public String getObjectName() {
        if (this.objectName == null || this.objectName.length() == 0) {
            this.objectName = String.valueOf(this.getNum(false));
        }
        return this.objectName;
    }

    public abstract String getType();

    public boolean operationRequiresSpecialSelector(String operation) {
        return false;
    }

    public SpecialSelector getSpecialSelectorForOperation(String operation) {
        return null;
    }

    public void resetNum() {
        this.num = 0;
    }

    public void setColor(Color newColor) {
        if (newColor != null) {
            this.color = newColor;
        }
    }

    public void setDepth(int newDepth) {
        this.depth = newDepth;
    }

    public void setLocation(Point targetPoint) {
        Point originPoint = this.getBoundingBox().getLocation();
        int dx = targetPoint.x - originPoint.x;
        int dy = targetPoint.y - originPoint.y;
        this.translate(dx, dy);
    }

    public void setObjectName(String newName) {
        this.objectName = newName;
    }

    public void setNum(int value) {
        this.num = value;
    }

    public void setNumericIDs(String ids) {
        this.numericIDs = ids;
    }

    protected void cloneCommonFeaturesInto(PTGraphicObject ptgo) {
        ptgo.setColor(this.createColor(this.color));
        ptgo.setDepth(this.depth);
        ptgo.setNum(this.getNum(false));
        if (this.objectName != null) {
            ptgo.setObjectName(new String(this.objectName));
        } else {
            ptgo.setObjectName(EMPTY_STRING);
        }
    }

    protected Color createColor(Color c) {
        if (c == null) {
            return Color.BLACK;
        }
        return new Color(c.getRed(), c.getGreen(), c.getBlue());
    }

    public void discard() {
        this.numericIDs = null;
    }

    public void updateDefaults(XProperties defaultProperties) {
        defaultProperties.put(String.valueOf(this.getType()) + ".depth", this.getDepth());
        defaultProperties.put(String.valueOf(this.getType()) + ".color", this.getColor());
    }
}

