/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.animator.MoveBase;
import animal.graphics.meta.ClosedArcBasedShape;
import animal.misc.MSMath;
import animal.misc.XProperties;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class PTEllipse
extends ClosedArcBasedShape
implements Cloneable,
MoveBase {
    public static final String TYPE_LABEL = "Ellipse";
    private static final long serialVersionUID = 4711724437359551059L;
    private Point radius = new Point(0, 0);

    public PTEllipse() {
        this.initializeWithDefaults(this.getType());
    }

    public void paint(Graphics g) {
        g.setColor(this.color);
        if (this.center == null) {
            return;
        }
        if (this.isFilled()) {
            g.setColor(this.fillColor);
            g.fillArc(this.center.x - this.radius.x, this.center.y - this.radius.y, this.radius.x * 2, this.radius.y * 2, 0, 360);
            g.setColor(this.color);
            if (!this.color.equals(this.fillColor)) {
                g.drawArc(this.center.x - this.radius.x, this.center.y - this.radius.y, this.radius.x * 2, this.radius.y * 2, 0, 360);
            }
        } else {
            g.drawArc(this.center.x - this.radius.x, this.center.y - this.radius.y, this.radius.x * 2, this.radius.y * 2, 0, 360);
        }
        g.setColor(this.color);
        if (!this.color.equals(this.fillColor)) {
            g.drawArc(this.center.x - this.radius.x, this.center.y - this.radius.y, this.radius.x * 2, this.radius.y * 2, 0, 360);
        }
    }

    public void translate(int x, int y) {
        this.center.translate(x, y);
    }

    public void useAsMoveBase() {
        this.setFilled(false);
    }

    public int getAngle(Point p) {
        int xRadius = this.getXRadius();
        int yRadius = this.getYRadius();
        Point localCenter = this.getCenter();
        int xdist = p.x - localCenter.x;
        int ydist = p.y - localCenter.y;
        if (xRadius == 0 || yRadius == 0) {
            return -1;
        }
        int angle = (int)(MSMath.getAngle(localCenter, new Point(localCenter.x + xdist * 100 / xRadius, localCenter.y + ydist * 100 / yRadius)) * 180.0 / Math.PI);
        if (angle < 0) {
            angle += 360;
        }
        return angle;
    }

    public Rectangle getBoundingBox() {
        Point localCenter = this.getCenter();
        return new Rectangle(localCenter.x - this.getXRadius(), localCenter.y - this.getYRadius(), this.getXRadius() * 2, this.getYRadius() * 2);
    }

    public int getFileVersion() {
        return 1;
    }

    public Point getPointAtAngle(int alpha) {
        Point localCenter = this.getCenter();
        double x = (double)alpha * Math.PI / 180.0;
        return new Point((int)((double)localCenter.x + (double)this.getXRadius() * Math.cos(x)), (int)((double)localCenter.y - (double)this.getYRadius() * Math.sin(x)));
    }

    public Point getPointAtLength(int alpha) {
        double x = (double)alpha * Math.PI / 180.0;
        return new Point((int)((double)this.center.x + (double)this.getXRadius() * Math.cos(x)), (int)((double)this.center.y - (double)this.getYRadius() * Math.sin(x)));
    }

    public Point getRadius() {
        return this.radius;
    }

    public String getType() {
        return TYPE_LABEL;
    }

    public int getXRadius() {
        return this.getRadius().x;
    }

    public int getYRadius() {
        return this.getRadius().y;
    }

    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL};
    }

    public void setRadius(Point targetRadius) {
        if (targetRadius != null) {
            this.setRadius(targetRadius.x, targetRadius.y);
        } else {
            this.setRadius(0, 0);
        }
    }

    public void setRadius(int radiusX, int radiusY) {
        this.radius = new Point(radiusX, radiusY);
    }

    public void setXRadius(int r) {
        this.setRadius(r, this.getYRadius());
    }

    public void setYRadius(int r) {
        this.setRadius(this.getXRadius(), r);
    }

    public void updateDefaults(XProperties defaultProperties) {
        super.updateDefaults(defaultProperties);
        defaultProperties.put(String.valueOf(this.getType()) + ".radius", this.getRadius());
    }

    public Object clone() {
        PTEllipse targetShape = new PTEllipse();
        this.cloneCommonFeaturesInto(targetShape);
        return targetShape;
    }

    protected void cloneCommonFeaturesInto(PTEllipse targetShape) {
        super.cloneCommonFeaturesInto(targetShape);
        targetShape.setCenter(this.getCenter().x, this.getCenter().y);
        targetShape.setRadius(this.getXRadius(), this.getYRadius());
    }

    public void discard() {
        this.setFillColor(null);
        this.color = null;
        this.center = null;
        this.radius = null;
        super.discard();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PTEllipse ");
        Point localCenter = this.getCenter();
        if (this.getObjectName() != null) {
            sb.append("\"").append(this.getObjectName()).append("\" ");
        }
        sb.append("center= (");
        sb.append(localCenter.x).append(", ").append(localCenter.y);
        sb.append("), radius (").append(this.getXRadius()).append(", ");
        sb.append(this.getYRadius()).append(")");
        return sb.toString();
    }

    public int getLength() {
        return 360;
    }
}

