/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.animator.MoveBase;
import animal.graphics.PTPoint;
import animal.graphics.PTPolyline;
import animal.graphics.PTText;
import animal.graphics.meta.ArcBasedShape;
import animal.graphics.meta.ImmediateTextContainer;
import animal.main.Animal;
import animal.main.AnimalConfiguration;
import animal.misc.MSMath;
import animal.misc.MessageDisplay;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import translator.AnimalTranslator;

public class PTArc
extends ArcBasedShape
implements MoveBase,
ImmediateTextContainer {
    public static final String TYPE_LABEL = "Arc";
    private static final long serialVersionUID = 4711724437159551059L;
    protected Color fillColor;
    protected boolean hasBackwardArrow;
    protected boolean hasForwardArrow;
    protected boolean hasTextComponent = false;
    protected boolean isCircular;
    protected boolean isClosed;
    protected boolean orientationIsClockwise;
    protected boolean isFilled;
    protected Point radius = new Point(10, 10);
    protected int startAngle = 0;
    protected PTText textComponent;
    protected int totalAngle = 720;

    public PTArc() {
        this.initializeWithDefaults(this.getType());
    }

    protected void drawArrow(Graphics g, Point tip, Point tail) {
        if (tip == null || tail == null) {
            MessageDisplay.errorMsg(AnimalTranslator.translateMessage("internalError", new String[]{"tip / tail null", "PTPolyline.drawArrow"}), 16);
            return;
        }
        int xDiff = tail.x - tip.x;
        int yDiff = tail.y - tip.y;
        int dist = MSMath.dist(tip, tail);
        if (dist > 0) {
            if (dist < 20) {
                dist = 20;
            }
            xDiff = xDiff * 20 / dist;
            yDiff = yDiff * 20 / dist;
            int[] x = new int[]{tip.x, tip.x + yDiff / 2 + xDiff, tip.x + xDiff / 2, tip.x - yDiff / 2 + xDiff};
            int[] y = new int[]{tip.y, tip.y - xDiff / 2 + yDiff, tip.y + yDiff / 2, tip.y + xDiff / 2 + yDiff};
            g.fillPolygon(x, y, 4);
        }
    }

    public boolean hasBWArrow() {
        return this.hasBackwardArrow;
    }

    public boolean hasFWArrow() {
        return this.hasForwardArrow;
    }

    public void initializeWithDefaults(String primitiveName) {
        super.initializeWithDefaults(primitiveName);
        this.center = new Point(0, 0);
        AnimalConfiguration config = AnimalConfiguration.getDefaultConfiguration();
        this.hasBackwardArrow = config.getDefaultBooleanValue(primitiveName, "bwArrow", false);
        this.hasForwardArrow = config.getDefaultBooleanValue(primitiveName, "fwArrow", false);
        this.isFilled = config.getDefaultBooleanValue(primitiveName, "filled", false);
        this.fillColor = config.getDefaultColor(primitiveName, "fillColor", Color.BLACK);
    }

    public void setBWArrow(boolean shallHaveBackwardArrow) {
        this.hasBackwardArrow = shallHaveBackwardArrow;
    }

    public void setFWArrow(boolean shallHaveForwardArrow) {
        this.hasForwardArrow = shallHaveForwardArrow;
    }

    public Object clone() {
        PTArc targetShape = new PTArc();
        this.cloneCommonFeaturesInto(targetShape);
        return targetShape;
    }

    protected void cloneCommonFeaturesInto(PTArc targetShape) {
        super.cloneCommonFeaturesInto(targetShape);
        targetShape.setArcAngle(this.totalAngle);
        targetShape.setBWArrow(this.hasBackwardArrow);
        targetShape.setCircle(this.isCircular);
        targetShape.setClockwise(this.orientationIsClockwise);
        targetShape.setClosed(this.isClosed);
        targetShape.setFilled(this.isFilled());
        targetShape.setFillColor(this.createColor(this.getFillColor()));
        targetShape.setFWArrow(this.hasForwardArrow);
        targetShape.setCenter(this.center.x, this.center.y);
        targetShape.setRadius(new Point(this.getXRadius(), this.getYRadius()));
        targetShape.setStartAngle(this.startAngle);
        targetShape.setText(new String(this.getTextComponent().getText()));
        targetShape.setTextColor(this.createColor(this.getTextComponent().getColor()));
    }

    public Color getFillColor() {
        if (this.fillColor == null) {
            this.fillColor = Color.BLACK;
        }
        return this.fillColor;
    }

    public boolean isFilled() {
        return this.isFilled;
    }

    public void setFilled(boolean filled) {
        this.isFilled = filled;
    }

    public void setFillColor(Color targetFillColor) {
        this.fillColor = targetFillColor;
    }

    private void drawArrow(Graphics g, double angle, boolean clockwise) {
        int xRadius = this.getXRadius();
        int yRadius = this.getYRadius();
        double before = angle + (double)(clockwise ? 1 : -1) * 1.0 / 100.0;
        double tipX = (double)this.center.x + (double)xRadius * Math.cos(angle);
        double tipY = (double)this.center.y - (double)yRadius * Math.sin(angle);
        double inclinationX = (double)this.center.x + (double)xRadius * Math.cos(before) - tipX;
        double inclinationY = (double)this.center.y - (double)yRadius * Math.sin(before) - tipY;
        double length = Math.sqrt(inclinationX * inclinationX + inclinationY * inclinationY);
        Point from = new Point((int)(tipX + inclinationX * (double)this.getRadius() / length), (int)(tipY + inclinationY * (double)this.getRadius() / length));
        PTPolyline.drawArrow(g, new Point((int)tipX, (int)tipY), from);
    }

    public void paint(Graphics g) {
        Point a;
        int xRadius = this.getXRadius();
        int yRadius = this.getYRadius();
        g.setColor(this.color);
        if (this.center == null) {
            return;
        }
        if (this.isFilled()) {
            g.setColor(this.fillColor);
            g.fillArc(this.center.x - xRadius, this.center.y - yRadius, xRadius * 2, yRadius * 2, this.startAngle, this.totalAngle);
            g.setColor(this.color);
            if (!this.fillColor.equals(this.color)) {
                g.drawArc(this.center.x - xRadius, this.center.y - yRadius, xRadius * 2, yRadius * 2, this.startAngle, this.totalAngle);
                if (this.totalAngle % 360 != 0) {
                    a = this.getPointAtAngle(this.startAngle);
                    g.drawLine(this.center.x, this.center.y, a.x, a.y);
                    a = this.getPointAtAngle(this.startAngle + this.totalAngle);
                    g.drawLine(this.center.x, this.center.y, a.x, a.y);
                }
            }
        } else {
            g.drawArc(this.center.x - xRadius, this.center.y - yRadius, xRadius * 2, yRadius * 2, this.startAngle, this.totalAngle);
            if (this.isClosed() && this.totalAngle % 360 != 0) {
                a = this.getPointAtAngle(this.startAngle);
                g.drawLine(this.center.x, this.center.y, a.x, a.y);
                a = this.getPointAtAngle(this.startAngle + this.totalAngle);
                g.drawLine(this.center.x, this.center.y, a.x, a.y);
            }
        }
        if (!this.isClosed() && !this.isFilled()) {
            if (this.hasFWArrow()) {
                double angle = (double)(this.startAngle + this.totalAngle) * Math.PI / 180.0;
                this.drawArrow(g, angle, this.isClockwise());
            }
            if (this.hasBWArrow()) {
                double angle = (double)this.startAngle * Math.PI / 180.0;
                this.drawArrow(g, angle, !this.isClockwise());
            }
        }
        if (this.hasTextComponent) {
            this.getTextComponent().paint(g);
        }
    }

    public void rotate(double angle) {
        PTPoint centerPoint = new PTPoint(this.getCenter());
        centerPoint.rotate(angle);
        this.setStartAngle((int)((long)this.getStartAngle() + Math.round(angle * 180.0 / Math.PI)));
    }

    public void rotate(double angle, PTPoint centerOfRotation) {
        this.translate(-centerOfRotation.getX(), -centerOfRotation.getY());
        this.rotate(angle);
        this.translate(centerOfRotation.getX(), centerOfRotation.getY());
    }

    public void translate(int x, int y) {
        this.center.translate(x, y);
    }

    public void useAsMoveBase() {
        this.setFilled(false);
        this.setClosed(false);
        this.setFWArrow(true);
        this.setBWArrow(false);
    }

    public int getAngle(Point p) {
        int xRadius = this.getXRadius();
        int yRadius = this.getYRadius();
        int xdist = p.x - this.center.x;
        int ydist = p.y - this.center.y;
        if (xRadius == 0 || yRadius == 0) {
            return -1;
        }
        int angle = (int)(MSMath.getAngle(this.center, new Point(this.center.x + xdist * 100 / xRadius, this.center.y + ydist * 100 / yRadius)) * 180.0 / Math.PI);
        if (angle < 0) {
            angle += 360;
        }
        return angle;
    }

    public int getArcAngle() {
        return this.totalAngle;
    }

    public Rectangle getBoundingBox() {
        return new Rectangle(this.center.x - this.getXRadius(), this.center.y - this.getYRadius(), this.getXRadius() * 2, this.getYRadius() * 2);
    }

    public int getLength() {
        return Math.abs(this.getArcAngle());
    }

    public Point getPointAtAngle(int alpha) {
        double x = (double)alpha * Math.PI / 180.0;
        return new Point((int)((double)this.center.x + (double)this.getXRadius() * Math.cos(x)), (int)((double)this.center.y - (double)this.getYRadius() * Math.sin(x)));
    }

    public Point getPointAtLength(int x) {
        return this.getPointAtAngle(this.getStartAngle() + (this.isClockwise() ? -1 : 1) * x);
    }

    public int getRadius() {
        return (this.getXRadius() + this.getYRadius()) / 2;
    }

    public Point getRadiusPoint() {
        if (this.radius == null) {
            this.radius = new Point(10, 10);
        }
        return this.radius;
    }

    public int getStartAngle() {
        return this.startAngle;
    }

    public PTText getTextComponent() {
        if (this.textComponent == null) {
            this.initTextComponent();
        }
        this.hasTextComponent = true;
        return this.textComponent;
    }

    public String getType() {
        return TYPE_LABEL;
    }

    public int getXRadius() {
        return this.getRadiusPoint().x;
    }

    public int getYRadius() {
        return this.getRadiusPoint().y;
    }

    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL};
    }

    public void initTextComponent() {
        this.textComponent = new PTText();
        this.textComponent.setText("");
        this.textComponent.setPosition(this.center);
    }

    public boolean isAngleInside(int angle) {
        if (this.isClockwise()) {
            if (-this.totalAngle < this.startAngle) {
                return angle < this.startAngle && angle > this.startAngle + this.totalAngle;
            }
            return angle < this.startAngle || angle > this.startAngle + this.totalAngle + 360;
        }
        if (this.startAngle + this.totalAngle < 360) {
            return angle > this.startAngle && angle < this.startAngle + this.totalAngle;
        }
        return angle > this.startAngle || angle < this.startAngle + this.totalAngle - 360;
    }

    public boolean isCircular() {
        return this.isCircular;
    }

    public boolean isClockwise() {
        return this.orientationIsClockwise;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void setArcAngle(int alpha) {
        this.totalAngle = alpha;
    }

    public void setCircle(boolean b) {
        this.isCircular = b;
        if (this.isCircular) {
            this.setRadius(this.getRadius());
        }
    }

    public void setClockwise(boolean clockwise) {
        if (this.orientationIsClockwise != clockwise) {
            this.orientationIsClockwise = clockwise;
            if (this.orientationIsClockwise) {
                this.setArcAngle(this.getArcAngle() - 360);
            } else {
                this.setArcAngle(360 + this.getArcAngle());
            }
        }
    }

    public void setClosed(boolean closed) {
        this.isClosed = closed;
    }

    public void setRadius(int r) {
        this.setRadius(new Point(r, r));
    }

    public void setRadius(Point newRadius) {
        if (newRadius != null) {
            if (this.radius == null) {
                this.radius = new Point(newRadius.x, newRadius.y);
            } else {
                this.radius.setLocation(newRadius.x, newRadius.y);
            }
        }
    }

    public void setStartAngle(int alpha) {
        this.startAngle = alpha;
    }

    public void setTextColor(Color aTextColor) {
        this.getTextComponent().setColor(aTextColor);
    }

    public void setXRadius(int r) {
        if (this.radius == null) {
            this.radius = new Point(r, r);
        } else {
            this.radius.x = r;
        }
    }

    public void setYRadius(int r) {
        if (this.radius == null) {
            this.radius = new Point(r, r);
        } else {
            this.radius.x = r;
        }
    }

    public void updateDefaults(XProperties defaultProperties) {
        super.updateDefaults(defaultProperties);
        defaultProperties.put(String.valueOf(this.getType()) + ".bwArrow", this.hasBWArrow());
        defaultProperties.put(String.valueOf(this.getType()) + ".circle", this.isCircular());
        defaultProperties.put(String.valueOf(this.getType()) + ".clockwise", this.isClockwise());
        defaultProperties.put(String.valueOf(this.getType()) + ".closed", this.isClosed());
        defaultProperties.put(String.valueOf(this.getType()) + ".fillColor", this.fillColor);
        defaultProperties.put(String.valueOf(this.getType()) + ".filled", this.isFilled());
        defaultProperties.put(String.valueOf(this.getType()) + ".fwArrow", this.hasFWArrow());
        if (this.isCircular()) {
            defaultProperties.put(String.valueOf(this.getType()) + ".radius", this.getRadius());
        } else {
            defaultProperties.put(String.valueOf(this.getType()) + ".radius", this.getRadiusPoint());
        }
        defaultProperties.put(String.valueOf(this.getType()) + ".startAngle", this.getStartAngle());
        defaultProperties.put(String.valueOf(this.getType()) + ".totalAngle", this.getArcAngle());
        if (this.textComponent != null) {
            defaultProperties.put(String.valueOf(this.getType()) + ".text", this.textComponent.getText());
            defaultProperties.put(String.valueOf(this.getType()) + ".textColor", this.textComponent.getColor());
            Font f = this.textComponent.getFont();
            defaultProperties.put(String.valueOf(this.getType()) + ".bold", f.isBold());
            defaultProperties.put(String.valueOf(this.getType()) + ".fontName", f.getFamily());
            defaultProperties.put(String.valueOf(this.getType()) + ".fontSize", f.getSize());
            defaultProperties.put(String.valueOf(this.getType()) + ".italic", f.isItalic());
        }
    }

    public void discard() {
        super.discard();
        this.fillColor = null;
        this.radius = null;
        this.textComponent = null;
    }

    public int getFileVersion() {
        return 5;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PTArc ");
        if (this.getObjectName() != null) {
            sb.append("\"").append(this.getObjectName()).append("\" ");
        }
        sb.append("(").append(this.center.x).append(", ").append(this.center.y);
        sb.append(") radius (").append(this.getXRadius()).append(", ");
        sb.append(this.getYRadius()).append(")");
        if (this.getStartAngle() != 0) {
            sb.append(" startAngle ").append(this.getStartAngle());
        }
        if (this.getArcAngle() % 360 != 0) {
            sb.append(" angle ").append(this.getArcAngle());
        }
        return sb.toString();
    }

    public Font getFont() {
        return this.getTextComponent().getFont();
    }

    public String getText() {
        return this.getTextComponent().getText();
    }

    public void setFont(Font targetFont) {
        this.getTextComponent().setFont(targetFont);
    }

    public void setText(String newText) {
        if (newText != null) {
            this.getTextComponent().setText(newText);
            Font currentFont = this.textComponent.getFont();
            int width = Animal.getStringWidth(newText, currentFont);
            this.textComponent.setPosition(this.center.x - width / 2, this.center.y + currentFont.getSize() / 2);
        }
    }
}

