/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalscript;

import animal.exchange.animalscript.PTGraphicObjectExporter;
import animal.graphics.PTBoxPointer;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTText;
import animal.misc.ColorChoice;
import java.awt.Color;
import java.awt.Point;

public class PTBoxPointerExporter
extends PTGraphicObjectExporter {
    public String getExportString(PTGraphicObject ptgo) {
        boolean hasText;
        StringBuilder sb = new StringBuilder(200);
        PTBoxPointer boxPointer = (PTBoxPointer)ptgo;
        if (PTBoxPointerExporter.getExportStatus(boxPointer)) {
            return "# previously exported: '" + boxPointer.getNum(false) + "/" + boxPointer.getObjectName();
        }
        sb.append("listElement \"").append(boxPointer.getObjectName()).append("\"");
        PTText textComponent = boxPointer.getTextComponent();
        boolean bl = hasText = textComponent.getText() != null;
        if (hasText) {
            sb.append(" \"").append(PTText.escapeText(textComponent.getText())).append("\"");
        }
        int nrPointers = boxPointer.getPointerCount();
        sb.append(" pointers ").append(nrPointers);
        sb.append(" position ");
        switch (boxPointer.getPointerPosition()) {
            case 3: {
                sb.append("top");
                break;
            }
            case 2: {
                sb.append("left");
                break;
            }
            case 1: {
                sb.append("right");
                break;
            }
            default: {
                sb.append("bottom");
            }
        }
        Point lastPoint = null;
        int i = 1;
        while (i <= nrPointers) {
            sb.append(" ptr").append(i).append(" (");
            lastPoint = boxPointer.getTip(i - 1);
            sb.append(lastPoint.x).append(", ").append(lastPoint.y).append(")");
            ++i;
        }
        Color color = boxPointer.getColor();
        sb.append(" color ").append(ColorChoice.getColorName(color));
        color = boxPointer.getTextBox().getFillColor();
        sb.append(" boxFillColor ").append(ColorChoice.getColorName(color));
        color = boxPointer.getPointerArea().getColor();
        sb.append(" pointerAreaColor ").append(ColorChoice.getColorName(color));
        color = boxPointer.getPointerArea().getFillColor();
        sb.append(" pointerAreaFillColor ").append(ColorChoice.getColorName(color));
        color = textComponent.getColor();
        sb.append(" textColor ").append(ColorChoice.getColorName(color));
        sb.append(" depth ");
        sb.append(boxPointer.getDepth());
        hasBeenExported.put(boxPointer, boxPointer.getObjectName());
        return sb.toString();
    }
}

