/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalascii;

import animal.exchange.animalascii.PTGraphicObjectImporter;
import animal.graphics.PTMatrix;
import animal.misc.MessageDisplay;
import animal.misc.ParseSupport;
import java.io.IOException;
import java.io.StreamTokenizer;

public abstract class PTMatrixImporter
extends PTGraphicObjectImporter {
    public Object importFrom(int version, StreamTokenizer stok) {
        PTMatrix matrix = this.createMatrix();
        try {
            int c;
            matrix.setPosition(ParseSupport.parseNode(stok, "Matrix node"));
            ParseSupport.parseMandatoryWord(stok, "Matrix keyword 'rowCount'", "rowCount");
            int rowCount = ParseSupport.parseInt(stok, "Matrix row count", 1);
            matrix.setRowCount(rowCount);
            ParseSupport.parseMandatoryWord(stok, "Matrix keyword 'columnsPerRow'", "columnsPerRow");
            int row = 0;
            while (row < rowCount) {
                matrix.setColumnCount(row, ParseSupport.parseInt(stok, "Matrix column count", 0));
                ++row;
            }
            ParseSupport.parseMandatoryWord(stok, "Matrix keyword 'data'", "data");
            ParseSupport.parseChar(stok, "Matrix keyword '{'", '{');
            int r = 0;
            while (r < rowCount) {
                ParseSupport.parseChar(stok, "Matrix keyword '('", '(');
                c = 0;
                while (c < matrix.getColumnCount(r)) {
                    this.setData(matrix, r, c, stok);
                    ++c;
                }
                ParseSupport.parseChar(stok, "Matrix keyword ')'", ')');
                ++r;
            }
            ParseSupport.parseChar(stok, "Matrix keyword '}'", '}');
            ParseSupport.parseMandatoryWord(stok, "Matrix keyword 'cellStatus'", "cellStatus");
            ParseSupport.parseChar(stok, "Matrix keyword '{'", '{');
            r = 0;
            while (r < matrix.getRowCount()) {
                ParseSupport.parseChar(stok, "Matrix keyword '('", '(');
                c = 0;
                while (c < matrix.getColumnCount(r)) {
                    matrix.setCellStatus((byte)ParseSupport.parseInt(stok, "Matrix cell status", -128, 127), r, c);
                    ++c;
                }
                ParseSupport.parseChar(stok, "Matrix keyword ')'", ')');
                ++r;
            }
            ParseSupport.parseChar(stok, "Matrix keyword '}'", '}');
            matrix.setColor(ParseSupport.parseColor(stok, "Matrix color", "color"));
            matrix.setFillColor(ParseSupport.parseColor(stok, "Matrix fillColor", "fillColor"));
            matrix.setHighlightColor(ParseSupport.parseColor(stok, "Matrix highlightColor", "highlightColor"));
            matrix.setElemHighlightColor(ParseSupport.parseColor(stok, "Matrix elemHighlightColor", "elemHighlightColor"));
            matrix.setTextColor(ParseSupport.parseColor(stok, "Matrix textColor", "textColor"));
            ParseSupport.parseMandatoryWord(stok, "Matrix keyword 'fillStatus'", "fillStatus");
            matrix.setFilled(1 == ParseSupport.parseInt(stok, "Matrix fill status", 0, 1));
            ParseSupport.parseMandatoryWord(stok, "Matrix keyword 'margins'", "margins");
            matrix.setMargin(0, ParseSupport.parseInt(stok, "Matrix margin", 0));
            matrix.setMargin(1, ParseSupport.parseInt(stok, "Matrix margin", 0));
            matrix.setMargin(2, ParseSupport.parseInt(stok, "Matrix margin", 0));
            matrix.setMargin(3, ParseSupport.parseInt(stok, "Matrix margin", 0));
            ParseSupport.parseMandatoryWord(stok, "Matrix keyword 'textAlignment'", "textAlignment");
            matrix.setTextAlignment(PTMatrix.Alignment.valueOf(ParseSupport.parseText(stok, "Matrix text alignment")));
            ParseSupport.parseMandatoryWord(stok, "Matrix keyword 'rowAlignment'", "rowAlignment");
            matrix.setRowAlignment(PTMatrix.Alignment.valueOf(ParseSupport.parseText(stok, "Matrix row alignment")));
            matrix.setFont(ParseSupport.parseFontInformation(stok, "Matrix font settings"));
            this.parseEndingValuesFrom(stok, matrix, "Matrix");
        }
        catch (IOException e) {
            MessageDisplay.errorMsg(e.getMessage(), 4);
        }
        return matrix;
    }

    abstract void setData(PTMatrix var1, int var2, int var3, StreamTokenizer var4);

    abstract PTMatrix createMatrix();
}

