/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange;

import animal.animator.Animator;
import animal.exchange.AnimalASCIIImporter;
import animal.exchange.AnimationExporter;
import animal.exchange.xaal.AnimatorExporter;
import animal.exchange.xaal.Exporter;
import animal.exchange.xaal.LinkExporter;
import animal.exchange.xaal.PTGraphicObjectExporter;
import animal.graphics.PTGraphicObject;
import animal.main.Animal;
import animal.main.AnimalConfiguration;
import animal.main.AnimationListEntry;
import animal.main.Link;
import animal.misc.MessageDisplay;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XAALExporter
extends AnimationExporter {
    protected Animal animal;
    private String extension = null;
    private boolean isCompressed = true;

    @Override
    public boolean exportAnimationTo(String fileName) {
        if (this.animal == null) {
            this.animal = Animal.get();
            this.animal.getEditors();
        }
        FilterOutputStream oStream = null;
        this.filename = fileName;
        String fileExtension = this.getDefaultExtension();
        if (!this.filename.endsWith(fileExtension)) {
            this.filename = String.valueOf(this.filename) + "." + fileExtension;
        }
        try {
            oStream = new BufferedOutputStream(new FileOutputStream(this.filename));
            if (this.isCompressed) {
                oStream = new GZIPOutputStream(oStream);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            MessageDisplay.errorMsg(fileNotFoundException.getMessage(), 4);
        }
        catch (IOException ioException) {
            MessageDisplay.errorMsg(ioException.getMessage(), 4);
        }
        if (oStream == null) {
            return false;
        }
        return this.exportAnimationTo(oStream);
    }

    private void printMetadata(PrintWriter writer) {
        writer.println("  <metadata>");
        this.printAuthor(writer);
        this.printApplicationInfo(writer);
        this.printAnimationInfo(writer);
        writer.println("  </metadata>");
    }

    private void printApplicationInfo(PrintWriter writer) {
        writer.println("    <application>");
        writer.println("      <name>Animal</name>");
        writer.print("      <version>");
        writer.print(AnimalConfiguration.getDefaultConfiguration().getVersionNumber());
        writer.println("</version>");
        writer.println("      <homepage>http://www.animal.ahrgr.de/index.php3</homepage>");
        writer.println("    </application>");
    }

    private void printAnimationInfo(PrintWriter writer) {
        writer.println("    <animation-info>");
        writer.print("      <title>");
        writer.print(this.animationToExport.getTitle());
        writer.println("</title>");
        writer.println("      <subject>Animal Algorithm Animation</subject>");
        writer.println("      <desc>No description available</desc> ");
        writer.println("      <keyword>Animal</keyword>");
        writer.println("    </animation-info>");
    }

    private void printAuthor(PrintWriter writer) {
        String animationAuthor;
        String currentString = animationAuthor = this.animationToExport.getAuthor();
        if (animationAuthor == null || animationAuthor.length() == 0 || "<author unknown>".equals(animationAuthor)) {
            animationAuthor = "Dr. Guido Roessling <roessling@acm.org>";
        }
        String firstName = null;
        String lastName = null;
        String affiliation = null;
        String email = null;
        int atIndex = currentString.indexOf(64);
        if (atIndex > -1) {
            int emailStart = currentString.lastIndexOf(32, atIndex);
            email = currentString.substring(emailStart);
            currentString = animationAuthor.substring(0, emailStart - 1);
        }
        int lastSpace = currentString.lastIndexOf(32);
        lastName = currentString.substring(lastSpace + 1);
        firstName = currentString.substring(0, lastSpace - 1);
        writer.println("    <author>");
        writer.print("      <firstname>");
        writer.print(firstName);
        writer.println("</firstname>");
        writer.print("      <lastname>");
        writer.print(lastName);
        writer.println("</lastname>");
        writer.print("      <affiliation>");
        writer.print(affiliation);
        writer.println("</affiliation>");
        writer.print("      <email>");
        writer.print(email);
        writer.println("</email>");
        writer.println("    </author>");
    }

    public boolean exportAnimationTo(OutputStream oStream) {
        Hashtable<String, Exporter> asciiExporters = new Hashtable<String, Exporter>(73);
        PrintWriter writer = new PrintWriter(oStream);
        writer.println("<xaal version=\"1\">");
        this.printMetadata(writer);
        Vector<PTGraphicObject> allGraphicObjects = this.animationToExport.getGraphicObjects();
        int nrGOs = allGraphicObjects.size();
        int i = 0;
        while (i < nrGOs) {
            this.exportGraphicObject(allGraphicObjects.elementAt(i), asciiExporters, writer);
            ++i;
        }
        writer.println("STEPS:");
        AnimationListEntry[] localinfo = this.animationToExport.getAnimatorList();
        if (localinfo != null) {
            i = 0;
            while (i < localinfo.length) {
                AnimationListEntry ali = localinfo[i];
                if (ali.mode == 1) {
                    this.exportAnimator(ali.animator, asciiExporters, writer);
                } else {
                    this.exportLink(ali.link, asciiExporters, writer);
                }
                ++i;
            }
        }
        writer.print("Next ");
        writer.println(this.animationToExport.getNextGraphicObjectNum());
        localinfo = null;
        writer.close();
        return true;
    }

    private void exportLink(Link link, Hashtable<String, Exporter> asciiExporters, PrintWriter writer) {
        String className = link.getClass().getName();
        StringBuilder handlerName = new StringBuilder("animal.exchange.animalascii.");
        handlerName.append(className.substring(className.lastIndexOf(46) + 1));
        handlerName.append("Exporter");
        String subName = handlerName.toString();
        try {
            if (!asciiExporters.containsKey(subName)) {
                Class<?> c = Class.forName(subName);
                LinkExporter handler = (LinkExporter)c.newInstance();
                asciiExporters.put(subName, handler);
            }
            ((LinkExporter)asciiExporters.get(subName)).exportTo(writer, link);
        }
        catch (Exception e) {
            MessageDisplay.errorMsg(AnimalASCIIImporter.translateMessage("exportException", subName, className, e.getMessage()), 4);
        }
    }

    private void exportAnimator(Animator animator, Hashtable<String, Exporter> asciiExporters, PrintWriter writer) {
        String className = animator.getClass().getName();
        StringBuilder handlerName = new StringBuilder("animal.exchange.animalascii.");
        handlerName.append(className.substring(className.lastIndexOf(46) + 1));
        handlerName.append("Exporter");
        String subName = handlerName.toString();
        try {
            if (!asciiExporters.containsKey(subName)) {
                Class<?> c = Class.forName(subName);
                AnimatorExporter handler = (AnimatorExporter)c.newInstance();
                asciiExporters.put(subName, handler);
            }
            ((AnimatorExporter)asciiExporters.get(subName)).exportTo(writer, animator);
        }
        catch (Exception e) {
            MessageDisplay.errorMsg(AnimalASCIIImporter.translateMessage("exportException", subName, className, e.getMessage()), 4);
        }
    }

    private void exportGraphicObject(PTGraphicObject ptgo, Hashtable<String, Exporter> asciiExporters, PrintWriter writer) {
        String className = ptgo.getClass().getName();
        String subName = null;
        try {
            if (!asciiExporters.containsKey(className)) {
                StringBuilder handlerName = new StringBuilder("animal.exchange.xaal.");
                handlerName.append(className.substring(className.lastIndexOf(46) + 1));
                handlerName.append("Exporter");
                subName = handlerName.toString();
                Class<?> c = Class.forName(subName);
                PTGraphicObjectExporter handler = (PTGraphicObjectExporter)c.newInstance();
                asciiExporters.put(className, handler);
            }
            PTGraphicObjectExporter localHandler = (PTGraphicObjectExporter)asciiExporters.get(className);
            localHandler.exportTo(writer, ptgo);
        }
        catch (Exception e) {
            MessageDisplay.errorMsg(AnimalASCIIImporter.translateMessage("exportException", subName, className, e.getMessage()), 4);
        }
    }

    @Override
    public String getDefaultExtension() {
        return "xml";
    }

    @Override
    public String getFormatDescription() {
        return this.isCompressed ? AnimalASCIIImporter.translateMessage("asciiFormatGzip") : AnimalASCIIImporter.translateMessage("asciiFormat");
    }

    @Override
    public String getMIMEType() {
        if (this.isCompressed) {
            return "animation/animal-ascii-compressed";
        }
        return "animation/animal-ascii";
    }

    @Override
    public void init(String format) {
        super.init(format);
        this.extension = format.substring(format.indexOf(47) + 1);
        this.isCompressed = this.extension.endsWith("compressed");
        this.exportCapabilities = 7;
    }

    @Override
    public String toString() {
        return AnimalASCIIImporter.translateMessage("asciiExportDescription");
    }
}

