/*
 * Decompiled with CFR 0.152.
 */
package animal.editor.properties;

import animal.editor.properties.PropertyEditor;
import animal.misc.AnimalColorChooserPanel;
import animal.misc.ColorChoice;
import animal.misc.ColoredSquare;
import animal.misc.MessageDisplay;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import translator.AnimalTranslator;

public class ColorPropertyEditor
extends PropertyEditor
implements ActionListener {
    Container localContainer;
    JColorChooser chooser;
    JButton activatorButton = null;
    Color currentColor;
    ColoredSquare colorSquare = null;

    public ColorPropertyEditor(String type, XProperties properties) {
        super(type, properties);
        Color currentCol = properties.getColorProperty(properties.getProperty("property"), Color.black);
        this.chooser = new JColorChooser(currentCol);
    }

    public void addEditorTo(Container container) {
        this.localContainer = container;
        String label = this.getProperties().getProperty("param0");
        JLabel myLabel = new JLabel(label, 2);
        String property = this.getProperties().getProperty("property");
        XProperties props = this.getTargetObject().getProperties();
        this.currentColor = props.getColorProperty(property, Color.black);
        if (this.chooser == null) {
            this.chooser = new JColorChooser(this.currentColor);
        }
        this.chooser.addChooserPanel(new AnimalColorChooserPanel());
        container.add(myLabel);
        this.colorSquare = new ColoredSquare(this.currentColor);
        this.activatorButton = new JButton(ColorChoice.getColorName(this.currentColor), this.colorSquare);
        container.add(this.activatorButton);
        this.activatorButton.addActionListener(this);
    }

    public void storeProperty() {
        String propertyToChange = this.getProperties().getProperty("property");
        this.getTargetObject().getProperties().put(propertyToChange, this.currentColor);
        this.activatorButton.setText(ColorChoice.getColorName(this.currentColor));
        this.colorSquare.changeColor(this.currentColor);
        this.activatorButton.setIcon(this.colorSquare);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            this.currentColor = JColorChooser.showDialog(new JFrame(), AnimalTranslator.translateMessage("selectColor"), this.currentColor);
            this.storeProperty();
        } else {
            MessageDisplay.errorMsg(actionEvent.toString(), 2);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        MessageDisplay.errorMsg(event.toString(), 2);
    }
}

