/*
 * Decompiled with CFR 0.152.
 */
package animal.editor.graphics;

import animal.editor.Editor;
import animal.editor.graphics.GraphicEditor;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTPoint;
import animal.graphics.PTPolyline;
import animal.gui.DrawCanvas;
import animal.main.Animation;
import animal.misc.ColorChoice;
import animal.misc.ColorChooserAction;
import animal.misc.EditPoint;
import animal.misc.EditableObject;
import animal.misc.MSMath;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import translator.AnimalTranslator;
import translator.ExtendedActionButton;
import translator.TranslatableGUIElement;

public class PolylineEditor
extends GraphicEditor
implements ItemListener,
ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = -2413776784253970663L;
    private JCheckBox fwArrowCB;
    private JCheckBox bwArrowCB;
    private ColorChooserAction colorChooser;

    protected void buildGUI() {
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        Box colorBox = generator.generateBorderedBox(3, "GenericEditor.colorBL");
        Box firstRowBox = new Box(2);
        firstRowBox.add(generator.generateJLabel("GenericEditor.colorLabel"));
        Color initialColor = this.getCurrentObject(false) == null ? Color.black : ((PTPolyline)this.getCurrentObject(false)).getColor();
        this.colorChooser = new ColorChooserAction(this, ColorChoice.getColorName(initialColor), "color", AnimalTranslator.translateMessage("GenericEditor.chooseColor", new Object[]{AnimalTranslator.translateMessage("OpenObjectEditor.outline")}), initialColor);
        firstRowBox.add(new ExtendedActionButton(this.colorChooser, 67));
        colorBox.add(firstRowBox);
        this.addBox(colorBox);
        this.fwArrowCB = generator.generateJCheckBox("ArrowableShapeEditor.fwArrow", null, this);
        this.fwArrowCB.addItemListener(this);
        this.bwArrowCB = generator.generateJCheckBox("ArrowableShapeEditor.bwArrow", null, this);
        this.bwArrowCB.addItemListener(this);
        Box polylinePropertiesBox = generator.generateBorderedBox(2, "PolylineEditor.propertiesBL");
        polylinePropertiesBox.add(this.fwArrowCB);
        polylinePropertiesBox.add(this.bwArrowCB);
        this.addBox(polylinePropertiesBox);
        this.finishBoxes();
    }

    public int pointsNeeded() {
        return -1;
    }

    public boolean nextPoint(int num, Point p) {
        PTPolyline pl = (PTPolyline)this.getCurrentObject();
        pl.setNode(num - 1, new PTPoint(p));
        return true;
    }

    public int getMinDist(PTGraphicObject go, Point p) {
        PTPolyline pg = (PTPolyline)go;
        Point b = pg.getNode(0).toPoint();
        int minDist = Integer.MAX_VALUE;
        int i = 1;
        while (i < pg.getNodeCount()) {
            int newDist;
            Point a = b;
            if (!a.equals(b = pg.getNode(i).toPoint()) && (newDist = MSMath.dist(p, a, b)) < minDist) {
                minDist = newDist;
            }
            ++i;
        }
        return minDist;
    }

    public EditPoint[] getEditPoints(PTGraphicObject go) {
        PTPolyline pg = (PTPolyline)go;
        int pSize = pg.getNodeCount();
        int size = pSize * 2 - 1;
        EditPoint[] result = new EditPoint[size];
        int i = 0;
        while (i < pSize) {
            result[i] = new EditPoint(i + 1, pg.getNode(i).toPoint());
            ++i;
        }
        Point b = pg.getNode(0).toPoint();
        i = 1;
        while (i < pSize) {
            Point a = b;
            b = pg.getNode(i).toPoint();
            result[i + pSize - 1] = new EditPoint(-i, new Point((a.x + b.x) / 2, (a.y + b.y) / 2));
            ++i;
        }
        return result;
    }

    public void setProperties(XProperties props) {
        this.bwArrowCB.setSelected(props.getBoolProperty("Polyline.bwArrow"));
        this.colorChooser.setColor(props.getColorProperty("Polyline.color", Color.black));
        this.depthBox.setSelectedItem(props.getProperty("Polyline.depth", "16"));
        this.fwArrowCB.setSelected(props.getBoolProperty("Polyline.fwArrow"));
    }

    public void getProperties(XProperties props) {
        props.put("Polyline.bwArrow", this.bwArrowCB.isSelected());
        props.put("Polyline.color", this.colorChooser.getColor());
        props.put((Object)"Polyline.depth", this.depthBox.getSelectedItem());
        props.put("Polyline.fwArrow", this.fwArrowCB.isSelected());
    }

    public void itemStateChanged(ItemEvent e) {
        PTPolyline p = (PTPolyline)this.getCurrentObject();
        if (e.getSource() == this.fwArrowCB && p != null) {
            p.setFWArrow(this.fwArrowCB.isSelected());
        }
        if (e.getSource() == this.bwArrowCB && p != null) {
            p.setBWArrow(this.bwArrowCB.isSelected());
        }
        Animation.get().doChange();
        this.repaintNow();
    }

    public EditableObject createObject() {
        PTPolyline pg = new PTPolyline();
        this.storeAttributesInto(pg);
        return pg;
    }

    protected void storeAttributesInto(EditableObject eo) {
        super.storeAttributesInto(eo);
        PTPolyline p = (PTPolyline)eo;
        p.setColor(this.colorChooser.getColor());
        p.setFWArrow(this.fwArrowCB.isSelected());
        p.setBWArrow(this.bwArrowCB.isSelected());
        p.setObjectName(this.objectNameField.getText());
    }

    protected void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        PTPolyline p = (PTPolyline)eo;
        this.colorChooser.setColor(p.getColor());
        this.fwArrowCB.setSelected(p.hasFWArrow());
        this.bwArrowCB.setSelected(p.hasBWArrow());
        this.objectNameField.setText(p.getObjectName());
    }

    public Editor getSecondaryEditor(EditableObject go) {
        PolylineEditor result = new PolylineEditor();
        result.extractAttributesFrom(go);
        return result;
    }

    public String getStatusLineMsg() {
        return AnimalTranslator.translateMessage("PolylineEditor.statusLine", new Object[]{DrawCanvas.translateDrawButton(), DrawCanvas.translateFinishButton(), DrawCanvas.translateCancelButton()});
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        PTPolyline p = (PTPolyline)this.getCurrentObject();
        if (p != null) {
            if (Animation.get() != null) {
                Animation.get().doChange();
            }
            this.repaintNow();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        PTPolyline poly = (PTPolyline)this.getCurrentObject();
        String eventName = event.getPropertyName();
        if ("color".equals(eventName)) {
            poly.setColor((Color)event.getNewValue());
        }
        if (!event.getOldValue().equals(event.getNewValue())) {
            this.repaintNow();
            if (Animation.get() != null) {
                Animation.get().doChange();
            }
        }
    }

    public String getBasicType() {
        return "Polyline";
    }
}

