/*
 * Decompiled with CFR 0.152.
 */
package animal.editor.graphics;

import animal.editor.Editor;
import animal.editor.graphics.ArcBasedShapeEditor;
import animal.graphics.PTEllipse;
import animal.graphics.PTGraphicObject;
import animal.gui.DrawCanvas;
import animal.main.Animation;
import animal.misc.EditPoint;
import animal.misc.EditableObject;
import animal.misc.MSMath;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import translator.AnimalTranslator;
import translator.TranslatableGUIElement;

public class EllipseEditor
extends ArcBasedShapeEditor
implements ItemListener,
ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = -2413776784253970663L;

    protected void buildGUI() {
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        Box contentBox = this.createCommonElements(generator);
        this.filledCB = generator.generateJCheckBox("GenericEditor.filled", null, this);
        this.filledCB.addItemListener(this);
        contentBox.add(this.filledCB);
        this.finishBoxes();
    }

    public int pointsNeeded() {
        return 2;
    }

    public boolean nextPoint(int num, Point p) {
        PTEllipse shape = (PTEllipse)this.getCurrentObject();
        if (num == 1) {
            shape.setCenter(p.x, p.y);
        }
        if (num == 2) {
            shape.setRadius(Math.abs(p.x - shape.getCenter().x), Math.abs(p.y - shape.getCenter().y));
        }
        return true;
    }

    public int getMinDist(PTGraphicObject go, Point p) {
        PTEllipse pg = (PTEllipse)go;
        Point a = new Point(pg.getCenter().x, pg.getCenter().y);
        Rectangle boundingBox = pg.getBoundingBox();
        if (boundingBox.contains(p.x, p.y)) {
            return 0;
        }
        Point b = new Point(a.x + pg.getXRadius(), a.y);
        int minDist = Integer.MAX_VALUE;
        int newDist = MSMath.dist(p, a, b);
        if (newDist < minDist) {
            minDist = newDist;
        }
        b.translate(0, pg.getXRadius());
        newDist = MSMath.dist(p, a, b);
        if (newDist < minDist) {
            minDist = newDist;
        }
        a.translate(pg.getXRadius(), pg.getYRadius());
        newDist = MSMath.dist(p, a, b);
        if (newDist < minDist) {
            minDist = newDist;
        }
        if ((newDist = MSMath.dist(p, a, pg.getCenter())) < minDist) {
            minDist = newDist;
        }
        return minDist;
    }

    public EditPoint[] getEditPoints(PTGraphicObject go) {
        PTEllipse pg = (PTEllipse)go;
        Point radius = pg.getRadius();
        EditPoint[] result = new EditPoint[5];
        Point helper = pg.getCenter();
        int x = helper.x;
        int y = helper.y;
        int nr = 0;
        result[nr++] = new EditPoint(2, new Point(x + radius.x, y + radius.y));
        result[nr++] = new EditPoint(-1, new Point(x - radius.x, y));
        result[nr++] = new EditPoint(-2, new Point(x, y + radius.y));
        result[nr++] = new EditPoint(-3, new Point(x + radius.x, y));
        result[nr++] = new EditPoint(-4, new Point(x, y - radius.y));
        return result;
    }

    public void setProperties(XProperties props) {
        this.colorChooser.setColor(props.getColorProperty("Ellipse.color", Color.black));
        this.depthBox.setSelectedItem(props.getProperty("Ellipse.depth", "16"));
        this.fillColorChooser.setColor(props.getColorProperty("Ellipse.fillColor", Color.black));
        this.filledCB.setSelected(props.getBoolProperty("Ellipse.filled"));
    }

    public void getProperties(XProperties props) {
        props.put("Ellipse.color", this.colorChooser.getColor());
        props.put((Object)"Ellipse.depth", this.depthBox.getSelectedItem());
        props.put("Ellipse.fillColor", this.fillColorChooser.getColor());
        props.put("Ellipse.filled", this.filledCB.isSelected());
    }

    public void itemStateChanged(ItemEvent e) {
        PTEllipse p = (PTEllipse)this.getCurrentObject();
        if (e.getSource() == this.filledCB && p != null) {
            p.setFilled(this.filledCB.isSelected());
        }
        Animation.get().doChange();
        this.repaintNow();
    }

    public EditableObject createObject() {
        PTEllipse pg = new PTEllipse();
        this.storeAttributesInto(pg);
        return pg;
    }

    protected void storeAttributesInto(EditableObject eo) {
        super.storeAttributesInto(eo);
        PTEllipse p = (PTEllipse)eo;
        p.setColor(this.colorChooser.getColor());
        p.setFilled(this.filledCB.isSelected());
        p.setFillColor(this.fillColorChooser.getColor());
    }

    protected void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        PTEllipse p = (PTEllipse)eo;
        this.colorChooser.setColor(p.getColor());
        this.filledCB.setEnabled(true);
        this.filledCB.setSelected(p.isFilled());
        this.fillColorChooser.setColor(p.getFillColor());
    }

    public Editor getSecondaryEditor(EditableObject go) {
        EllipseEditor result = new EllipseEditor();
        result.extractAttributesFrom(go);
        return result;
    }

    public String getStatusLineMsg() {
        return AnimalTranslator.translateMessage("EllipseEditor.statusLine", new Object[]{DrawCanvas.translateDrawButton(), DrawCanvas.translateFinishButton(), DrawCanvas.translateCancelButton()});
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        PTEllipse p = (PTEllipse)this.getCurrentObject();
        if (p != null) {
            if (Animation.get() != null) {
                Animation.get().doChange();
            }
            this.repaintNow();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        PTEllipse poly = (PTEllipse)this.getCurrentObject();
        String eventName = event.getPropertyName();
        if ("color".equals(eventName)) {
            poly.setColor((Color)event.getNewValue());
        } else if ("fillColor".equals(eventName)) {
            poly.setFillColor((Color)event.getNewValue());
        }
        if (!event.getOldValue().equals(event.getNewValue())) {
            this.repaintNow();
            if (Animation.get() != null) {
                Animation.get().doChange();
            }
        }
    }

    public String getBasicType() {
        return "Ellipse";
    }
}

