/*
 * Decompiled with CFR 0.152.
 */
package animal.editor;

import animal.editor.IndexedContentChooser;
import animal.graphics.PTGraphicObject;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import translator.AnimalTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedContentChooserListSupport
extends IndexedContentChooser {
    public static final String ADD_BUTTON_LABEL = "addItem";
    public static final String DELETE_BUTTON_LABEL = "deleteItem";
    public static final String EDIT_BUTTON_LABEL = "editItem";
    public static final String OK_BUTTON_LABEL = "ok";
    public static final String CANCEL_BUTTON_LABEL = "cancel";
    public static final String BOX_LABEL = "IndexedContenChooser.selectObjects";
    private AbstractButton addButton;
    private AbstractButton deleteButton;
    private AbstractButton editButton;
    private JList indexList;
    private AbstractButton okButton;
    private AbstractButton cancelButton;
    private Hashtable<String, Vector<Integer>> indicesTable = new Hashtable();
    private boolean editMode;
    private Hashtable<String, DefaultListModel> listModels = new Hashtable();
    private Hashtable<String, Hashtable<String, Vector<Integer>>> indexTables = new Hashtable();

    public IndexedContentChooserListSupport() {
        this(BOX_LABEL);
    }

    public IndexedContentChooserListSupport(String boxLabel) {
        super(boxLabel);
        this.getContentBox().add(this.createEditRow());
        this.getContentBox().add(this.createList());
        this.getContentBox().add(this.createOkCancelRow());
        this.editMode = false;
    }

    @Override
    public void setData(PTGraphicObject[] objects, Vector<String> methods) {
        super.setData(objects, methods);
        this.createListModels();
    }

    private void createListModels() {
        this.listModels.clear();
        this.indexTables.clear();
        for (IndexedContentChooser.IndexableObjectInformation info : this.indexableObjects.values()) {
            this.listModels.put(info.getIdentifier(), new DefaultListModel());
            this.indexTables.put(info.getIdentifier(), new Hashtable());
        }
        String selectedobject = this.getSelectedKindOfObject();
        if (selectedobject != null) {
            this.indexList.setModel(this.listModels.get(selectedobject));
            this.indicesTable = this.indexTables.get(selectedobject);
        }
    }

    private Component createEditRow() {
        Box buttonBox = new Box(2);
        this.addButton = AnimalTranslator.getGUIBuilder().generateJButton(ADD_BUTTON_LABEL, null, false, this);
        buttonBox.add(this.addButton);
        this.deleteButton = AnimalTranslator.getGUIBuilder().generateJButton(DELETE_BUTTON_LABEL, null, false, this);
        buttonBox.add(this.deleteButton);
        this.editButton = AnimalTranslator.getGUIBuilder().generateJButton(EDIT_BUTTON_LABEL, null, false, this);
        buttonBox.add(this.editButton);
        return buttonBox;
    }

    private Component createList() {
        this.indexList = new JList();
        this.indexList.setVisibleRowCount(5);
        JScrollPane scp = new JScrollPane(this.indexList);
        return scp;
    }

    private Component createOkCancelRow() {
        Box buttonBox = new Box(2);
        this.okButton = AnimalTranslator.getGUIBuilder().generateJButton(OK_BUTTON_LABEL, null, false, this);
        buttonBox.add(this.okButton);
        this.okButton.setVisible(false);
        this.cancelButton = AnimalTranslator.getGUIBuilder().generateJButton(CANCEL_BUTTON_LABEL, null, false, this);
        buttonBox.add(this.cancelButton);
        this.cancelButton.setVisible(false);
        return buttonBox;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.okButton) {
            this.handleOKEvent();
        } else if (e.getSource() == this.cancelButton) {
            this.handleCancelEvent();
        } else if (e.getSource() == this.addButton) {
            this.addIndicesToList(-1, this.getSelectedIndices());
        } else if (this.indexList.getSelectedValue() != null) {
            if (e.getSource() == this.deleteButton) {
                this.deleteIndicesFromList();
            } else if (e.getSource() == this.editButton) {
                this.editFirstSelectedObject();
            }
        } else if (e.getSource() == this.kindOfObjectCB) {
            if (!this.listModels.containsKey(this.getSelectedKindOfObject())) {
                this.listModels.put(this.getSelectedKindOfObject(), new DefaultListModel());
            }
            this.indexList.setModel(this.listModels.get(this.getSelectedKindOfObject()));
            this.indicesTable = this.indexTables.get(this.getSelectedKindOfObject());
        }
    }

    private void handleOKEvent() {
        if (!this.indexList.getSelectedValue().toString().equals(this.getTextualIndexRepresentation(this.getSelectedIndices()))) {
            int selectedObjectListIndex = this.indexList.getSelectedIndex();
            Vector<Integer> intRep = this.indicesTable.get(this.indexList.getSelectedValue().toString());
            this.indicesTable.remove(this.getSelectedStrings().get(0));
            this.deleteStringsFromList(this.getSelectedStrings());
            this.addIndicesToList(selectedObjectListIndex, this.getSelectedIndices());
            this.hideOKCancel();
            this.enableGUIAfterEdit();
        } else {
            this.handleCancelEvent();
        }
        this.editMode = false;
    }

    private void handleCancelEvent() {
        this.disableIndicesOfFirstSelectedObject();
        this.hideOKCancel();
        this.enableGUIAfterEdit();
        this.editMode = false;
    }

    private void enableGUIAfterEdit() {
        this.addButton.setEnabled(true);
        this.deleteButton.setEnabled(true);
        this.editButton.setEnabled(true);
        this.indexList.setEnabled(true);
        this.methodCB.setEnabled(true);
        this.kindOfObjectCB.setEnabled(true);
    }

    private void hideOKCancel() {
        this.okButton.setVisible(false);
        this.cancelButton.setVisible(false);
    }

    private void disableIndicesOfFirstSelectedObject() {
        Object selectedObject = this.indexList.getSelectedValue();
        if (selectedObject != null && this.indicesTable.containsKey(selectedObject.toString())) {
            Vector<Integer> intIndices = this.indicesTable.get(selectedObject.toString());
            this.disableIndices(intIndices);
        }
    }

    private void editFirstSelectedObject() {
        this.editMode = true;
        this.disableGUIForEdit();
        this.selectSelectedObjectWithSmallestIndex();
        this.enableFirstSelectedObject();
        this.showOKCancel();
    }

    private void showOKCancel() {
        this.okButton.setVisible(true);
        this.cancelButton.setVisible(true);
    }

    private void selectSelectedObjectWithSmallestIndex() {
        Object firstSelectedValue = this.indexList.getSelectedValue();
        this.indexList.getSelectionModel().clearSelection();
        this.indexList.setSelectedValue(firstSelectedValue, true);
    }

    private void enableFirstSelectedObject() {
        Object selectedObject = this.indexList.getSelectedValue();
        if (selectedObject != null && this.indicesTable.containsKey(selectedObject.toString())) {
            Vector<Integer> intIndices = this.indicesTable.get(selectedObject.toString());
            this.enableIndices(intIndices);
        }
    }

    private void disableGUIForEdit() {
        this.addButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
        this.editButton.setEnabled(false);
        this.indexList.setEnabled(false);
        this.methodCB.setEnabled(false);
        this.kindOfObjectCB.setEnabled(false);
    }

    private void deleteIndicesFromList() {
        Vector<String> selectedStrings = this.getSelectedStrings();
        int i = 0;
        while (i < selectedStrings.size()) {
            if (this.indicesTable.containsKey(selectedStrings.get(i))) {
                Vector<Integer> intIndices = this.indicesTable.get(selectedStrings.get(i));
                this.indicesTable.remove(selectedStrings.get(i));
                this.enableIndices(intIndices);
            }
            ++i;
        }
        this.deleteStringsFromList(selectedStrings);
    }

    private void deleteStringsFromList(Vector<String> selectedStrings) {
        ListModel model = this.indexList.getModel();
        if (model instanceof DefaultListModel) {
            DefaultListModel defModel = (DefaultListModel)model;
            int i = 0;
            while (i < selectedStrings.size()) {
                defModel.removeElement(selectedStrings.get(i));
                ++i;
            }
        }
    }

    private void enableIndices(Vector<Integer> indices) {
        IndexedContentChooser.IndexableObjectInformation tmpInfo = this.getObjectInformation(this.kindOfObjectCB.getSelectedItem().toString());
        Vector<Integer> chosenIndices = this.searchFirstSelectionOfAll(tmpInfo);
        tmpInfo.getPrimaryDimension().enableIndexEntries(indices);
        this.updateDimensionBoxModels(chosenIndices);
    }

    private Vector<String> getSelectedStrings() {
        Vector<String> selectedStrings = new Vector<String>();
        Object[] selectedObjects = this.indexList.getSelectedValues();
        int i = 0;
        while (i < selectedObjects.length) {
            selectedStrings.add(selectedObjects[i].toString());
            ++i;
        }
        return selectedStrings;
    }

    private void addIndicesToList(int index, Vector<Integer> indices) {
        String textualIndexRepresentation = this.getTextualIndexRepresentation(indices);
        if (textualIndexRepresentation != null && !this.indicesTable.containsKey(textualIndexRepresentation)) {
            if (index >= 0 && index < this.indexList.getModel().getSize()) {
                this.indexList.setModel(this.addToModel(this.indexList.getModel(), textualIndexRepresentation, index));
            } else {
                this.indexList.setModel(this.addToModel(this.indexList.getModel(), textualIndexRepresentation, this.indexList.getModel().getSize()));
            }
            this.disableIndices(indices);
            this.indicesTable.put(textualIndexRepresentation, indices);
        }
    }

    private void disableIndices(Vector<Integer> indices) {
        IndexedContentChooser.IndexableObjectInformation tmpInfo = this.getObjectInformation(this.kindOfObjectCB.getSelectedItem().toString());
        Vector<Integer> chosenIndices = this.searchFirstSelectionOfAll(tmpInfo);
        tmpInfo.getPrimaryDimension().disableIndexEntries(indices);
        this.updateDimensionBoxModels(chosenIndices);
    }

    private Vector<Integer> searchFirstSelectionOfAll(IndexedContentChooser.IndexableObjectInformation tmpInfo) {
        int index = 0;
        Vector<Integer> chosenIndices = new Vector<Integer>();
        String translatedAll = AnimalTranslator.translateMessage("all");
        while (index < tmpInfo.getDimensionCount() && !translatedAll.equals((String)((JComboBox)this.dimensionCBs.get(index)).getSelectedItem())) {
            chosenIndices.add(this.getSelectedIntValue(index));
            ++index;
        }
        return chosenIndices;
    }

    private ListModel addToModel(ListModel model, String value, int index) {
        if (!(model instanceof DefaultListModel)) {
            DefaultListModel<String> defModel = new DefaultListModel<String>();
            defModel.addElement(value);
            this.listModels.put(this.getSelectedKindOfObject(), defModel);
            return defModel;
        }
        if (model instanceof DefaultListModel) {
            DefaultListModel defModel = (DefaultListModel)model;
            if (index < model.getSize() && index >= 0) {
                defModel.add(index, value);
            } else {
                defModel.addElement(value);
            }
            return defModel;
        }
        return model;
    }

    private String getTextualIndexRepresentation(Vector<Integer> indices) {
        if (indices != null) {
            String returnValue = "[";
            int i = 0;
            while (i < indices.size()) {
                if (indices.get(i) == null) {
                    return null;
                }
                returnValue = String.valueOf(returnValue) + indices.get(i) + ",";
                ++i;
            }
            if (returnValue.length() > 1) {
                returnValue = returnValue.substring(0, returnValue.length() - 1);
            }
            returnValue = String.valueOf(returnValue) + "]";
            return returnValue;
        }
        return null;
    }

    public String getChosenIndexTuples() {
        String returnValue = "{";
        Iterator<String> it = this.indicesTable.keySet().iterator();
        while (it.hasNext()) {
            returnValue = String.valueOf(returnValue) + it.next();
        }
        return String.valueOf(returnValue) + "}";
    }

    public void addIndicesToList(Vector<Vector<Integer>> values) {
        IndexedContentChooser.IndexableObjectInformation info = this.getObjectInformation(this.kindOfObjectCB.getSelectedItem().toString());
        int indexCount = info.getDimensionCount();
        this.indexList.setModel(new DefaultListModel());
        for (Vector<Integer> indexTuple : values) {
            if (indexTuple.size() != indexCount) continue;
            this.addIndicesToList(-1, indexTuple);
        }
    }

    public boolean setSelectedKindOfObject(String string) {
        String translatedString = AnimalTranslator.translateMessage(string);
        this.kindOfObjectCB.setSelectedItem(translatedString);
        return this.kindOfObjectCB.getSelectedItem() != null && translatedString.equals(this.kindOfObjectCB.getSelectedItem());
    }

    public boolean setSelectedMethod(String string) {
        String translatedString = AnimalTranslator.translateMessage(string);
        this.methodCB.setSelectedItem(translatedString);
        return this.methodCB.getSelectedItem() != null && translatedString.equals(this.methodCB.getSelectedItem());
    }
}

