/*
 * Decompiled with CFR 0.152.
 */
package animal.dialog;

import animal.gui.AnimalMainWindow;
import animal.gui.DrawCanvas;
import animal.gui.DrawWindow;
import animal.main.Animal;
import animal.misc.ColorChoice;
import animal.misc.ColorChooserAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import translator.AnimalTranslator;
import translator.ExtendedActionButton;

public class OptionDialog
extends JDialog
implements ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = 4816005119499540962L;
    private static OptionDialog dialog = null;
    private Animal animal;
    private ColorChooserAction animationBackgroundColorChooser;
    private AbstractButton applyButton;
    private ColorChooserAction backgroundColorChooser;
    private AbstractButton cancelButton;
    private JCheckBox cbAutoload;
    private JComboBox fontName;
    private ColorChooserAction gridColorChooser;
    private AbstractButton okButton;
    private JRadioButton rbLineGrid;
    private JRadioButton rbPointGrid;
    private JButton saneFontSizeButton;
    private JComboBox slideShowDelayBox;

    public OptionDialog(Animal animalInstance) {
        super(animalInstance, AnimalTranslator.translateMessage("options", null), false);
        this.animal = animalInstance;
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        this.getContentPane().setLayout(gbl);
        JLabel l = new JLabel(AnimalTranslator.translateMessage("selectOptions", null));
        Font bigFont = new Font("SansSerif", 1, 16);
        Font middleFont = new Font("SansSerif", 0, 14);
        l.setFont(bigFont);
        gbc.gridwidth = 0;
        this.getContentPane().add((Component)l, gbc);
        l = new JLabel(AnimalTranslator.translateMessage("gridStyleOption", null));
        gbc.gridwidth = 1;
        l.setFont(middleFont);
        this.getContentPane().add((Component)l, gbc);
        this.rbLineGrid = new JRadioButton(AnimalTranslator.translateMessage("lineGridOption", null));
        gbc.gridwidth = 1;
        this.getContentPane().add((Component)this.rbLineGrid, gbc);
        this.rbPointGrid = new JRadioButton(AnimalTranslator.translateMessage("pointGridOption", null));
        gbc.gridwidth = 0;
        this.getContentPane().add((Component)this.rbPointGrid, gbc);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.rbLineGrid);
        bg.add(this.rbPointGrid);
        l = new JLabel(AnimalTranslator.translateMessage("gridColorOption", null));
        l.setFont(middleFont);
        gbc.gridwidth = 2;
        this.getContentPane().add((Component)l, gbc);
        DrawWindow drawWindow = AnimalMainWindow.getWindowCoordinator().getDrawWindow(true);
        DrawCanvas drawCanvas = drawWindow.getDrawCanvas();
        Color initialColor = drawCanvas.getGridColor();
        this.gridColorChooser = new ColorChooserAction(this, ColorChoice.getColorName(initialColor), "gridColor", AnimalTranslator.translateMessage("chooseColor", new Object[]{AnimalTranslator.translateMessage("gridColor")}), initialColor);
        gbc.gridwidth = 0;
        this.getContentPane().add((Component)new ExtendedActionButton(this.gridColorChooser, 71), gbc);
        l = new JLabel(AnimalTranslator.translateMessage("bgColorOption", null));
        l.setFont(middleFont);
        gbc.gridwidth = 2;
        this.getContentPane().add((Component)l, gbc);
        initialColor = drawCanvas.getBackgroundColor();
        this.backgroundColorChooser = new ColorChooserAction(this, ColorChoice.getColorName(initialColor), "backgroundColor", AnimalTranslator.translateMessage("chooseColor", new Object[]{AnimalTranslator.translateMessage("bgColor")}), initialColor);
        gbc.gridwidth = 0;
        this.getContentPane().add((Component)new ExtendedActionButton(this.backgroundColorChooser, 66), gbc);
        l = new JLabel(AnimalTranslator.translateMessage("animBGColorOption", null));
        l.setFont(middleFont);
        gbc.gridwidth = 2;
        this.getContentPane().add((Component)l, gbc);
        initialColor = AnimalMainWindow.getWindowCoordinator().getAnimationWindow(true).getAnimationCanvas().getBackgroundColor();
        this.animationBackgroundColorChooser = new ColorChooserAction(this, ColorChoice.getColorName(initialColor), "animationBackground", AnimalTranslator.translateMessage("chooseColor", new Object[]{AnimalTranslator.translateMessage("animBGColor")}), initialColor);
        gbc.gridwidth = 0;
        this.getContentPane().add((Component)new ExtendedActionButton(this.animationBackgroundColorChooser, 65), gbc);
        l = new JLabel(AnimalTranslator.translateMessage("fontOption", null));
        l.setFont(middleFont);
        gbc.gridwidth = 2;
        this.getContentPane().add((Component)l, gbc);
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.fontName = new JComboBox();
        gbc.gridwidth = 0;
        this.getContentPane().add((Component)this.fontName, gbc);
        int a = 0;
        while (a < fonts.length) {
            this.fontName.addItem(fonts[a]);
            ++a;
        }
        l = new JLabel(AnimalTranslator.translateMessage("slideShowDelay", null));
        l.setFont(middleFont);
        gbc.gridwidth = 2;
        this.getContentPane().add((Component)l, gbc);
        this.slideShowDelayBox = new JComboBox();
        gbc.gridwidth = 0;
        this.getContentPane().add((Component)this.slideShowDelayBox, gbc);
        a = 0;
        while (a < 1000) {
            this.slideShowDelayBox.addItem(String.valueOf(a));
            a += 100;
        }
        int delay = Animal.getSlideShowDelay();
        if (delay > 1000 || delay < 0 || delay % 100 != 0) {
            this.slideShowDelayBox.addItem(String.valueOf(delay));
        }
        this.slideShowDelayBox.setSelectedItem(String.valueOf(delay));
        this.slideShowDelayBox.setEditable(true);
        gbc.gridwidth = 2;
        this.cbAutoload = new JCheckBox(AnimalTranslator.translateMessage("autoLoadOption", null));
        this.cbAutoload.setFont(middleFont);
        this.getContentPane().add((Component)this.cbAutoload, gbc);
        gbc.gridwidth = 0;
        this.saneFontSizeButton = new JButton(AnimalTranslator.translateMessage("fixFontSizeOption", null));
        this.saneFontSizeButton.setMnemonic(70);
        this.saneFontSizeButton.addActionListener(this);
        this.getContentPane().add((Component)this.saneFontSizeButton, gbc);
        JPanel p = new JPanel();
        gbc.gridwidth = 0;
        gbc.anchor = 10;
        this.okButton = AnimalTranslator.getGUIBuilder().generateJButton("ok", null, false, this);
        p.add(this.okButton);
        this.cancelButton = AnimalTranslator.getGUIBuilder().generateJButton("cancel", null, false, this);
        p.add(this.cancelButton);
        this.applyButton = AnimalTranslator.getGUIBuilder().generateJButton("apply", null, false, this);
        p.add(this.applyButton);
        this.getContentPane().add((Component)p, gbc);
        if (drawWindow.getDrawCanvas().isPointGrid()) {
            this.rbPointGrid.setSelected(true);
        } else {
            this.rbLineGrid.setSelected(true);
        }
        this.fontName.setSelectedItem(this.animal.getAnimationFont());
        this.cbAutoload.setSelected(this.animal.isAutoloadLastFile());
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                OptionDialog.this.windowClosing();
            }
        });
        dialog = this;
    }

    public static OptionDialog getOptionDialog(Animal parent) {
        if (dialog == null) {
            dialog = new OptionDialog(parent);
        }
        return dialog;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.applyButton) {
            this.applyChanges();
        } else if (e.getSource() == this.okButton) {
            this.applyChanges();
            this.windowClosing();
        } else if (e.getSource() == this.cancelButton) {
            this.windowClosing();
        } else if (e.getSource() == this.saneFontSizeButton) {
            this.animal.saneFontSizes();
        }
    }

    void applyChanges() {
        DrawCanvas drawCanvas = AnimalMainWindow.getWindowCoordinator().getDrawWindow(true).getDrawCanvas();
        drawCanvas.setPointGrid(this.rbPointGrid.isSelected());
        drawCanvas.repaintAll();
        this.animal.setAnimationFont((String)this.fontName.getSelectedItem());
        this.animal.setAutoloadLastFile(this.cbAutoload.isSelected());
        int delay = Animal.getSlideShowDelay();
        try {
            delay = Integer.parseInt((String)this.slideShowDelayBox.getSelectedItem());
        }
        catch (NumberFormatException e) {
            delay = 500;
        }
        Animal.setSlideShowDelay(delay);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String eventName = event.getPropertyName();
        DrawCanvas drawCanvas = AnimalMainWindow.getWindowCoordinator().getDrawWindow(true).getDrawCanvas();
        if (eventName.equals("gridColor")) {
            drawCanvas.setGridColor((Color)event.getNewValue());
        } else if (eventName.equals("backgroundColor")) {
            drawCanvas.setBackgroundColor((Color)event.getNewValue());
        } else if (eventName.equals("animationBackground")) {
            AnimalMainWindow.getWindowCoordinator().getAnimationWindow(true).getAnimationCanvas().setBackgroundColor((Color)event.getNewValue());
        }
        drawCanvas.repaintAll();
        AnimalMainWindow.getWindowCoordinator().getAnimationWindow(true).getAnimationCanvas().repaint();
        this.pack();
    }

    public void setVisible(boolean showIt) {
        if (!this.isVisible()) {
            this.setLocationRelativeTo(this.getParent());
        }
        super.setVisible(showIt);
    }

    void windowClosing() {
        dialog = null;
        this.setVisible(false);
        this.dispose();
    }
}

