/*
 * Decompiled with CFR 0.152.
 */
package animal.animator;

import animal.animator.Animator;
import animal.main.AnimalConfiguration;
import animal.main.AnimationState;
import animal.variables.Variable;

public class VariableDeclaration
extends Animator {
    private static final int FILE_VERSION = 1;
    public static final String TYPE_LABEL = "VariableDeclaration";
    private transient AnimationState animState;
    private String name;
    private String initialValue;
    private String activationFrame;
    private String type;

    public VariableDeclaration() {
    }

    public VariableDeclaration(int step, String varName, String varType, String aFrame) {
        super(step, (int[])null);
        this.name = varName;
        this.type = varType;
        this.activationFrame = aFrame;
    }

    public VariableDeclaration(int step, String varName, String varType, String varInitialValue, String aFrame) {
        this(step, varName, varType, aFrame);
        this.initialValue = varInitialValue;
    }

    public void init(AnimationState animationState, long time, double ticks) {
        super.init(animationState, time, ticks);
        this.animState = animationState;
    }

    public void action(long time, double ticks) {
        this.execute();
    }

    public void execute() {
        super.execute();
        Variable newVar = Variable.create(this.name, this.type, this.initialValue, this.activationFrame);
        this.animState.getVariables().put(this.name, newVar);
        AnimalConfiguration.getDefaultConfiguration().getWindowCoordinator().getVariableView(false).setStep(this.getStep());
    }

    public String getAnimatorName() {
        return TYPE_LABEL;
    }

    public int getFileVersion() {
        return 1;
    }

    public String getType() {
        return TYPE_LABEL;
    }

    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL};
    }

    public boolean isChangingAnimator() {
        return false;
    }

    public boolean isGraphicalObjectAnimator() {
        return false;
    }

    public void discard() {
        this.activationFrame = null;
        this.animState = null;
        this.initialValue = null;
        this.name = null;
        this.type = null;
        super.discard();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(255);
        sb.append(this.type).append(' ').append(this.name);
        if (this.initialValue != null && this.initialValue.length() > 0) {
            sb.append(" = ").append(this.initialValue);
        }
        sb.append(";");
        if (this.activationFrame != null && this.activationFrame.length() > 0) {
            sb.append(" // frame: ").append(this.activationFrame);
        }
        return sb.toString();
    }

    public String getActivationFrame() {
        return this.activationFrame;
    }

    public void setActivationFrame(String activationFrame) {
        this.activationFrame = activationFrame;
    }

    public AnimationState getAnimState() {
        return this.animState;
    }

    public void setAnimState(AnimationState animState) {
        this.animState = animState;
    }

    public String getInitialValue() {
        return this.initialValue;
    }

    public void setInitialValue(String initialValue) {
        this.initialValue = initialValue;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getVariableType() {
        return this.type;
    }
}

