/*
 * Decompiled with CFR 0.152.
 */
package animal.animator;

import animal.animator.Animator;
import animal.gui.GraphicVector;
import animal.main.AnimationState;

public class Show
extends Animator {
    private static final int FILE_VERSION = 1;
    public static final String TYPE_LABEL = "Show";
    private static final long serialVersionUID = 5575863619518931021L;
    private transient GraphicVector graphicVector;
    private boolean show;

    public Show() {
    }

    public Show(int step, int objectNum, boolean isShow) {
        this(step, new int[]{objectNum}, isShow);
    }

    public Show(int step, int[] objectNums, boolean isShow) {
        super(step, objectNums);
        this.show = isShow;
    }

    public void init(AnimationState animationState, long time, double ticks) {
        super.init(animationState, time, ticks);
        this.graphicVector = animationState.getCurrentObjects();
    }

    public void action(long time, double ticks) {
        this.execute();
    }

    public void execute() {
        super.execute();
        int a = 0;
        while (a < this.objects.length) {
            if (this.show) {
                this.graphicVector.addElement(this.objects[a], 2);
            } else {
                this.graphicVector.removeElement(this.objects[a]);
            }
            ++a;
        }
    }

    public String getAnimatorName() {
        return this.show ? TYPE_LABEL : "Hide";
    }

    public int getFileVersion() {
        return 1;
    }

    public String getType() {
        return TYPE_LABEL;
    }

    public String[] handledKeywords() {
        return new String[]{"xxx"};
    }

    public boolean isChangingAnimator() {
        return false;
    }

    public boolean isShow() {
        return this.show;
    }

    public void setShow(boolean isShow) {
        this.show = isShow;
    }

    public void discard() {
        this.graphicVector.removeAllElements();
        this.graphicVector = null;
        super.discard();
    }

    public String toString() {
        if (this.show) {
            return "show " + super.toString();
        }
        return "hide " + super.toString();
    }
}

