/*
 * Decompiled with CFR 0.152.
 */
package algorithm.stringSearch;

import algorithm.animalTranslator.AnimalTranslator;
import algorithm.animalTranslator.codeItems.Hidden;
import algorithm.animalTranslator.codeItems.Node;
import algorithm.animalTranslator.codeItems.Off;
import algorithm.animalTranslator.codeItems.Pos;
import algorithm.animalTranslator.codeItems.TimeOffset;
import algorithm.animalTranslator.codeItems.Timing;
import algorithm.animalTranslator.codeItems.WithinTiming;

public class BMStringSearch {
    private AnimalTranslator at;
    private String dataString;
    private String stringToSearch;
    private boolean initialized = false;
    private String stringArrayName;
    private String subStringArrayName;
    private String algorithmName;
    private String markerIName;
    private String markerJName;
    private String markerStartName;
    private String legendeIName;
    private String legendeJName;
    private String legendeStartName;
    private int textPos;
    private int xPos;
    private int crossCounter;
    private int[] markedLinesInAlgorithm;
    private boolean[] isMarked;
    private int[] ourDeltaTab;

    public BMStringSearch(AnimalTranslator newAT) {
        this.at = newAT;
    }

    public void initialize(String theString, String toBeSearched) {
        this.dataString = theString;
        this.stringToSearch = toBeSearched;
        this.stringArrayName = "BMSearchArray";
        this.subStringArrayName = "BMSearchArraySubString";
        this.algorithmName = "CodeGroup_Algorithm";
        this.markerIName = "markerInString";
        this.markerJName = "markerInSubString";
        this.markerStartName = "markerInStringStart";
        this.legendeIName = "dieLegendeStringPointer";
        this.legendeJName = "dieLegendeSubStringPointer";
        this.legendeStartName = "dieLegendeStringCompareStart";
        this.textPos = -1;
        this.xPos = -1;
        this.isMarked = new boolean[this.dataString.length()];
        int i = 0;
        while (i < this.dataString.length()) {
            this.isMarked[i] = false;
            ++i;
        }
        this.crossCounter = 0;
        this.initialized = true;
    }

    public int generateAnimation() throws Exception {
        if (!this.initialized) {
            throw new Exception("Instance of BM-StringSearch has not been initialized!");
        }
        this.at.advancedAddHeaderMM("BM String-Suche");
        this.displayInitialScreen();
        this.displaySearchScreen();
        return this.bMSearchIterativ(this.dataString, this.stringToSearch);
    }

    private void displayInitialScreen() {
        this.at.compositeStepStart();
        this.at.addLabel("initial screen");
        this.at.advancedCreateWorkSheet();
        this.at.addText("sollSortiert", "Boyer-Moore - Suche nach einer Zeichenkette", new Pos(200, 200), "color black size 35 bold", null);
        this.at.compositeStepEnd();
        this.at.compositeStepStart();
        this.at.addText("comment1", "Idee beim Boyer-Moore-Algorithmus zur Suche von Zeichenketten in Texten:", new Off(-100, 130, "sollSortiert", "SW"), "color black size 25", null);
        this.at.addText("comment2", "- Vergleiche die Buchstaben innerhalb eines betrachteten Bereichs von der", new Off(0, 40, "comment1", "SW"), "color black size 25", null);
        this.at.addText("comment3", "   L\u221a\u00a7nge der Zeichenkette von rechts nach links.", new Off(0, 40, "comment2", "SW"), "color black size 25", null);
        this.at.addText("comment4", "- bei Ungleichheit schiebe den betrachteten Bereich m\u221a\u2202glichst weit nach rechts", new Off(0, 40, "comment3", "SW"), "color black size 25", null);
        this.at.addText("comment5", "Als Anhaltspunkt dient hier das letzte Zeichen im betrachteten Bereich im Text.", new Off(0, 40, "comment4", "SW"), "color black size 25", null);
        this.at.addText("comment6", "Kommt es in der Zeichenkette vor, so gibt der Abstand vom letzten Vorkommen", new Off(0, 40, "comment5", "SW"), "color black size 25", null);
        this.at.addText("comment7", "des Zeichens in der Zeichenkette zu deren letztem Zeichen an, wie weit der ", new Off(0, 40, "comment6", "SW"), "color black size 25", null);
        this.at.addText("comment8", "betrachtete Bereich nach rechts zu schieben ist. Dieser Wert wird zu Beginn ", new Off(0, 40, "comment7", "SW"), "color black size 25", null);
        this.at.addText("comment9", "der Suche f\u221a\u00bar jedes Zeichen in der Zeichenkette berechnet.", new Off(0, 40, "comment8", "SW"), "color black size 25", null);
        this.at.compositeStepEnd();
    }

    private void displaySearchScreen() {
        this.at.compositeStepStart();
        this.at.addLabel("searching screen");
        this.at.hide(new String[]{"sollSortiert", "comment1", "comment2", "comment3", "comment4", "comment5", "comment6", "comment7", "comment8", "comment9"}, null);
        this.at.advancedTextLine("headline", new Pos(300, 70), "color black size 25 bold", null, "Boyer-Moore - Suche nach der Zeichenkette: '" + this.stringToSearch + "'");
        this.at.advancedArrayReduction(this.stringArrayName, (Node)new Off(-200, 120, "headline", "NW"), this.dataString);
        this.at.advancedArrayReduction(this.subStringArrayName, (Node)new Off(0, 50, this.stringArrayName, "SW"), this.stringToSearch);
        this.at.addArrayMarker(this.markerStartName, this.stringArrayName, 0, "color red", new Hidden());
        this.at.addArrayMarker(this.markerIName, this.stringArrayName, 0, "color blue", new Hidden());
        this.at.addArrayMarker(this.markerJName, this.subStringArrayName, 0, "color blue", new Hidden());
        this.at.advancedTextLine(this.legendeIName, new Off(0, -25, this.stringArrayName, "NW"), "color blue size 15", null, "(textPos) aktuell betrachtete Position in Text und Zeichenkette");
        this.at.advancedTextLine(this.legendeStartName, new Off(30, 0, this.legendeIName, "NE"), "color red size 15", null, "Startposition des aktuellen Vergleichs");
        this.at.hide(new String[]{this.legendeIName, this.legendeJName, this.legendeStartName}, null);
        this.at.advancedCodeGroupStandard(this.algorithmName, new Off(15, 100, this.subStringArrayName, "SW"), new TimeOffset(0), new String[]{"1. Berechne f\u221a\u00bar jedes Zeichen, wieviel Schritte im Text nach rechts gegangen werden kann,", "   wenn das Zeichen am rechten Rand des betrachteten Feldes gefunden wird.", "2. Betrachte das letzte Zeichen in der Zeichenkette und den gleichen Index im Text.", "   Insgesamt wird im Text ein Bereich verglichen, der der L\u221a\u00a7nge der Zeichenkette entspricht.", "3. Ist entweder das Ende des Textes oder der Anfang der Zeichenkette erreicht?", "   - falls ja, gehe zu Schritt 7", "4. Sind die beiden betrachteten Zeichen gleich?", "   - falls ja, betrachte in Text und Zeichenkette jeweils das Zeichen davor und gehe zu Schritt 3", "5. Verschiebe den betrachteten Bereich entsprechend seinem letzten Zeichen nach rechts (Tabelle aus Schritt 1).", "6. Betrachte wieder das letzte Zeichen in der Zeichenkette und gehe zu Schritt 3.", "7. Wurde die Zeichenkette vollst\u221a\u00a7ndig \u221a\u00baberpr\u221a\u00baft?", "   - falls ja, wurde die Zeichenkette bei Index 'Startposition - L\u221a\u00a7nge der Zeichenkette + 1' gefunden", "   - sonst wurde das Element nicht gefunden"});
        this.at.compositeStepEnd();
    }

    private int bMSearchIterativ(String text, String x) {
        int[] step = this.baueDeltaTab(x);
        this.displayIncludedDeltaTab(x);
        this.at.compositeStepStart();
        this.setXPos(x.length() - 1);
        this.setTextPos(0);
        this.at.compositeStepEnd();
        while (this.textPos <= text.length() - x.length()) {
            this.codeMarkingForWhile1();
            while (x.charAt(this.xPos) == text.charAt(this.textPos + this.xPos)) {
                this.setXPos(this.xPos - 1);
                if (this.xPos >= 0) continue;
                return this.returnResult(this.textPos);
            }
            this.setTextPos(this.textPos + step[this.dataString.charAt(this.textPos + x.length() - 1)]);
            this.setXPos(x.length() - 1);
        }
        return this.returnResult(-1);
    }

    private void setTextPos(int newValue) {
        this.at.compositeStepStart();
        if (this.textPos == -1) {
            this.markLines(new int[]{2, 3});
            this.at.show(new String[]{this.markerIName, this.markerJName, this.markerStartName, this.legendeIName, this.legendeStartName}, null);
        } else {
            if (this.stringToSearch.charAt(this.xPos) != this.dataString.charAt(this.textPos + this.xPos) && this.xPos != this.stringToSearch.length() - 1) {
                this.markLines(new int[]{6});
                this.at.compositeStepEnd();
                this.at.compositeStepStart();
            }
            this.markDelta(this.dataString.charAt(this.textPos + this.stringToSearch.length() - 1));
            this.markLines(new int[]{8});
            this.at.compositeStepEnd();
            this.at.compositeStepStart();
        }
        if (newValue < this.dataString.length()) {
            this.at.moveArrayMarker(this.markerIName, newValue + this.stringToSearch.length() - 1, (Timing)new WithinTiming(1000));
            this.at.moveArrayMarker(this.markerStartName, newValue + this.stringToSearch.length() - 1, (Timing)new WithinTiming(1000));
        }
        this.markArrayArea(newValue);
        this.textPos = newValue;
        this.at.compositeStepEnd();
    }

    private void setXPos(int newValue) {
        this.at.compositeStepStart();
        if (this.xPos != -1) {
            if (newValue == this.stringToSearch.length() - 1) {
                this.markLines(new int[]{9});
                this.at.moveArrayMarker(this.markerIName, this.textPos + newValue, (Timing)new WithinTiming(1000));
                this.at.moveArrayMarker(this.markerJName, newValue, (Timing)new WithinTiming(1000));
            } else {
                this.markLines(new int[]{6});
                this.at.compositeStepEnd();
                this.at.compositeStepStart();
                this.markLines(new int[]{6, 7});
                if (newValue >= 0) {
                    this.at.moveArrayMarker(this.markerIName, this.textPos + newValue, (Timing)new WithinTiming(1000));
                    this.at.moveArrayMarker(this.markerJName, newValue, (Timing)new WithinTiming(1000));
                } else {
                    this.at.hide(new String[]{this.markerIName, this.markerJName}, null);
                }
                if (newValue >= 0) {
                    this.at.compositeStepEnd();
                    this.at.compositeStepStart();
                    this.markLines(new int[]{4});
                }
            }
        } else if (newValue >= 0) {
            this.at.moveArrayMarker(this.markerIName, this.textPos + newValue, (Timing)new WithinTiming(1000));
            this.at.moveArrayMarker(this.markerJName, newValue, (Timing)new WithinTiming(1000));
        } else {
            this.at.hide(new String[]{this.markerIName, this.markerJName}, null);
        }
        this.at.compositeStepEnd();
        this.xPos = newValue;
    }

    private void codeMarkingForWhile1() {
        this.markLines(new int[]{4});
        if (this.stringToSearch.charAt(this.xPos) != this.dataString.charAt(this.textPos + this.xPos)) {
            this.markLines(new int[]{6});
        }
    }

    private int[] baueDeltaTab(String Muster) {
        int ls = Muster.length();
        int[] deltaTab = new int[256];
        int i = 0;
        while (i < 256) {
            deltaTab[i] = ls;
            ++i;
        }
        i = 1;
        while (i < ls) {
            deltaTab[Muster.charAt((int)(i - 1))] = ls - i;
            ++i;
        }
        return deltaTab;
    }

    private String[] includedDeltaTab(String Muster) {
        int ls = Muster.length();
        this.ourDeltaTab = this.baueDeltaTab(Muster);
        String[] newDeltaTab = new String[]{"Buchstabe:    ", "Rechtsshift:  "};
        int i = 0;
        while (i < 256) {
            int dti = this.ourDeltaTab[i];
            if (dti != ls) {
                newDeltaTab[0] = String.valueOf(newDeltaTab[0]) + (dti >= 10 ? " " : "") + (char)i + " ";
                newDeltaTab[1] = String.valueOf(newDeltaTab[1]) + this.ourDeltaTab[i] + " ";
            }
            ++i;
        }
        newDeltaTab[0] = String.valueOf(newDeltaTab[0]) + "  sonstige";
        newDeltaTab[1] = String.valueOf(newDeltaTab[1]) + "  " + ls;
        return newDeltaTab;
    }

    private void markDelta(char toMark) {
        this.at.compositeStepStart();
        if (this.crossCounter > 0) {
            this.at.hide("Delta_Marker_X_" + this.crossCounter, null);
        }
        int position = 14;
        boolean cancelled = false;
        char i = '\u0000';
        while (i < '\u0100') {
            int odti = this.ourDeltaTab[i];
            if (odti < this.stringToSearch.length()) {
                if (toMark == i) {
                    cancelled = true;
                    break;
                }
                position += 2;
                if (odti >= 10) {
                    ++position;
                }
            }
            ++i;
        }
        if (!cancelled) {
            position += 2;
        }
        String txt = "";
        int i2 = 0;
        while (i2 < position) {
            txt = String.valueOf(txt) + " ";
            ++i2;
        }
        txt = String.valueOf(txt) + "x";
        ++this.crossCounter;
        this.at.advancedTextLine("Delta_Marker_X_" + this.crossCounter, new Off(0, -6, "DeltaTabLineOne", "SW"), "color red font Monospaced size 16 bold", null, txt);
        this.at.compositeStepEnd();
    }

    private void markArrayArea(int start) {
        this.at.compositeStepStart();
        int ende = start + this.stringToSearch.length() - 1;
        int i = 0;
        while (i < this.dataString.length()) {
            if (i < start || i > ende) {
                if (!this.isMarked[i]) {
                    this.at.advancedHighlightArrayCells(this.stringArrayName, i, i);
                    this.isMarked[i] = true;
                }
            } else {
                if (this.isMarked[i]) {
                    this.at.advancedUnhighlightArrayCells(this.stringArrayName, i, i);
                }
                this.isMarked[i] = false;
            }
            ++i;
        }
        this.at.compositeStepEnd();
    }

    private void displayIncludedDeltaTab(String Muster) {
        this.at.compositeStepStart();
        int[] nArray = new int[2];
        nArray[1] = 1;
        this.markLines(nArray);
        String[] deltaTab = this.includedDeltaTab(Muster);
        this.at.advancedTextLine("DeltaTabLineOne", new Off(0, 25, this.subStringArrayName, "SW"), "font Monospaced", null, deltaTab[0]);
        this.at.advancedTextLine("DeltaTabLineTwo", new Off(0, 8, "DeltaTabLineOne", "SW"), "font Monospaced", null, deltaTab[1]);
        this.at.compositeStepEnd();
    }

    private int returnResult(int result) {
        this.markLines(new int[]{4});
        this.markLines(new int[]{4, 5});
        this.at.compositeStepStart();
        this.markLines(new int[]{10});
        if (result == -1) {
            this.markLines(new int[]{10, 12});
            this.at.advancedTextLine("Ergebnis", new Off(130, 100, this.algorithmName, "SW"), "color blue size 30", new TimeOffset(0), "Die gesuchte Zeichenfolge wurde nicht gefunden!");
        } else {
            this.markLines(new int[]{10, 11});
            this.at.advancedTextLine("Ergebnis", new Off(130, 50, this.algorithmName, "SW"), "color blue size 30", new TimeOffset(0), "Die gesuchte Zeichenfolge wurde bei index " + result + " gefunden!");
            this.at.advancedTextLine("Ergebnis2", new Off(200, 15, "Ergebnis", "SW"), "color blue size 15", new TimeOffset(0), "(der index beginnt bei 0 und geht bis text.length() - 1)");
        }
        this.at.compositeStepEnd();
        this.at.addLabel("SearchResult");
        return result;
    }

    private void markLines(int[] linesInAlgorithm) {
        if (linesInAlgorithm == null) {
            System.out.println("useless call of markLines in BMSearch - all parameters null");
        } else {
            this.at.compositeStepStart();
            if (this.markedLinesInAlgorithm == null) {
                this.markedLinesInAlgorithm = new int[0];
            }
            if (linesInAlgorithm != null) {
                int i = 0;
                while (i < this.markedLinesInAlgorithm.length) {
                    this.at.unhighlightCode(this.algorithmName, this.markedLinesInAlgorithm[i], "", null);
                    ++i;
                }
                this.markedLinesInAlgorithm = linesInAlgorithm;
                i = 0;
                while (i < this.markedLinesInAlgorithm.length) {
                    this.at.highlightCode(this.algorithmName, this.markedLinesInAlgorithm[i], "", null);
                    ++i;
                }
            }
            this.at.compositeStepEnd();
        }
    }
}

