/*
 * Decompiled with CFR 0.152.
 */
package net.algoanim.aads;

import net.algoanim.aads.Parallaxer;

public abstract class CodeSupport {
    protected static final String CONTEXT_MODE = " context";
    protected static final String HIGHLIGHT = "highlightCode on \"";
    protected static final String[] INDENTATION_PREFIXES = new String[]{"", "  ", "    ", "      ", "        ", "          "};
    public static final String LEVEL_0 = INDENTATION_PREFIXES[0];
    public static final String LEVEL_1 = INDENTATION_PREFIXES[1];
    public static final String LEVEL_2 = INDENTATION_PREFIXES[2];
    public static final String LEVEL_3 = INDENTATION_PREFIXES[3];
    public static final String LEVEL_4 = INDENTATION_PREFIXES[4];
    public static final String LEVEL_5 = INDENTATION_PREFIXES[5];
    protected static final String LINE = "\" line ";
    protected static final String UNHIGHLIGHT = "unhighlightCode on \"";
    protected String codeGroupName = null;
    protected int nrCodeLines = 0;
    protected String originalCode = null;
    protected StringBuilder sbuf = null;
    protected Parallaxer parallaxer = null;

    public CodeSupport(StringBuilder outputBuffer, String codeChunk, String label, Parallaxer stepControl) {
        this.originalCode = codeChunk;
        this.nrCodeLines = 0;
        this.codeGroupName = label;
        this.sbuf = outputBuffer;
        if (this.sbuf == null) {
            this.sbuf = new StringBuilder(1024);
        }
        this.parallaxer = stepControl;
    }

    protected int determineIndentationLevel(String s) {
        int currentLevel = INDENTATION_PREFIXES.length - 1;
        while (!s.startsWith(INDENTATION_PREFIXES[currentLevel]) && currentLevel > 0) {
            --currentLevel;
        }
        return currentLevel;
    }

    public void assembleSourceCode(String codeColor, String highlightColor, String contextColor, String font) {
        this.assembleSourceCode(codeColor, highlightColor, contextColor, font, 20, 140);
    }

    public abstract void assembleSourceCode(String var1, String var2, String var3, String var4, int var5, int var6);

    public void highlightCode(int line) {
        this.highlightCode(line, true, false);
    }

    public abstract void highlightCode(int var1, boolean var2, boolean var3);

    public void switchCodeLine(int oldLine, int newLine) {
        this.unhighlightCode(oldLine);
        this.highlightCode(newLine);
    }

    public void unhighlightCode(int line) {
        this.highlightCode(line, false, false);
    }
}

