/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import net.algoanim.aads.AnimatedIntArray;
import net.algoanim.aads.AnimatedIntArrayMarker;
import net.algoanim.aads.ArraySupportFactory;
import net.algoanim.aads.CodeSupport;
import net.algoanim.aads.CodeSupportFactory;
import net.algoanim.aads.IntArraySupport;
import net.algoanim.aads.Parallaxer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SortingAlgorithm {
    protected static final String FOOTER_TEXT = "{\n  hideAll\n  text \"eoa\" \"Ende der Animation\" at (120,50) color black font SansSerif size 32\n  text \"comps\" \"Es wurden \" +$\"nrComparisons\" asInt +\" Vergleiche\" at (20,100) color black font SansSerif size 24\n  text \"swaps\" \"und \" +$\"nrAssignments\" asInt +\" Zuweisungen durchgef\u00b8hrt.\" at (20,130) color black font SansSerif size 24\n}";
    protected static final String FOOTER_TEXT_ENGLISH = "{\n  hideAll\n  text \"eoa\" \"End of the Animation\" at (120,50) color black font SansSerif size 32\n  text \"comps\" \"A total of \" +$\"nrComparisons\" asInt +\" comparisons\" at (20,100) color black font SansSerif size 24\n  text \"swaps\" \"and \" +$\"nrAssignments\" asInt +\" assignments were performed.\" at (20,130) color black font SansSerif size 24\n}";
    protected AnimationPropertiesContainer animationProperties;
    protected Hashtable<String, Object> primitives;
    private GeneratorType myType = new GeneratorType(1);
    public Parallaxer parallaxer = null;
    protected AnimatedIntArray targetArray = null;
    protected AnimatedIntArrayMarker iMarker = null;
    protected AnimatedIntArrayMarker jMarker = null;
    protected CodeSupport codeSupport = null;
    protected StringBuilder sb = new StringBuilder(32768);
    protected int nrAssigns;
    protected int nrComparisons;
    protected boolean insideStep = false;
    protected String code = null;
    protected String description = null;

    public GeneratorType getGeneratorType() {
        return this.myType;
    }

    public String getFileExtension() {
        return "asu";
    }

    protected void swap(int[] array, int firstIndex, int secondIndex) {
        this.sb.append("  arraySwap on \"array\" position " + firstIndex + " with " + secondIndex + " within 10 ticks\n");
        int sw = array[firstIndex];
        array[firstIndex] = array[secondIndex];
        array[secondIndex] = sw;
    }

    protected void setParameters(AnimationPropertiesContainer props, Hashtable<String, Object> graphicalObjects) {
        this.animationProperties = props;
        this.primitives = graphicalObjects;
    }

    protected void startAnimGeneration(int[] a) {
        this.startAnimGeneration(a, "array", 20, 80);
    }

    protected void startAnimGeneration(int[] a, String title) {
        this.startAnimGeneration(a, title, 20, 80);
    }

    protected void startAnimGeneration(int[] a, String title, int x, int y) {
        this.startStep(this.sb);
        this.createArray(a, title, x, y);
    }

    protected String dumpColor(Color color) {
        StringBuilder sbuf = new StringBuilder(32);
        if (color == null) {
            sbuf.append("black");
        } else {
            sbuf.append('(').append(color.getRed()).append(',');
            sbuf.append(color.getGreen()).append(',').append(color.getBlue());
            sbuf.append(')');
        }
        return sbuf.toString();
    }

    protected void createArray(int[] a, String key, int x, int y) {
        this.sb.append("  array \"").append(key).append("\" (").append(x).append(", ");
        this.sb.append(y).append(") color ");
        this.sb.append(this.dumpColor((Color)this.animationProperties.get("array", "color")));
        this.sb.append(" fillColor ");
        this.sb.append(this.dumpColor((Color)this.animationProperties.get("array", "fillColor")));
        this.sb.append(" elementColor ");
        this.sb.append(this.dumpColor((Color)this.animationProperties.get("array", "elementColor")));
        this.sb.append(" elemHighlight ");
        this.sb.append(this.dumpColor((Color)this.animationProperties.get("array", "elemHighlight")));
        this.sb.append(" cellHighlight ");
        this.sb.append(this.dumpColor((Color)this.animationProperties.get("array", "cellHighlight")));
        this.sb.append(" length ");
        this.sb.append(a.length);
        int i = 0;
        while (i < a.length) {
            this.sb.append(" \"" + a[i] + "\"");
            ++i;
        }
    }

    protected void endAnimGeneration() {
        this.sb.append("  variable \"nrComparisons\"\n");
        this.sb.append("  assign \"nrComparisons\" = " + this.getNrComparisons() + "\n");
        this.sb.append("  variable \"nrAssignments\"\n");
        this.sb.append("  assign \"nrAssignments\" = " + this.getNrAssigns() + "\n");
    }

    public static void printArray(int[] s) {
        System.err.println("{ ");
        int i = 0;
        while (i < s.length) {
            System.err.println(String.valueOf(s[i]) + " ");
            ++i;
        }
        System.err.println("}");
    }

    public String getAnimationCode() {
        return this.sb.toString();
    }

    public int getNrAssigns() {
        return this.nrAssigns + this.targetArray.getNrAssignments();
    }

    public int getNrComparisons() {
        return this.nrComparisons + this.targetArray.getNrComparisons();
    }

    protected abstract void sort(int[] var1);

    protected String getAlgorithmDescription() {
        return this.description;
    }

    protected String getAlgorithmCode() {
        return this.code;
    }

    protected void endStep(StringBuilder sbuffer) {
        if (this.insideStep) {
            sbuffer.append("}\n");
        }
        this.insideStep = false;
    }

    protected void endStep() {
        this.endStep(this.sb);
    }

    protected void startStep(StringBuilder sbuffer) {
        if (!this.insideStep) {
            sbuffer.append("{\n");
        }
        this.insideStep = true;
    }

    protected void startStep() {
        this.startStep(this.sb);
    }

    protected void toggleStep() {
        this.toggleStep(this.sb);
    }

    protected void toggleStep(StringBuilder sbuffer) {
        this.endStep(sbuffer);
        this.startStep(sbuffer);
    }

    public void addLabel(StringBuilder sbuf, String labelText) {
        sbuf.append("label \"").append(labelText).append("\"\n");
    }

    public void createCode(StringBuilder sbuf, String codeGroupKey) {
        sbuf.append("  codegroup \"").append(codeGroupKey);
        sbuf.append("\" at (20, 200) color ");
        Object o1 = this.animationProperties.get("code", "color");
        sbuf.append(o1.toString());
        Object o2 = this.animationProperties.get("code", "highlightColor");
        sbuf.append(o2.toString());
        Object o3 = this.animationProperties.get("code", "contextColor");
        sbuf.append(o3.toString());
        Object o4 = this.animationProperties.get("code", "font");
        sbuf.append(o4.toString());
        Object o5 = this.animationProperties.get("code", "size");
        sbuf.append(o5.toString());
    }

    public void createCode(StringBuilder sbuf, String codeGroupKey, String codeGroupCode) {
        this.createCode(sbuf, codeGroupKey);
    }

    protected void createArrayMarker(StringBuilder sbuf, String key, String baseArrayKey, int initialPosition, String label, Color color) {
        sbuf.append("  arraymarker \"").append(key).append("\" on \"");
        sbuf.append(baseArrayKey).append("\" atIndex ").append(initialPosition);
        sbuf.append(" label \"").append(label).append("\" color ");
        sbuf.append(this.dumpColor(color));
        sbuf.append("\n");
    }

    public AnimatedIntArray createIntArray(String arrayKey) {
        int[] theArray = (int[])this.primitives.get(arrayKey);
        String outlineColorName = this.dumpColor((Color)this.animationProperties.get(arrayKey, "color"));
        String fillColorName = this.dumpColor((Color)this.animationProperties.get(arrayKey, "fillColor"));
        String elementColorName = this.dumpColor((Color)this.animationProperties.get(arrayKey, "elementColor"));
        String elemHLColorName = this.dumpColor((Color)this.animationProperties.get(arrayKey, "elemHighlight"));
        String cellHLColorName = this.dumpColor((Color)this.animationProperties.get(arrayKey, "cellHighlight"));
        AnimatedIntArray animatedIntArray = new AnimatedIntArray(this.sb, arrayKey, theArray, this.sb, outlineColorName, fillColorName, elementColorName, elemHLColorName, cellHLColorName, 20, 140);
        return animatedIntArray;
    }

    public IntArraySupport createTheIntArray(String arrayKey) {
        int[] theArray = (int[])this.primitives.get(arrayKey);
        String outlineColorName = this.dumpColor((Color)this.animationProperties.get(arrayKey, "color"));
        String fillColorName = this.dumpColor((Color)this.animationProperties.get(arrayKey, "fillColor"));
        String elementColorName = this.dumpColor((Color)this.animationProperties.get(arrayKey, "elementColor"));
        String elemHLColorName = this.dumpColor((Color)this.animationProperties.get(arrayKey, "elemHighlight"));
        String cellHLColorName = this.dumpColor((Color)this.animationProperties.get(arrayKey, "cellHighlight"));
        IntArraySupport animatedIntArray = ArraySupportFactory.generateIntArraySupportInstance(this.sb, arrayKey, theArray, this.sb, outlineColorName, fillColorName, elementColorName, elemHLColorName, cellHLColorName, 20, 140, true, true);
        return animatedIntArray;
    }

    protected AnimatedIntArrayMarker createArrayMarker(AnimatedIntArray baseArray, int initialPosition, String key) {
        AnimatedIntArrayMarker marker = new AnimatedIntArrayMarker(baseArray, initialPosition, key, this.sb, key);
        return marker;
    }

    public void generateStepCounters(String arrayKey) {
        this.sb.append("\n  text \"assignments\" \"#A\" offset (100, 0) from \"");
        this.sb.append(arrayKey).append("\" SE font SansSerif size 12;");
        this.sb.append("\n  text \"comparisons\" \"Comparisons\" offset (0, 20)");
        this.sb.append(" from \"assignments\" SW font SansSerif size 12;");
        this.sb.append("\n  rectangle \"assRect\" offset (20, 0) from ");
        this.sb.append("\"assignments\" NE offset(20, 0) from \"assignments\" SE filled fillColor blue");
        this.sb.append("\n  rectangle \"cmpRect\" offset (0, 20) from \"assRect\"");
        this.sb.append(" NW offset (0, 20) from \"comparisons\" SE filled fillColor blue");
    }

    protected CodeSupport createCode(String usedCode, String key) {
        this.parallaxer = new Parallaxer(this.sb);
        CodeSupport aCodeSupport = CodeSupportFactory.generateCodeSupportInstance(this.sb, usedCode, key, this.parallaxer, true, true);
        Color codeColor = (Color)this.animationProperties.get(key, "color");
        Color highlightColor = (Color)this.animationProperties.get(key, "highlightColor");
        Color contextColor = (Color)this.animationProperties.get(key, "contextColor");
        Font targetFont = (Font)this.animationProperties.get(key, "font");
        aCodeSupport.assembleSourceCode(this.dumpColor(codeColor), this.dumpColor(highlightColor), this.dumpColor(contextColor), targetFont.getFamily(), 20, 200);
        return aCodeSupport;
    }

    public void addLabel(String labelText) {
        this.sb.append("label \"").append(labelText).append("\"\n");
    }

    protected String generateSummary(int nrComp, int nrAss) {
        StringBuilder stringBuilder = new StringBuilder(512);
        stringBuilder.append("{\n  hideAll");
        stringBuilder.append("\n  text \"eoa\" \"Ende der Animation\" at (120,50)");
        stringBuilder.append(" color black font SansSerif size 32");
        stringBuilder.append("\n  text \"comps\" \"Es wurden ").append(nrComp);
        stringBuilder.append(" Vergleiche und ").append(nrAss);
        stringBuilder.append(" Zuweisungen durchgef\u00b8hrt.\" at (20,100) color black font");
        stringBuilder.append("SansSerif size 24\n}");
        return stringBuilder.toString();
    }

    protected String generateEnglishSummary(int nrComp, int nrAss) {
        StringBuilder stringBuilder = new StringBuilder(512);
        stringBuilder.append("{\n  hideAll");
        stringBuilder.append("\n  text \"eoa\" \"End of the Animation\" at (120,50)");
        stringBuilder.append(" color black font SansSerif size 32");
        stringBuilder.append("\n  text \"comps\" \"A total of ");
        stringBuilder.append(nrComp).append(" comparisons and ");
        stringBuilder.append(nrAss).append(" assignments were performed.\"");
        stringBuilder.append(" at (20,130) color black font SansSerif size 24\n}");
        return stringBuilder.toString();
    }

    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        this.setParameters(props, primitives);
        int[] theArray = (int[])primitives.get("array");
        this.sort(theArray);
        return this.sb.toString();
    }

    public String getOutputLanguage() {
        return "Java";
    }

    public String getAlgorithmName() {
        return "Insertion Sort";
    }
}

