/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import algorithm.animalTranslator.AnimalTranslator;
import algorithm.fileHandler.FileHandler;
import algorithm.search.InterpolationSearch;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.util.Hashtable;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterpolationSearchWrapper
implements Generator {
    private static final String DESCRIPTION = "Die Interpolationssuche ist ein sehr effizientes (doppelt logarithmisches) Verfahren zur Suche eines Wertes in einem sortierten Feld.\nZuerst wird die vermutliche Positionen des gesuchten Elements berechnet. Dazu wird die Distanz des gesuchte Wert vom Anfangswert des (Teil)feldes mit der Teilfeldl\u2030nge multipliziert und anschlie\ufb02end durch die Intervallbreite (letzter Wert - erster Wert) geteilt. Bei angenommener Gleichverteilung der Werte w\u2030re dies die Zielposition des gesuchten Elements.Nun wird diese interpolierte Position des Arrays \u00b8berpr\u00b8ft. Der Wert an der Position kann kleiner, gr\u02c6\ufb02er oder gleich dem gesuchten Element sein. Ist er kleiner als das gesuchte Element, muss das gesuchte Element in der hinteren H\u2030lfte stecken, falls es sich dort \u00b8berhaupt befindet. Ist er hingegen gr\u02c6\ufb02er, muss nur in der vorderen H\u2030lfte weitergesucht werden. Die jeweils andere H\u2030lfte muss nicht mehr betrachtet werden. Ist der Wert gleich dem gesuchten Element, ist die Suche (vorzeitig) beendet.\nJede weiterhin zu untersuchende H\u2030lfte wird wieder gleich behandelt: Das Element an der interpolierten Position liefert wieder die Entscheidung dar\u00b8ber, wo bzw. ob weitergesucht werden muss.\nDie L\u2030nge des Suchbereiches schrumpft von Schritt zu Schritt oft drastisch. Sp\u2030testens wenn der Suchbereich auf 1 Element geschrumpft ist, ist die Suche beendet. Dieses eine Element ist entweder das gesuchte Element, oder das gesuchte Element kommt nicht vor.\nDer Algorithmus zur Interpolationssuche wird entweder als Iteration oder Rekursion implementiert. Hier wurde eine iterative Implementierung gew\u2030hlt.";
    private static final String SOURCE_CODE = "private int binSearchIterativ(int[] a, int x) {\n  if (a == null || a.length == 0) {\n    return -1;\n  }\n  int l = 0, r = a.length - 1, midElem = \n    l + ((x - a[l]) * (r - l)) / (a[r] - a[l]);\n  while (a[midElem] != x && r > l) {\n    if (x < a[midElem]) {\n      r = midElem - 1;\n    } else {\n      l = midElem + 1;\n    }\n    midElem = l + ((x - a[l]) * (r - l)) / (a[r] - a[l]);\n  }\n  if (a[midElem] == x) {\n    return midElem;\n  } else {\n    return -1;\n  }\n}";
    private GeneratorType myType = new GeneratorType(2);

    @Override
    public GeneratorType getGeneratorType() {
        return this.myType;
    }

    @Override
    public String getName() {
        return "Interpolationssuche";
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getCodeExample() {
        return SOURCE_CODE;
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        int[] dataArray = (int[])primitives.get("array");
        int toSearch = (Integer)primitives.get("searchValue");
        FileHandler handler = new FileHandler("demo.asu");
        AnimalTranslator animalTrans = new AnimalTranslator(handler);
        boolean hideCode = (Boolean)props.get("sourceCode", "hidden");
        InterpolationSearch interpolationSearch = new InterpolationSearch(animalTrans, !hideCode);
        interpolationSearch.initialize(dataArray, toSearch);
        try {
            interpolationSearch.generateAnimation();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return handler.getAnimationCode();
    }

    @Override
    public Locale getContentLocale() {
        return Locale.GERMANY;
    }

    @Override
    public String getOutputLanguage() {
        return "Java";
    }

    @Override
    public String getAlgorithmName() {
        return "Interpolated Search";
    }
}

