/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import animalscriptapi.animalscript.AnimalScript;
import animalscriptapi.primitives.ArrayMarker;
import animalscriptapi.primitives.IntArray;
import animalscriptapi.primitives.SourceCode;
import animalscriptapi.primitives.generators.Language;
import animalscriptapi.properties.ArrayMarkerProperties;
import animalscriptapi.properties.ArrayProperties;
import animalscriptapi.properties.SourceCodeProperties;
import animalscriptapi.util.Coordinates;
import animalscriptapi.util.TicksTiming;
import de.ahrgr.animal.kohnert.asugen.Color;
import de.ahrgr.animal.kohnert.asugen.Font;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.util.Hashtable;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CocktailSortClass
implements Generator {
    protected Language lang;
    private ArrayProperties arrayProps;
    private ArrayMarkerProperties amLeft;
    private ArrayMarkerProperties amRight;
    private ArrayMarkerProperties amFinish;
    private ArrayMarkerProperties ami;
    private ArrayMarkerProperties amj;
    private SourceCode sc;

    public void init() {
        this.lang = new AnimalScript("Cocktailsort Animation", "Kristina Rei\ufb02", 640, 480);
        this.lang.setStepMode(true);
        this.arrayProps = new ArrayProperties();
        this.amLeft = new ArrayMarkerProperties();
        this.amLeft.set("color", Color.BLACK);
        this.amLeft.set("label", "left");
        this.amRight = new ArrayMarkerProperties();
        this.amRight.set("color", Color.BLUE);
        this.amRight.set("label", "right");
        this.amFinish = new ArrayMarkerProperties();
        this.amFinish.set("color", Color.GREEN);
        this.amFinish.set("label", "finish");
        this.ami = new ArrayMarkerProperties();
        this.ami.set("color", Color.ORANGE);
        this.ami.set("label", "i");
        this.amj = new ArrayMarkerProperties();
        this.amj.set("color", Color.PINK);
        this.amj.set("label", "j");
    }

    public static void main(String[] args) {
        CocktailSortClass cs = new CocktailSortClass();
        cs.init();
        int[] original = new int[]{34, 2, 5, 67, 55, 4, 1, 78};
        cs.CocktailSort(original);
        System.out.println(cs.lang.toString());
    }

    public void showSourceCode() {
        SourceCodeProperties scProps = new SourceCodeProperties();
        scProps.set("contextColor", Color.BLUE);
        scProps.set("font", new Font(12));
        scProps.set("highlightColor", Color.RED);
        scProps.set("color", Color.BLACK);
        SourceCode sc = this.lang.newSourceCode(new Coordinates(40, 140), "sourceCode", null, scProps);
        sc.addCodeLine("public void CocktailSort(int[] inputArray){", null, 0, null);
        sc.addCodeLine("int left, right, finish, i, j;", null, 1, null);
        sc.addCodeLine("for(i = right; i>= left; i--){", null, 1, null);
        sc.addCodeLine("if(array[i].compareTo(array[i - 1]) < 0)", null, 2, null);
        sc.addCodeLine("finish = i;", null, 3, null);
        sc.addCodeLine("for(j = left; j <= right; j++)", null, 3, null);
        sc.addCodeLine("if(array[j].compareTo(array[j - 1]) < 0)", null, 4, null);
        sc.addCodeLine("finish = j;", null, 5, null);
        sc.addCodeLine("swap(inputArray, i, j); //swap", null, 3, null);
        sc.addCodeLine("}", null, 1, null);
        sc.addCodeLine("}", null, 0, null);
    }

    public void CocktailSort(int[] inputArray) {
        boolean exchange;
        IntArray array = this.lang.newIntArray(new Coordinates(10, 30), inputArray, "array", null, this.arrayProps);
        TicksTiming defaultTiming = new TicksTiming(15);
        this.showSourceCode();
        this.sc.highlight(0);
        this.lang.nextStep();
        this.sc.toggleHighlight(0, 1);
        ArrayMarker left = this.lang.newArrayMarker(array, 1, "left", null);
        this.lang.nextStep();
        ArrayMarker right = this.lang.newArrayMarker(array, array.getLength() - 1, "right", null);
        this.lang.nextStep();
        ArrayMarker finish = this.lang.newArrayMarker(array, right.getPosition(), "finish", null);
        this.lang.nextStep();
        ArrayMarker i = this.lang.newArrayMarker(array, 0, "i", null, this.ami);
        this.lang.nextStep();
        ArrayMarker j = this.lang.newArrayMarker(array, 0, "j", null, this.amj);
        this.lang.nextStep();
        this.sc.unhighlight(1);
        do {
            exchange = false;
            i.move(right.getPosition(), null, defaultTiming);
            while (i.getPosition() >= left.getPosition()) {
                this.sc.highlight(2);
                this.lang.nextStep();
                this.sc.toggleHighlight(2, 3);
                if (array.getData(i.getPosition()) - array.getData(i.getPosition() - 1) < 0) {
                    this.lang.nextStep();
                    this.sc.toggleHighlight(3, 4);
                    exchange = true;
                    finish.move(i.getPosition(), null, defaultTiming);
                    this.lang.nextStep();
                    this.sc.unhighlight(4);
                } else {
                    this.lang.nextStep();
                    this.sc.unhighlight(3);
                }
                i.decrement(null, defaultTiming);
            }
            this.sc.highlight(5);
            array.swap(i.getPosition(), i.getPosition() - 1, null, defaultTiming);
            this.lang.nextStep();
            this.sc.unhighlight(5);
            finish.increment(defaultTiming, defaultTiming);
            left.exchange(finish);
            j.move(left.getPosition(), null, defaultTiming);
            while (j.getPosition() <= right.getPosition()) {
                this.sc.highlight(6);
                this.lang.nextStep();
                if (array.getData(j.getPosition()) - array.getData(j.getPosition() - 1) < 0) {
                    this.lang.nextStep();
                    this.sc.toggleHighlight(6, 7);
                    exchange = true;
                    finish.move(j.getPosition(), null, defaultTiming);
                    this.lang.nextStep();
                    this.sc.unhighlight(7);
                } else {
                    this.lang.nextStep();
                    this.sc.unhighlight(6);
                }
                j.increment(null, defaultTiming);
            }
            this.sc.highlight(8);
            array.swap(j.getPosition(), j.getPosition() - 1, null, defaultTiming);
            this.lang.nextStep();
            this.sc.unhighlight(8);
            finish.decrement(defaultTiming, defaultTiming);
            right.exchange(finish);
        } while (exchange);
    }

    @Override
    public String getCodeExample() {
        return "Straightforward CocktailSort Algorithm";
    }

    @Override
    public Locale getContentLocale() {
        return Locale.US;
    }

    @Override
    public String getDescription() {
        return "Animates CocktailSort with Source Code + Highlighting";
    }

    @Override
    public String getFileExtension() {
        return ".asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(1);
    }

    @Override
    public String getName() {
        return "CocktailSort";
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        this.init();
        int[] arrayData = (int[])primitives.get("array");
        this.arrayProps.set("color", props.get("array", "color"));
        this.CocktailSort(arrayData);
        return this.lang.toString();
    }

    @Override
    public String getAlgorithmName() {
        return "CocktailSort";
    }

    @Override
    public String getOutputLanguage() {
        return "Java";
    }
}

