/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import animalscriptapi.primitives.ArrayMarker;
import animalscriptapi.primitives.Text;
import animalscriptapi.util.Offset;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import generatorImplementations.AnimatedStringArrayAlgorithm;
import java.util.Hashtable;
import java.util.Locale;
import translator.Translator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIterativeBinaryStringSearching
extends AnimatedStringArrayAlgorithm {
    protected Text valueText = null;
    protected Text result = null;
    protected Locale contentLocale = null;

    public AbstractIterativeBinaryStringSearching(String resourceName, Locale locale) {
        this.translator = new Translator(resourceName, locale);
        this.primitiveProps = new Hashtable(59);
        this.localType = new GeneratorType(2);
        this.contentLocale = locale;
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> prims) {
        this.setUpDefaultElements(props, prims, "array", "code", "code", 0, 20);
        String valueToSearchFor = (String)prims.get("value");
        this.search(valueToSearchFor);
        this.wrapUpAnimation();
        this.lang.finalizeGeneration();
        return this.lang.getAnimationCode();
    }

    protected int search(String valueToSearchFor) {
        ArrayMarker lMarker = null;
        ArrayMarker rMarker = null;
        ArrayMarker midMarker = null;
        this.valueText = this.installText("value", "value: " + valueToSearchFor, new Offset(30, 0, this.array, "SE"));
        this.code.highlight("header");
        this.lang.nextStep();
        this.code.toggleHighlight("header", "ifNull");
        this.incrementNrComparisons(2);
        this.lang.nextStep();
        if (valueToSearchFor == null) {
            this.code.unhighlight("ifNull");
            this.lang.nextStep();
            return -1;
        }
        this.code.toggleHighlight("ifNull", "getArrayLength");
        int nrElems = this.array.getLength();
        this.incrementNrAssignments();
        this.lang.nextStep();
        this.code.toggleHighlight("getArrayLength", "installLMarker");
        lMarker = this.installArrayMarker("lMarker", this.array, 0);
        this.incrementNrAssignments();
        this.lang.nextStep();
        this.code.toggleHighlight("installLMarker", "installRMarker");
        rMarker = this.installArrayMarker("rMarker", this.array, nrElems - 1);
        this.incrementNrAssignments();
        this.array.highlightCell(0, nrElems - 1, DEFAULT_TIMING, null);
        this.lang.nextStep();
        this.code.toggleHighlight("installRMarker", "installMidMarker");
        midMarker = this.installArrayMarker("midMarker", this.array, (lMarker.getPosition() + rMarker.getPosition()) / 2);
        this.array.highlightElem(midMarker.getPosition(), null, null);
        this.incrementNrAssignments();
        this.lang.nextStep();
        this.code.toggleHighlight("installMidMarker", "whileLoop");
        while (rMarker.getPosition() > lMarker.getPosition() && !this.array.getData(midMarker.getPosition()).equals(valueToSearchFor)) {
            this.incrementNrComparisons(3);
            this.lang.nextStep();
            this.code.toggleHighlight("whileLoop", "ifLess");
            this.incrementNrComparisons();
            this.lang.nextStep();
            if (valueToSearchFor.compareTo(this.array.getData(midMarker.getPosition())) < 0) {
                this.code.toggleHighlight("ifLess", "continueLeft");
                this.array.unhighlightCell(midMarker.getPosition(), rMarker.getPosition(), DEFAULT_TIMING, DEFAULT_TIMING);
                rMarker.move(midMarker.getPosition() - 1, null, DEFAULT_TIMING);
                this.incrementNrAssignments();
                this.lang.nextStep();
                this.code.unhighlight("continueLeft");
            } else {
                this.code.toggleHighlight("ifLess", "continueRight");
                this.array.unhighlightCell(lMarker.getPosition(), midMarker.getPosition(), DEFAULT_TIMING, DEFAULT_TIMING);
                lMarker.move(midMarker.getPosition() + 1, null, DEFAULT_TIMING);
                this.incrementNrAssignments();
                this.lang.nextStep();
                this.code.unhighlight("continueRight");
            }
            this.code.highlight("updateMidElem");
            this.array.unhighlightElem(midMarker.getPosition(), null, null);
            midMarker.move((lMarker.getPosition() + rMarker.getPosition()) / 2, null, DEFAULT_TIMING);
            this.array.highlightElem(midMarker.getPosition(), null, null);
            this.incrementNrAssignments();
            this.lang.nextStep();
            this.code.toggleHighlight("updateMidElem", "whileLoop");
        }
        this.incrementNrComparisons(3);
        this.lang.nextStep();
        this.code.toggleHighlight("whileLoop", "checkFound");
        this.incrementNrComparisons();
        this.lang.nextStep();
        if (this.array.getData(midMarker.getPosition()).equals(valueToSearchFor)) {
            this.code.toggleHighlight("checkFound", "found");
            this.result = this.installText("value", this.translator.translateMessage("result", new Integer[]{new Integer(midMarker.getPosition())}), new Offset(20, 0, this.valueText, "baseline end"));
            this.lang.nextStep();
            this.code.unhighlight("found");
            return midMarker.getPosition();
        }
        this.code.toggleHighlight("checkFound", "notFound");
        this.result = this.installText("value", this.translator.translateMessage("result", new Integer[]{new Integer(-1)}), new Offset(20, 0, this.valueText, "baseline end"));
        this.lang.nextStep();
        this.code.unhighlight("notFound");
        return -1;
    }

    public Locale getContentLocale() {
        return this.contentLocale;
    }

    public String getAlgorithmName() {
        return "Binary Search";
    }

    @Override
    protected void hideNrStepsArrayCode() {
        super.hideNrStepsArrayCode();
        if (this.result != null) {
            this.result.hide();
        }
        if (this.valueText != null) {
            this.valueText.hide();
        }
        if (this.array != null) {
            this.array.hide();
        }
    }
}

