/*
 * Decompiled with CFR 0.152.
 */
package generator;

import animalscriptapi.properties.CallMethodProperties;
import components.ArrayInputPanel;
import components.ColorChooserComboBox;
import components.DoubleTextField;
import components.FontChooserComboBox;
import components.IntegerTextField;
import components.StringArrayInputPanel;
import generator.PropertiesPanelListener;
import generator.properties.tree.PropertiesTree;
import generator.properties.tree.PropertiesTreeModel;
import generator.properties.tree.PropertiesTreeNode;
import generator.properties.tree.PropertiesTreePane;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class PropertiesPanel
extends JSplitPane
implements TreeSelectionListener,
ActionListener {
    private static final int MIN_TREE_WIDTH = 200;
    private static final long serialVersionUID = 3762254145129952565L;
    boolean designMode = false;
    PropertiesTreeNode selectedNode = null;
    String selectedDisplay = "";
    private PropertiesTreePane treePane;
    private PropertiesTree tree;
    private JPanel panelRight;
    private JLabel labelHead;
    private JPanel lineGeneral;
    private JLabel labelGeneral;
    private JPanel lineIsEditable;
    private JCheckBox checkIsEditable;
    private JPanel lineLabel;
    private JTextField textLabel;
    private JPanel lineValue;
    private JComponent objValue;
    private JButton buttonSetToDefault;
    private JPanel lineSetToDefault;
    private transient PropertiesPanelListener listener = null;

    public PropertiesPanel() {
        this.tree = new PropertiesTree();
        this.setFinalMode();
        this.init();
    }

    public PropertiesPanel(String uri) throws IllegalArgumentException {
        this.tree = new PropertiesTree();
        this.setWorkingMode();
        this.loadURI(uri);
        this.init();
    }

    public PropertiesPanel(PropertiesTree newTree) {
        if (newTree == null) {
            newTree = new PropertiesTree();
        }
        this.tree = newTree;
        this.setWorkingMode();
        this.init();
    }

    private void init() {
        this.panelRight = new JPanel();
        this.panelRight.setLayout(new BoxLayout(this.panelRight, 3));
        this.panelRight.add(Box.createRigidArea(new Dimension(0, 10)));
        this.labelHead = new JLabel();
        this.labelHead.setOpaque(true);
        this.labelHead.setBackground(Color.white);
        this.labelHead.setBorder(BorderFactory.createLineBorder(Color.black));
        this.labelHead.setMaximumSize(new Dimension(Integer.MAX_VALUE, 35));
        JPanel line = new JPanel();
        line.setLayout(new BoxLayout(line, 2));
        line.add(Box.createRigidArea(new Dimension(10, 0)));
        line.add(this.labelHead);
        line.add(Box.createRigidArea(new Dimension(10, 0)));
        this.panelRight.add(line);
        this.panelRight.add(Box.createRigidArea(new Dimension(0, 24)));
        this.labelGeneral = new JLabel();
        if (this.designMode) {
            this.labelGeneral.setText("<html>Please select a Property Item or a Primitive and<br />change its value to the value that should be used as<br />the default value.<br /><br />You can also make a Property Item invisible to the users<br />by unchecking the upper checkbox.<br /><br />The Label stores the text that describes<br />the Property Item.</html>");
        } else {
            this.labelGeneral.setText("<html>Please select a Property at the left and change its value.</html>");
        }
        this.labelGeneral.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.labelGeneral.getMaximumSize().height));
        this.lineGeneral = new JPanel();
        this.lineGeneral.setLayout(new BoxLayout(this.lineGeneral, 2));
        this.lineGeneral.add(Box.createRigidArea(new Dimension(10, 0)));
        this.lineGeneral.add(this.labelGeneral);
        this.lineGeneral.add(Box.createRigidArea(new Dimension(10, 0)));
        this.panelRight.add(this.lineGeneral);
        if (this.designMode) {
            this.checkIsEditable = new JCheckBox("This value is editable by the user", true);
            this.checkIsEditable.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.checkIsEditable.getMaximumSize().height));
            this.lineIsEditable = new JPanel();
            this.lineIsEditable.setLayout(new BoxLayout(this.lineIsEditable, 2));
            this.lineIsEditable.add(Box.createRigidArea(new Dimension(10, 0)));
            this.lineIsEditable.add(this.checkIsEditable);
            this.lineIsEditable.add(Box.createRigidArea(new Dimension(10, 0)));
            this.lineIsEditable.setVisible(false);
            this.panelRight.add(this.lineIsEditable);
            this.panelRight.add(Box.createRigidArea(new Dimension(0, 8)));
            this.textLabel = new JTextField();
            this.textLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Math.max(this.textLabel.getMinimumSize().height, 25)));
            this.lineLabel = new JPanel();
            this.lineLabel.setLayout(new BoxLayout(this.lineLabel, 2));
            this.lineLabel.add(Box.createRigidArea(new Dimension(10, 0)));
            this.lineLabel.add(new JLabel("Label:"));
            this.lineLabel.add(Box.createRigidArea(new Dimension(10, 0)));
            this.lineLabel.add(this.textLabel);
            this.lineLabel.add(Box.createRigidArea(new Dimension(10, 0)));
            this.lineLabel.setVisible(false);
            this.panelRight.add(this.lineLabel);
            this.panelRight.add(Box.createRigidArea(new Dimension(0, 16)));
        }
        this.lineValue = new JPanel();
        this.lineValue.setLayout(new BoxLayout(this.lineValue, 2));
        this.lineValue.add(Box.createRigidArea(new Dimension(10, 0)));
        this.lineValue.add(new JLabel("Value:"));
        this.lineValue.add(Box.createRigidArea(new Dimension(10, 0)));
        this.lineValue.setVisible(false);
        this.panelRight.add(this.lineValue);
        this.panelRight.add(Box.createRigidArea(new Dimension(0, 32)));
        this.buttonSetToDefault = new JButton("Set this property to its default value");
        this.buttonSetToDefault.setActionCommand("setToDefault");
        this.buttonSetToDefault.addActionListener(this);
        this.buttonSetToDefault.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.buttonSetToDefault.getMaximumSize().height));
        this.lineSetToDefault = new JPanel();
        this.lineSetToDefault.setLayout(new BoxLayout(this.lineSetToDefault, 2));
        this.lineSetToDefault.add(Box.createRigidArea(new Dimension(10, 0)));
        this.lineSetToDefault.add(this.buttonSetToDefault);
        this.lineSetToDefault.add(Box.createRigidArea(new Dimension(10, 0)));
        this.lineSetToDefault.setVisible(false);
        this.panelRight.add(this.lineSetToDefault);
        this.panelRight.add(Box.createRigidArea(new Dimension(0, 8)));
        JScrollPane scrollRight = new JScrollPane(this.panelRight);
        this.treePane = new PropertiesTreePane(this.tree);
        this.setLeftComponent(this.treePane);
        this.setRightComponent(scrollRight);
        this.setDividerLocation(200);
        this.tree.addTreeSelectionListener(this);
    }

    public void loadURI(String uri) throws IllegalArgumentException {
        this.setFinalMode();
        ((PropertiesTreeModel)this.tree.getModel()).loadFromXMLFile(uri, true);
        this.tree.expandAllFolders();
        this.tree.updateUI();
    }

    private void updateRightPanelGeneral() {
        this.lineGeneral.setVisible(true);
        if (this.designMode) {
            this.lineIsEditable.setVisible(false);
            this.lineLabel.setVisible(false);
        }
        this.lineValue.setVisible(false);
        this.lineSetToDefault.setVisible(false);
    }

    private void updateRightPanelItem() {
        if (this.selectedNode == null) {
            return;
        }
        boolean bCallMethod = false;
        if (this.selectedNode.isProperty() || this.selectedNode.getAnimationProperties() instanceof CallMethodProperties) {
            bCallMethod = true;
            PropertiesTreeNode n = new PropertiesTreeNode("", "methodName");
            n.setParent(this.selectedNode);
            this.selectedNode = n;
        }
        if (this.selectedNode == null || !this.selectedNode.isItem()) {
            return;
        }
        PropertiesTreeNode p = (PropertiesTreeNode)this.selectedNode.getParent();
        if (!p.isProperty()) {
            return;
        }
        if (this.designMode) {
            this.textLabel.setText(p.getAnimationProperties().getLabel(this.selectedNode.getName()));
            this.checkIsEditable.setSelected(p.getAnimationProperties().getIsEditable(this.selectedNode.getName()));
            this.checkIsEditable.setVisible(!bCallMethod);
        }
        if (this.objValue != null) {
            this.lineValue.remove(this.objValue);
            this.lineValue.remove(this.lineValue.getComponentCount() - 1);
            this.objValue = null;
        }
        if (!this.designMode && bCallMethod) {
            this.objValue = new JButton(p.getAnimationProperties().getLabel("methodName"));
            ((JButton)this.objValue).setActionCommand("call:" + p.getAnimationProperties().get("methodName"));
            ((JButton)this.objValue).addActionListener(this);
        } else {
            this.objValue = this.getEditorForProperty(p.getAnimationProperties().get(this.selectedNode.getName()));
        }
        int oldPrefferedHeight = this.objValue.getPreferredSize().height;
        int minHeight = Math.max(oldPrefferedHeight, 25);
        int minWidth = this.objValue.getPreferredSize().width;
        this.objValue.setMinimumSize(new Dimension(minWidth, minHeight));
        this.objValue.setPreferredSize(new Dimension(minWidth, minHeight));
        this.objValue.setMaximumSize(new Dimension(Integer.MAX_VALUE, minHeight));
        this.lineValue.updateUI();
        this.lineValue.add(this.objValue);
        this.lineValue.add(Box.createRigidArea(new Dimension(10, 0)));
        this.lineGeneral.setVisible(false);
        if (this.designMode) {
            this.lineIsEditable.setVisible(true);
            this.lineLabel.setVisible(true);
        }
        this.lineValue.setVisible(true);
        this.lineSetToDefault.setVisible(!bCallMethod);
    }

    private void updateRightPanelPrimitive() {
        if (this.selectedNode == null || !this.selectedNode.isPrimitive()) {
            return;
        }
        if (this.designMode) {
            this.lineIsEditable.setVisible(false);
            this.lineLabel.setVisible(false);
        }
        if (this.objValue != null) {
            this.lineValue.remove(this.objValue);
            this.lineValue.remove(this.lineValue.getComponentCount() - 1);
            this.objValue = null;
        }
        this.objValue = this.getEditorForProperty(this.selectedNode.getValue());
        int oldPrefferedHeight = this.objValue.getPreferredSize().height;
        int minHeight = Math.max(oldPrefferedHeight, 25);
        int minWidth = this.objValue.getPreferredSize().width;
        this.objValue.setMinimumSize(new Dimension(minWidth, minHeight));
        this.objValue.setPreferredSize(new Dimension(minWidth, minHeight));
        this.objValue.setMaximumSize(new Dimension(Integer.MAX_VALUE, minHeight));
        this.lineValue.updateUI();
        this.lineValue.add(this.objValue);
        this.lineValue.add(Box.createRigidArea(new Dimension(10, 0)));
        this.lineGeneral.setVisible(false);
        if (this.designMode) {
            this.lineIsEditable.setVisible(false);
            this.lineLabel.setVisible(false);
        }
        this.lineValue.setVisible(true);
        this.lineSetToDefault.setVisible(false);
    }

    private String getSelectedFolder(TreePath p) {
        if (p == null || p.getPathCount() < 1) {
            return "* ";
        }
        StringBuilder buf = new StringBuilder(127);
        Object[] os = p.getPath();
        int len = p.getPathCount();
        buf.append("/ ");
        int i = 1;
        while (i < len) {
            if (os[i] instanceof PropertiesTreeNode) {
                PropertiesTreeNode n = (PropertiesTreeNode)os[i];
                if (n.isFolder()) {
                    buf.append(n.getLabel());
                    if (i < len - 1) {
                        buf.append(" / ");
                    }
                }
                if (n.isPrimitive()) {
                    buf.append(n.getName());
                }
                if (n.isProperty()) {
                    buf.append(n.getAnimationProperties().get("name"));
                    if (i < len - 1) {
                        buf.append(" / ");
                    }
                }
                if (n.isItem()) {
                    if (this.designMode) {
                        buf.append(n.getName());
                    } else {
                        buf.append(n.getLabel());
                    }
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public PropertiesTree getTree() {
        return this.tree;
    }

    public void reInsertTree() {
        this.treePane.reInsertTree();
    }

    public boolean areThereElements() {
        return ((PropertiesTreeModel)this.tree.getModel()).getElementsCount() > 0;
    }

    private JComponent getEditorForProperty(Object obj) {
        if (obj == null) {
            return new JLabel("There is no registered Editor for a null-Object");
        }
        if (obj instanceof String) {
            return new JTextField((String)obj);
        }
        if (obj instanceof Integer) {
            return new IntegerTextField((Integer)obj);
        }
        if (obj instanceof Boolean) {
            return new JCheckBox("(Checked: TRUE, Unchecked: FALSE)", (boolean)((Boolean)obj));
        }
        if (obj instanceof Double) {
            return new DoubleTextField((Double)obj);
        }
        if (obj instanceof int[]) {
            return new ArrayInputPanel((int[])obj);
        }
        if (obj instanceof String[]) {
            return new StringArrayInputPanel((String[])obj);
        }
        if (obj instanceof Color) {
            return new ColorChooserComboBox((Color)obj);
        }
        if (obj instanceof Font) {
            return new FontChooserComboBox((Font)obj);
        }
        return new JLabel("There is no registered Editor for " + obj.getClass().getName());
    }

    private Object getValueOfEditorByType(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return ((JTextField)this.objValue).getText();
        }
        if (obj instanceof Integer) {
            return ((IntegerTextField)this.objValue).getValue();
        }
        if (obj instanceof Boolean) {
            return ((JCheckBox)this.objValue).isSelected();
        }
        if (obj instanceof Double) {
            return ((DoubleTextField)this.objValue).getValue();
        }
        if (obj instanceof int[]) {
            return ((ArrayInputPanel)this.objValue).tblElements.getIntValues();
        }
        if (obj instanceof String[]) {
            return ((StringArrayInputPanel)this.objValue).tblElements.getStringValues();
        }
        if (obj instanceof Color) {
            return ((ColorChooserComboBox)this.objValue).getColorSelected();
        }
        if (obj instanceof Font) {
            return ((FontChooserComboBox)this.objValue).getFontSelected();
        }
        return null;
    }

    public void updateCurrentPropertyValues() {
        if (this.selectedNode == null || this.selectedNode.isFolder() || this.selectedNode.isProperty()) {
            return;
        }
        if (this.selectedNode.isPrimitive()) {
            Object oldValue = this.selectedNode.getValue();
            if (oldValue == null) {
                return;
            }
            this.selectedNode.setValue(this.getValueOfEditorByType(oldValue));
            return;
        }
        if (this.selectedNode.isItem()) {
            PropertiesTreeNode p = (PropertiesTreeNode)this.selectedNode.getParent();
            if (p == null || !p.isProperty()) {
                return;
            }
            if (this.designMode) {
                p.getAnimationProperties().setIsEditable(this.selectedNode.getName(), this.checkIsEditable.isSelected());
                try {
                    p.getAnimationProperties().setLabel(this.selectedNode.getName(), this.textLabel.getText());
                }
                catch (IllegalArgumentException e) {
                    System.err.println(e.getLocalizedMessage());
                }
            }
            if (p.getAnimationProperties() instanceof CallMethodProperties) {
                return;
            }
            Object oldValue = p.getAnimationProperties().get(this.selectedNode.getName());
            if (oldValue == null) {
                return;
            }
            try {
                p.getAnimationProperties().set(this.selectedNode.getName(), this.getValueOfEditorByType(oldValue));
            }
            catch (IllegalArgumentException e) {
                System.err.println(e.getLocalizedMessage());
            }
        }
    }

    public void setBuildMode() {
        this.tree.setBuildMode();
        this.designMode = true;
    }

    public void setWorkingMode() {
        this.tree.setWorkingMode();
        this.designMode = true;
    }

    public void setFinalMode() {
        this.tree.setFinalMode();
        this.designMode = false;
    }

    public void valueChanged(TreeSelectionEvent e) {
        PropertiesTreeNode n;
        if (e == null) {
            return;
        }
        if (this.selectedNode != null && (this.selectedNode.isItem() || this.selectedNode.isPrimitive())) {
            this.updateCurrentPropertyValues();
        }
        if ((n = (PropertiesTreeNode)this.tree.getLastSelectedPathComponent()) == null || n == this.tree.getModel().getRoot()) {
            return;
        }
        this.selectedNode = n;
        this.selectedDisplay = this.getSelectedFolder(this.tree.getSelectionPath());
        this.labelHead.setText("   " + this.selectedDisplay);
        if (n.isFolder()) {
            this.updateRightPanelGeneral();
            return;
        }
        if (n.isProperty()) {
            if (n.getAnimationProperties() instanceof CallMethodProperties) {
                this.updateRightPanelItem();
                return;
            }
            this.updateRightPanelGeneral();
            return;
        }
        if (n.isPrimitive()) {
            this.updateRightPanelPrimitive();
            return;
        }
        if (n.isItem()) {
            this.updateRightPanelItem();
            return;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e == null) {
            return;
        }
        if (e.getActionCommand().equalsIgnoreCase("setToDefault")) {
            if (this.selectedNode == null || !this.selectedNode.isItem()) {
                return;
            }
            PropertiesTreeNode p = (PropertiesTreeNode)this.selectedNode.getParent();
            if (!p.isProperty()) {
                return;
            }
            if (!this.designMode && p.getAnimationProperties() instanceof CallMethodProperties) {
                return;
            }
            p.getAnimationProperties().set(this.selectedNode.getName(), p.getAnimationProperties().getDefault(this.selectedNode.getName()).get());
            this.updateRightPanelItem();
        }
        if (e.getActionCommand().length() > 5 && e.getActionCommand().substring(0, 4).equalsIgnoreCase("call")) {
            String method = e.getActionCommand().substring(5);
            if (this.listener != null) {
                this.listener.callMethod(method);
            }
            return;
        }
    }

    public void setListener(PropertiesPanelListener newListener) {
        this.listener = newListener;
    }
}

