/*
 * Decompiled with CFR 0.152.
 */
package generator;

import animal.exchange.AnimationImporter;
import animal.main.Animal;
import animal.main.Animation;
import generator.GeneratorGUI;
import generator.properties.tree.PropertiesTreeModel;
import java.util.Locale;

public class AnimalGeneratorGUI
extends GeneratorGUI {
    private Animal animalInstance;

    public AnimalGeneratorGUI(Locale currentLocale) {
        super(currentLocale);
        if (this.wiz != null) {
            this.wiz.removeListener();
            this.wiz.setListener(this);
        }
        this.animalInstance = Animal.get();
    }

    public void displayWizard() {
        this.wiz.displayWizard();
    }

    public boolean nextPressed() {
        if (this.wiz.getCurrentStep() != 3) {
            return super.nextPressed();
        }
        if (this.txtFileName.getText() != null && this.txtFileName.getText().length() > 0) {
            this.storeFile();
            return true;
        }
        String animationContent = this.selectedGenerator.generate(((PropertiesTreeModel)this.propPanel.getTree().getModel()).getPropertiesContainer(), ((PropertiesTreeModel)this.propPanel.getTree().getModel()).getPrimitivesContainer());
        String format = "animation/animalscript";
        AnimationImporter animationImporter = null;
        animationImporter = AnimationImporter.getImporterFor(format);
        Animation animation = null;
        if (animationImporter != null) {
            animation = animationImporter.importAnimationFrom(null, animationContent);
        }
        if (animation != null) {
            this.animalInstance.setAnimation(animation);
            this.animalInstance.setAnimalScriptCode(animationContent);
        }
        this.wiz.setVisible(false);
        return true;
    }
}

