/*
 * Decompiled with CFR 0.152.
 */
package de.ahrgr.animal.kohnert.asugen;

import de.ahrgr.animal.kohnert.asugen.AbsoluteNode;
import de.ahrgr.animal.kohnert.asugen.AnimalObject;
import de.ahrgr.animal.kohnert.asugen.Circle;
import de.ahrgr.animal.kohnert.asugen.CodeGroup;
import de.ahrgr.animal.kohnert.asugen.Node;
import de.ahrgr.animal.kohnert.asugen.PolyLine;
import de.ahrgr.animal.kohnert.asugen.Rectangle;
import de.ahrgr.animal.kohnert.asugen.Text;
import de.ahrgr.animal.kohnert.asugen.property.Property;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedList;

public class AnimalScriptWriter {
    protected PrintWriter out;
    protected boolean block_opened = false;
    protected int default_depth = 0;
    protected LinkedList<AnimalObject> registerList = new LinkedList();
    protected ArrayList<AnimalObject> registeredObjects = new ArrayList();
    protected AnimalObject objToRegister = null;
    protected boolean auto_register = true;

    public AnimalScriptWriter(PrintWriter outWriter) {
        this.out = outWriter;
        this.out.println("%Animal 2");
    }

    public AnimalScriptWriter(PrintWriter outWriter, Property[] properties, String generatorClass) {
        this(outWriter);
        this.writeProperties(properties, generatorClass);
    }

    public void writeProperties(Property[] properties, String generatorClass) {
        this.out.println("#!!!EMBEDDED_PROPERTIES");
        this.out.println("#generator = \"" + generatorClass + "\"");
        int i = 0;
        while (i < properties.length) {
            this.out.println("#" + properties[i].toString());
            ++i;
        }
        this.out.println("#!!!END_EMBEDDED_PROPERTIES");
    }

    public void startBlock() {
        if (!this.block_opened) {
            if (this.objToRegister != null) {
                this.objToRegister.register();
            }
            this.block_opened = true;
            this.out.println("{");
        }
    }

    /*
     * Unable to fully structure code
     */
    public void endBlock() {
        if (this.block_opened) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            o = this.registerList.removeFirst();
            o.register();
lbl5:
            // 2 sources

            ** while (!this.registerList.isEmpty())
        }
lbl6:
        // 1 sources

        this.out.println("}");
        this.block_opened = false;
    }

    public void startNewBlock() {
        this.endBlock();
        this.startBlock();
    }

    public void addLabel(String label) {
        this.out.println("label \"" + label + "\"");
    }

    public PrintWriter getOut() {
        return this.out;
    }

    protected void autoRegister(AnimalObject obj) {
        if (this.block_opened) {
            this.registerList.add(obj);
        } else {
            if (this.objToRegister != null) {
                this.objToRegister.register();
            }
            this.objToRegister = obj;
        }
    }

    public void clear() {
        this.startBlock();
        for (AnimalObject o : this.registeredObjects) {
            o.setHidden(true);
        }
    }

    public void close() {
        this.endBlock();
        if (this.objToRegister != null) {
            this.objToRegister.register();
        }
    }

    public Node abs(int x, int y) {
        return new AbsoluteNode(this, x, y);
    }

    public Text createText(Node position, String text) {
        Text t = new Text(this, position, text);
        if (this.auto_register) {
            this.autoRegister(t);
        }
        return t;
    }

    public PolyLine createLine(Node n1, Node n2) {
        PolyLine p = new PolyLine(this);
        p.addNode(n1);
        p.addNode(n2);
        if (this.auto_register) {
            this.autoRegister(p);
        }
        return p;
    }

    public Rectangle createRectangle(Node n1, Node n2) {
        Rectangle r = new Rectangle(this, n1, n2);
        if (this.auto_register) {
            this.autoRegister(r);
        }
        return r;
    }

    public CodeGroup createCodeGroup(Node position) {
        CodeGroup g = new CodeGroup(this, position);
        if (this.auto_register) {
            this.autoRegister(g);
        }
        return g;
    }

    public Circle createCircle(Node position, int radius) {
        Circle c = new Circle(this, position, radius);
        if (this.auto_register) {
            this.autoRegister(c);
        }
        return c;
    }
}

