/*
 * Decompiled with CFR 0.152.
 */
package animalscriptapi.animalscript;

import animalscriptapi.animalscript.AnimalGenerator;
import animalscriptapi.animalscript.AnimalScript;
import animalscriptapi.primitives.ArrayMarker;
import animalscriptapi.primitives.generators.ArrayMarkerGenerator;
import animalscriptapi.primitives.generators.Language;
import animalscriptapi.properties.ArrayMarkerProperties;
import animalscriptapi.util.Timing;
import java.awt.Color;

public class AnimalArrayMarkerGenerator
extends AnimalGenerator
implements ArrayMarkerGenerator {
    private static int count = 1;

    public AnimalArrayMarkerGenerator(Language aLang) {
        super(aLang);
    }

    public void create(ArrayMarker am) {
        if (this.isNameUsed(am.getName()) || am.getName() == "") {
            am.setName("ArrayMarker" + count);
            ++count;
        }
        this.lang.addItem(am);
        StringBuilder def = new StringBuilder(AnimalScript.INITIAL_GENBUFFER_SIZE);
        def.append("arrayMarker \"").append(am.getName()).append("\" on \"");
        def.append(am.getArray().getName()).append("\" atIndex ");
        def.append(am.getPosition());
        ArrayMarkerProperties props = am.getProperties();
        if (props.get("label") != null && !((String)props.get("label")).equals("")) {
            def.append(" label \"").append((String)props.get("label")).append("\"");
        }
        if (props.get("color") != null) {
            def.append(" color ");
            def.append(AnimalGenerator.makeColorDef(((Color)props.get("color")).getRed(), ((Color)props.get("color")).getGreen(), ((Color)props.get("color")).getBlue()));
        }
        if (props.get("depth") != null) {
            def.append(" depth " + ((Integer)props.get("depth")).toString());
        }
        def.append(AnimalGenerator.makeDisplayOptionsDef(am.getDisplayOptions(), props));
        this.lang.addLine(def);
    }

    public void move(ArrayMarker am, int to, Timing delay, Timing duration) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("moveArrayMarker \"").append(am.getName());
        sb.append("\" to position ").append(to).append(" ");
        sb.append(AnimalGenerator.makeOffsetTimingDef(delay)).append(" ");
        sb.append(AnimalGenerator.makeDurationTimingDef(duration));
        this.lang.addLine(sb.toString());
    }

    public void moveBeforeStart(ArrayMarker am, Timing delay, Timing duration) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("moveArrayMarker \"").append(am.getName());
        sb.append("\" to outside ");
        sb.append(AnimalGenerator.makeOffsetTimingDef(delay)).append(" ");
        sb.append(AnimalGenerator.makeDurationTimingDef(duration));
        this.lang.addLine(sb.toString());
    }

    public void moveToEnd(ArrayMarker am, Timing delay, Timing duration) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("moveArrayMarker \"").append(am.getName());
        sb.append("\" to arrayEnd ");
        sb.append(AnimalGenerator.makeOffsetTimingDef(delay));
        sb.append(" ").append(AnimalGenerator.makeDurationTimingDef(duration));
        this.lang.addLine(sb.toString());
    }

    public void moveOutside(ArrayMarker am, Timing delay, Timing duration) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("moveArrayMarker \"").append(am.getName());
        sb.append("\" to outside ");
        sb.append(AnimalGenerator.makeOffsetTimingDef(delay));
        sb.append(" ").append(AnimalGenerator.makeDurationTimingDef(duration));
        this.lang.addLine(sb.toString());
    }

    public void decrement(ArrayMarker am, Timing delay, Timing duration) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("moveArrayMarker \"").append(am.getName());
        sb.append("\" to position ").append(am.getPosition() - 1);
        sb.append(" ").append(AnimalGenerator.makeOffsetTimingDef(delay));
        sb.append(" ");
        sb.append(AnimalGenerator.makeDurationTimingDef(duration));
        this.lang.addLine(sb.toString());
    }

    public void increment(ArrayMarker am, Timing delay, Timing duration) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("moveArrayMarker \"").append(am.getName());
        sb.append("\" to position ").append(am.getPosition() + 1);
        sb.append(" ").append(AnimalGenerator.makeOffsetTimingDef(delay));
        sb.append(" ");
        sb.append(AnimalGenerator.makeDurationTimingDef(duration));
        this.lang.addLine(sb.toString());
    }
}

