/*
 * Decompiled with CFR 0.152.
 */
package animal.main;

import animal.gui.DrawCanvas;
import animal.gui.GraphicVector;
import animal.gui.GraphicVectorEntry;
import animal.main.AnimationApplet;
import animal.misc.ScalableGraphics;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public class AnimationAppletCanvas
extends Canvas {
    private static final long serialVersionUID = -2288981608142011801L;
    private Image image = null;
    private GraphicVector objects = null;
    private Dimension oldSize = new Dimension(0, 0);
    private ScalableGraphics sg = new ScalableGraphics();

    void setMagnification(double mag) {
        this.sg.setMagnification(mag);
        this.repaintNow();
    }

    public AnimationAppletCanvas(AnimationApplet model) {
    }

    public void paint(Graphics g) {
        Dimension size = DrawCanvas.ensureLegalSize(this.getSize());
        Graphics ig = null;
        if (!size.equals(this.oldSize)) {
            this.image = this.createImage(size.width, size.height);
            this.oldSize = size;
        }
        if (this.image != null) {
            Graphics where;
            ig = this.image.getGraphics();
            ig.clearRect(0, 0, size.width, size.height);
            if (this.sg.getMagnification() == 1.0) {
                where = ig;
            } else {
                this.sg.setGraphics(ig);
                where = this.sg;
            }
            if (this.objects != null) {
                int a = 0;
                while (a < this.objects.getSize()) {
                    GraphicVectorEntry gve = this.objects.elementAt(a);
                    if (!gve.isTemporary()) {
                        gve.go.paint(where);
                    }
                    ++a;
                }
            }
            g.drawImage(this.image, 0, 0, this);
            ig.dispose();
        }
    }

    void repaintNow() {
        this.paint(this.getGraphics());
    }

    void setObjects(GraphicVector graphicalObjects) {
        this.objects = graphicalObjects;
    }
}

