/*
 * Decompiled with CFR 0.152.
 */
package animal.main;

import animal.animator.Animator;
import animal.exchange.AnimationImporter;
import animal.gui.GraphicVector;
import animal.main.Animal;
import animal.main.Animation;
import animal.main.AnimationAppletCanvas;
import animal.main.AnimationState;
import animal.main.Link;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import translator.AnimalTranslator;

public class AnimationApplet
extends Applet
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = -7916236681433719427L;
    private AnimationState ani = null;
    private AnimationAppletCanvas animationCanvas;
    private Button endButton;
    private Button forwardButton;
    private boolean debugMode = false;
    boolean initialized = false;
    private boolean pause = false;
    private Button pauseButton;
    private Button playButton;
    private Button rewindButton;
    private Button startButton;
    private Choice magnificationCB;
    private int ticks;

    public AnimationApplet() {
        new Animal(true, this.getCodeBase());
    }

    public void start() {
        this.setLayout(new BorderLayout(0, 0));
        GridBagLayout gbl = new GridBagLayout();
        Panel controlPanel = new Panel(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.5;
        gbc.fill = 1;
        this.startButton = this.getButton("|<");
        controlPanel.add((Component)this.startButton, gbc);
        this.rewindButton = this.getButton("<<");
        controlPanel.add((Component)this.rewindButton, gbc);
        this.pauseButton = this.getButton("||");
        controlPanel.add((Component)this.pauseButton, gbc);
        this.playButton = this.getButton(">");
        controlPanel.add((Component)this.playButton, gbc);
        this.forwardButton = this.getButton(">>");
        controlPanel.add((Component)this.forwardButton, gbc);
        this.endButton = this.getButton(">|");
        controlPanel.add((Component)this.endButton, gbc);
        controlPanel.add((Component)new Label("Magn.: ", 1), gbc);
        String hundred = "100%";
        this.magnificationCB = new Choice();
        controlPanel.add((Component)this.magnificationCB, gbc);
        this.magnificationCB.addItem("50%");
        this.magnificationCB.addItem("71%");
        this.magnificationCB.addItem(hundred);
        this.magnificationCB.addItem("141%");
        this.magnificationCB.addItem("200%");
        this.magnificationCB.select(hundred);
        this.startButton.addActionListener(this);
        this.rewindButton.addActionListener(this);
        this.pauseButton.addActionListener(this);
        this.playButton.addActionListener(this);
        this.forwardButton.addActionListener(this);
        this.endButton.addActionListener(this);
        this.magnificationCB.addItemListener(this);
        this.add("South", controlPanel);
        this.animationCanvas = new AnimationAppletCanvas(this);
        this.add("Center", this.animationCanvas);
        this.initialized = true;
        this.loadFile(this.getParameter("Animation"));
        if (this.ani == null) {
            this.setAnimation(Animation.get());
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private Button getButton(String text) {
        Button result = new Button(text);
        return result;
    }

    public void init() {
        super.init();
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            if (this.ani == null) {
                this.setAnimation(Animation.get());
            }
            this.setStep(this.ani.getStep(), true);
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.startButton) {
            this.setStep(0, true);
        } else if (object == this.rewindButton) {
            this.setStep(this.ani.getPrevStep(), true);
        } else if (object == this.pauseButton) {
            this.pause = true;
        } else if (object == this.playButton) {
            this.setStep(this.ani.getNextStep(), false);
        } else if (object == this.forwardButton) {
            this.setStep(this.ani.getNextStep(), true);
        } else if (object == this.endButton) {
            this.setStep(this.ani.getLastStep(), true);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.magnificationCB) {
            int i;
            String s = this.magnificationCB.getSelectedItem();
            s = s.substring(0, s.length() - 1);
            try {
                i = Integer.parseInt(s);
            }
            catch (NumberFormatException nfe) {
                this.errorMsg(AnimalTranslator.translateMessage("illegalMagnification", s));
                i = 1;
            }
            this.animationCanvas.setMagnification(0.01 * (double)i);
        }
    }

    void setStep(int step, boolean immediate) {
        if (this.isVisible()) {
            this.showStatus("Animation running");
            int next = 0;
            while (next != Integer.MAX_VALUE) {
                step = this.ani.getAnimation().verifyStep(step);
                if (this.ani != null) {
                    this.ani.setStep(step, !immediate);
                }
                if (immediate) {
                    this.animationCanvas.repaintNow();
                    next = Integer.MAX_VALUE;
                    continue;
                }
                next = this.nextStep();
                if (next == Integer.MAX_VALUE) continue;
                step = next;
            }
            boolean notAtStart = step != 0;
            boolean notAtEnd = step != this.ani.getLastStep();
            this.startButton.setEnabled(notAtStart);
            this.rewindButton.setEnabled(notAtStart);
            this.forwardButton.setEnabled(notAtEnd);
            this.endButton.setEnabled(notAtEnd);
            this.playButton.setEnabled(notAtEnd);
        }
    }

    public int getStep() {
        return this.ani.getStep();
    }

    int nextStep() {
        int step = this.ani.getStep();
        this.playButton.setEnabled(false);
        Vector<Animator> animators = this.ani.getCurrentAnimators();
        long time = System.currentTimeMillis();
        int a = 0;
        while (a < animators.size()) {
            animators.elementAt(a).init(this.ani, time, this.ticks);
            ++a;
        }
        boolean finished = false;
        while (!finished) {
            finished = true;
            time = System.currentTimeMillis();
            ++this.ticks;
            int a2 = 0;
            while (a2 < animators.size()) {
                Animator animator = animators.elementAt(a2);
                animator.action(time, this.ticks);
                if (animator.hasFinished()) {
                    animators.removeElementAt(a2);
                    continue;
                }
                finished = false;
                ++a2;
            }
            this.animationCanvas.repaintNow();
        }
        Link l = this.ani.getAnimation().getLink(step);
        switch (l.getMode()) {
            case 1: {
                return Integer.MAX_VALUE;
            }
            case 2: {
                if (!this.pause) {
                    try {
                        Thread.sleep(l.getTime());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return l.getNextStep();
                }
                this.pause = false;
                return Integer.MAX_VALUE;
            }
        }
        this.playButton.setEnabled(step != this.ani.getLastStep());
        return Integer.MAX_VALUE;
    }

    boolean setAnimation(Animation animation) {
        if (!this.isInitialized()) {
            this.init();
        }
        this.ani = new AnimationState(animation);
        GraphicVector objects = this.ani.getCurrentObjects();
        this.animationCanvas.setObjects(objects);
        this.setStep(this.ani.getStep(), true);
        this.ticks = 0;
        this.ani.reset();
        this.playButton.setEnabled(true);
        return true;
    }

    public void errorMsg(String msg) {
        this.showStatus(msg);
        if (this.debugMode) {
            System.err.println("****error: " + msg);
        }
    }

    private boolean loadFile(String filename) {
        return this.loadFile(filename, "animation/animal-ascii-compressed");
    }

    private boolean loadFile(String filename, String targetFormat) {
        AnimationImporter importer = AnimationImporter.getImporterFor(targetFormat);
        if (importer != null) {
            Animation tmpAnimation = importer.importAnimationFrom(filename);
            return this.setAnimation(tmpAnimation);
        }
        return false;
    }

    public String getAppletInfo() {
        return "Animal Applet frontend(c) 1999 Guido R\u00fc\u00dfling";
    }

    public String[][] getParameterInfo() {
        String[][] info = new String[][]{{"Animation", "URL", "the animation to be played"}};
        return info;
    }

    public void message(String msg) {
        this.showStatus(msg);
    }

    public static void main(String[] args) {
        Frame f = new Frame("Animation Applet");
        AnimationApplet animationApplet = new AnimationApplet();
        animationApplet.init();
        animationApplet.start();
        f.add("Center", animationApplet);
        f.setSize(480, 360);
        f.setVisible(true);
    }
}

