/*
 * Decompiled with CFR 0.152.
 */
package animal.gui;

import animal.animator.Animator;
import animal.animator.Show;
import animal.animator.TimedShow;
import animal.gui.AnimalMainWindow;
import animal.gui.DrawWindow;
import animal.main.Animation;
import animal.main.AnimationState;
import animal.variables.Variable;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import translator.AnimalTranslator;

public class VariableTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -4525246143284609287L;
    private static final String[] columnNames = new String[]{AnimalTranslator.translateMessage("varID"), AnimalTranslator.translateMessage("varType"), AnimalTranslator.translateMessage("varValue"), AnimalTranslator.translateMessage("varFrame")};
    private String[][] data = null;
    private int step = -1;
    private Animation animation;
    private TreeMap<String, Variable> currentVariables = new TreeMap();

    public void setAnimation(Animation anim) {
        this.animation = anim;
    }

    public void setStep(int stepNr) {
        if (this.step != stepNr) {
            this.step = stepNr;
            this.updateDataForStep();
        }
    }

    public void updateDataForStep() {
        AnimationState stateNow = AnimalMainWindow.getWindowCoordinator().getAnimationWindow(false).getAnimationState();
        this.currentVariables = stateNow.getVariables();
        int pos = 0;
        int nrVars = this.currentVariables.size();
        if (nrVars > 0) {
            this.data = new String[nrVars][4];
            for (String variableName : this.currentVariables.keySet()) {
                Variable var = this.currentVariables.get(variableName);
                this.data[pos][0] = variableName;
                this.data[pos][1] = var.getType();
                this.data[pos][2] = var.toString();
                this.data[pos][3] = var.getFrame();
                ++pos;
            }
        }
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length;
    }

    public String getColumnName(int col) {
        return columnNames[col];
    }

    public String getValueAt(int row, int col) {
        if (this.data == null || this.data.length < row || this.data[row].length < col) {
            return null;
        }
        return this.data[row][col];
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    public boolean isCellEditable(int row, int col) {
        return col == 2;
    }

    public void setValueAt(Object value, int row, int col) {
        int chosenID = -1;
        int targetIndex = 0;
        int[] animatorOIDs = null;
        Vector<Animator> helper = this.animation.getAnimatorsAtStep(this.step);
        Animator currentAnimator = null;
        boolean fittingAnimatorFound = false;
        int nrAnimatedObjects = 0;
        int i = 0;
        while (i < helper.size() && !fittingAnimatorFound) {
            currentAnimator = helper.elementAt(i);
            if (currentAnimator != null && (currentAnimator instanceof Show || currentAnimator instanceof TimedShow)) {
                try {
                    chosenID = Integer.parseInt(this.data[row][0]);
                }
                catch (NumberFormatException e) {
                    AnimalTranslator.translateMessage("currentAnimator", this.data[row][0]);
                }
                if (currentAnimator instanceof Show || currentAnimator instanceof TimedShow) {
                    animatorOIDs = currentAnimator.getObjectNums();
                    nrAnimatedObjects = animatorOIDs.length;
                    int j = 0;
                    while (j < animatorOIDs.length && !fittingAnimatorFound) {
                        boolean bl = fittingAnimatorFound = animatorOIDs[j] == chosenID;
                        if (fittingAnimatorFound) {
                            targetIndex = j;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (fittingAnimatorFound) {
            if (animatorOIDs.length == 1) {
                this.animation.deleteAnimator(currentAnimator);
            }
            int[] modifiedOIDs = new int[nrAnimatedObjects - 1];
            if (targetIndex > 0) {
                System.arraycopy(animatorOIDs, 0, modifiedOIDs, 0, targetIndex);
            }
            if (targetIndex != nrAnimatedObjects - 1) {
                System.arraycopy(animatorOIDs, targetIndex + 1, modifiedOIDs, targetIndex, nrAnimatedObjects - targetIndex - 1);
            }
            currentAnimator.setObjectNums(modifiedOIDs);
        } else {
            boolean showMode = (Boolean)value;
            TimedShow ts = new TimedShow(this.step, chosenID, 0, showMode ? "show" : "hide", showMode);
            this.animation.insertAnimator(ts);
        }
        DrawWindow drawWin = AnimalMainWindow.getWindowCoordinator().getDrawWindow(false);
        drawWin.setChanged();
        drawWin.writeBack();
        this.data[row][col] = String.valueOf(value);
        this.fireTableCellUpdated(row, col);
    }
}

