/*
 * Decompiled with CFR 0.152.
 */
package animal.gui;

import animal.misc.MessageDisplay;
import generator.Generator;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import translator.AnimalTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeDemo
extends JPanel
implements TreeSelectionListener {
    private static final long serialVersionUID = 5303628155385977194L;
    private JTree tree;
    private DefaultMutableTreeNode rootNode;
    private JEditorPane htmlPane;
    private URL helpURL;
    private static boolean DEBUG = false;
    private static boolean playWithLineStyle = false;
    private static String lineStyle = "Horizontal";
    private static boolean useSystemLookAndFeel = false;
    private Class<?> generatorDummy;

    public TreeDemo() {
        super(new GridLayout(1, 0));
        this.initTree();
    }

    public void initTree() {
        Vector<String> classNames;
        this.rootNode = new DefaultMutableTreeNode("Algorithms");
        HashMap<String, DefaultMutableTreeNode> nodeMap = new HashMap<String, DefaultMutableTreeNode>(127);
        nodeMap.put("$", this.rootNode);
        nodeMap.put("$DE", this.makeNode("de", this.rootNode));
        nodeMap.put("$EN", this.makeNode("en", this.rootNode));
        nodeMap.put("$DE$sorting", this.makeNode("Sorting Algorithms", (DefaultMutableTreeNode)nodeMap.get("$EN")));
        nodeMap.put("$EN$sorting", this.makeNode("Sortieralgorithmen", (DefaultMutableTreeNode)nodeMap.get("$DE")));
        nodeMap.put("$EN$sorting$Quicksort", this.makeNode("Quicksort", (DefaultMutableTreeNode)nodeMap.get("$DE$sorting")));
        nodeMap.put("$DE$sorting$Quicksort", this.makeNode("Quicksort", (DefaultMutableTreeNode)nodeMap.get("$EN$sorting")));
        nodeMap.put("$EN$sorting$Quicksort$Java", this.makeNode("Java", (DefaultMutableTreeNode)nodeMap.get("$EN$sorting$Quicksort")));
        nodeMap.put("$EN$sorting$Quicksort$Java$Pivot=last", this.makeNode("Pivot=last", (DefaultMutableTreeNode)nodeMap.get("$EN$sorting$Quicksort$Java")));
        nodeMap.put("$EN$sorting$Quicksort$Java$Pivot=first", this.makeNode("Pivot=first", (DefaultMutableTreeNode)nodeMap.get("$EN$sorting$Quicksort$Java")));
        nodeMap.put("$EN$sorting$Quicksort$Java$Pivot=median", this.makeNode("Pivot=median", (DefaultMutableTreeNode)nodeMap.get("$EN$sorting$Quicksort$Java")));
        this.tree = new JTree(this.rootNode);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        if (playWithLineStyle) {
            System.out.println("line style = " + lineStyle);
            this.tree.putClientProperty("JTree.lineStyle", lineStyle);
        }
        if (!(classNames = this.readListOfGenerators()).isEmpty()) {
            Enumeration<String> en = classNames.elements();
            while (en.hasMoreElements()) {
                Generator gen;
                String next = en.nextElement();
                if (next instanceof String && (gen = TreeDemo.createGeneratorByName(next)) != null) continue;
            }
        }
        JScrollPane treeView = new JScrollPane(this.tree);
        this.htmlPane = new JEditorPane();
        this.htmlPane.setEditable(false);
        this.initHelp();
        JScrollPane htmlView = new JScrollPane(this.htmlPane);
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setTopComponent(treeView);
        splitPane.setBottomComponent(htmlView);
        Dimension minimumSize = new Dimension(100, 50);
        htmlView.setMinimumSize(minimumSize);
        treeView.setMinimumSize(minimumSize);
        splitPane.setDividerLocation(100);
        splitPane.setPreferredSize(new Dimension(500, 300));
        this.add(splitPane);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object nodeInfo = node.getUserObject();
        if (node.isLeaf()) {
            BookInfo book = (BookInfo)nodeInfo;
            this.displayURL(book.bookURL);
            if (DEBUG) {
                System.out.print(book.bookURL + ":  \n    ");
            }
        } else {
            this.displayURL(this.helpURL);
        }
        if (DEBUG) {
            System.out.println(nodeInfo.toString());
        }
    }

    private void initHelp() {
        String s = "TreeDemoHelp.html";
        this.helpURL = this.getClass().getClassLoader().getResource(s);
        if (this.helpURL == null) {
            System.err.println("Couldn't open help file: " + s);
        } else if (DEBUG) {
            System.out.println("Help URL is " + this.helpURL);
        }
        this.displayURL(this.helpURL);
    }

    private void displayURL(URL url) {
        try {
            if (url != null) {
                this.htmlPane.setPage(url);
            } else {
                this.htmlPane.setText("File Not Found");
                if (DEBUG) {
                    System.out.println("Attempted to display a null URL.");
                }
            }
        }
        catch (IOException e) {
            System.err.println("Attempted to read a bad URL: " + url);
        }
    }

    protected static void createAndShowGUI() {
        if (useSystemLookAndFeel) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                System.err.println("Couldn't use system look and feel.");
            }
        }
        JFrame frame = new JFrame("TreeDemo");
        frame.setDefaultCloseOperation(3);
        TreeDemo newContentPane = new TreeDemo();
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreeDemo.createAndShowGUI();
            }
        });
    }

    public DefaultMutableTreeNode makeNode(String key, DefaultMutableTreeNode parent) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(key);
        if (node == null) {
            System.err.println("Oops...");
        }
        parent.add(node);
        return node;
    }

    protected void populateList(String key) {
    }

    protected Vector<String> readListOfGenerators() {
        File f;
        ClassLoader cl;
        Vector<String> vec = new Vector<String>();
        URL url = null;
        if (this.generatorDummy == null) {
            try {
                this.generatorDummy = Class.forName("generatorImplementations.DummyGenerator");
            }
            catch (ClassNotFoundException cfe) {
                System.err.println("DummyGenerator could not be found!");
            }
        }
        if (this.generatorDummy != null && (cl = this.generatorDummy.getClassLoader()) != null) {
            url = cl.getResource("generatorImplementations");
        }
        if (url == null) {
            System.err.println("url null, using built-in");
            vec.addElement("BinarySearchWrapper");
            vec.addElement("BoyerMooreStringSearchWrapper");
            vec.addElement("BruteForceStringSearchWrapper");
            vec.addElement("BubbleSort");
            vec.addElement("BubbleSortEN");
            vec.addElement("BubbleSortGdI2");
            vec.addElement("BubbleSortGdI2Improved");
            vec.addElement("BubbleSortMathLab");
            vec.addElement("InsertionSort");
            vec.addElement("InsertionSortEN");
            vec.addElement("InsertionSortGdI2");
            vec.addElement("InsertionSortPseudoCode");
            vec.addElement("InsertionSortPseudoCode");
            vec.addElement("InsertionSortPseudoCode2");
            vec.addElement("InsertionSortPseudoCode2EN");
            vec.addElement("InsertionSortPseudoCodeEN");
            vec.addElement("InterpolationSearchWrapper");
            vec.addElement("KnuthMorrisPrattStringSearchWrapper");
            vec.addElement("MergeSort");
            vec.addElement("MergeSortEN");
            vec.addElement("QuickSort");
            vec.addElement("QuickSort2");
            vec.addElement("QuickSort3");
            vec.addElement("QuickSortEN");
            vec.addElement("QuickSortGdI2");
            vec.addElement("SelectionSort");
            vec.addElement("SelectionSortEN");
            vec.addElement("SelectionSortGdI2");
            vec.addElement("SequentialSearchWrapper");
            vec.addElement("ShellSort");
            vec.addElement("ShellSortEN");
            vec.addElement("VigenereDecodeWrapper");
            vec.addElement("VigenereDecodeWrapperEN");
            vec.addElement("VigenereEncodeWrapper");
            vec.addElement("VigenereEncodeWrapperEN");
            return vec;
        }
        String path = url.toString();
        if (path.startsWith("jar:")) {
            if (path.endsWith(".jar")) {
                path = path.substring(4, path.indexOf(".jar") + 4);
            } else if (path.indexOf("!") > 0) {
                path = path.substring(4, path.indexOf("!"));
            }
            try {
                JarEntry entry;
                JarInputStream jf = new JarInputStream(new URL(path).openConnection().getInputStream());
                while ((entry = jf.getNextJarEntry()) != null) {
                    String name = entry.getName();
                    if (!name.startsWith("generatorImplementations") || name.length() < 31) continue;
                    name = name.substring(25, name.length() - 6);
                    vec.add(name);
                }
                jf.close();
            }
            catch (Exception e) {
                System.err.println(String.valueOf(e.getClass().getName()) + " // " + e.getMessage());
                return vec;
            }
        }
        try {
            f = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            return vec;
        }
        if (f == null) {
            return vec;
        }
        String[] files = f.list();
        if (files == null) {
            return vec;
        }
        int i = 0;
        while (i < files.length) {
            if (files[i].endsWith(".class")) {
                vec.add(files[i].substring(0, files[i].length() - 6));
            }
            ++i;
        }
        try {
            Properties config = null;
            InputStream in = this.getClass().getResourceAsStream("/generators.dat");
            if (in != null) {
                BufferedInputStream bins = new BufferedInputStream(in);
                config = new Properties();
                config.load(bins);
                bins.close();
                in.close();
                Enumeration<?> keys = config.propertyNames();
                while (keys.hasMoreElements()) {
                    String elementKey = (String)config.get(keys.nextElement());
                    if (vec.contains(elementKey)) continue;
                    vec.add(config.getProperty((String)keys.nextElement()));
                }
            }
        }
        catch (IOException ioex) {
            MessageDisplay.errorMsg(AnimalTranslator.translateMessage("genSpecMissing"), 4);
        }
        return vec;
    }

    private static Generator createGeneratorByName(String className) {
        Object object;
        block5: {
            object = null;
            Class<?> genClass = Class.forName("generatorImplementations." + className);
            object = genClass.newInstance();
            if (object instanceof Generator) break block5;
            return null;
        }
        try {
            return object;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private class BookInfo {
        public String bookName;
        public URL bookURL;

        public BookInfo(String book, String filename) {
            this.bookName = book;
            this.bookURL = this.getClass().getClassLoader().getResource(filename);
            if (this.bookURL == null) {
                System.err.println("Couldn't find file: " + filename);
            }
        }

        public String toString() {
            return this.bookName;
        }
    }
}

