/*
 * Decompiled with CFR 0.152.
 */
package animal.gui;

import animal.gui.MainToolBarController;
import animal.main.Animal;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JToolBar;
import translator.AnimalTranslator;

public class MainToolBar
extends JToolBar {
    private static final long serialVersionUID = -7100837857472507441L;
    public static final String INPUT = "input";
    public static final String NEW = "new";
    public static final String OPEN = "open";
    public static final String PRINT = "print";
    public static final String RELOAD = "reload";
    public static final String REPOSITORY = "repository";
    public static final String RUN_ANIMATION = "runStep";
    public static final String SAVE = "save";
    public static final String SAVE_AS = "saveAs";
    public static final String SHOW_ANIMATION_WINDOW = "animWin";
    public static final String SHOW_DRAWING_WINDOW = "drawWin";
    private MainToolBarController controller;

    public MainToolBar(String title, Animal animalInstance) {
        super(title);
        this.controller = new MainToolBarController(animalInstance);
        this.buildToolBar();
    }

    private AbstractButton createButton(String key, boolean isToggle, ActionListener listener, String command) {
        AbstractButton helper = AnimalTranslator.getGUIBuilder().generateJButton(key, null, isToggle, listener, true);
        helper.setActionCommand(command);
        return helper;
    }

    public void buildToolBar() {
        this.getAccessibleContext().setAccessibleName(AnimalTranslator.translateMessage("AnimalMainToolbar"));
        this.setFloatable(true);
        this.add(this.createButton(NEW, false, this.controller, NEW));
        this.addSeparator();
        this.add(this.createButton(OPEN, false, this.controller, OPEN));
        this.add(this.createButton("repositoryOpen", false, this.controller, REPOSITORY));
        this.add(this.createButton(RELOAD, false, this.controller, RELOAD));
        this.addSeparator();
        this.add(this.createButton("inputScripting", false, this.controller, INPUT));
        this.add(this.createButton(SHOW_ANIMATION_WINDOW, false, this.controller, SHOW_ANIMATION_WINDOW));
        this.add(this.createButton(SHOW_DRAWING_WINDOW, false, this.controller, SHOW_DRAWING_WINDOW));
        this.addSeparator();
        this.add(this.createButton(SAVE, false, this.controller, SAVE));
        this.add(this.createButton(SAVE_AS, false, this.controller, SAVE_AS));
        this.addSeparator();
        this.add(this.createButton(PRINT, false, this.controller, PRINT));
    }
}

