/*
 * Decompiled with CFR 0.152.
 */
package animal.gui;

import animal.gui.AnimalMainWindow;
import animal.gui.EditMenuController;
import animal.gui.FileMenuController;
import animal.gui.HelpMenuController;
import animal.gui.LanguageMenuController;
import animal.gui.OptionMenuController;
import animal.gui.WindowCoordinator;
import animal.main.Animal;
import animal.misc.XProperties;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import translator.AnimalTranslator;

public class MainMenuBar
extends JMenuBar {
    private static final long serialVersionUID = 1659837246295610623L;
    public static final String ABOUT = "about";
    public static final String ANIMALSCRIPT_DEFINITION = "animalscript";
    public static final String ANIMATION_INFORMATION = "animInfo";
    public static final String ANIMATION_WINDOW_SIZE = "animWindowSize";
    public static final String BOUNDING_BOX = "boundingBox";
    public static final String COLLECT_GARBAGE_NOW = "garbageCollection";
    public static final String COMPONENT_CONFIGURATION = "compConf";
    public static final String DEMO_ANIMATION = "demoAnimation";
    public static final String EXPORT = "export";
    public static final String GENERATOR = "generator";
    public static final String IMPORT = "import";
    public static final String INPUT_SCRIPTING = "inputScripting";
    public static final String NEW = "new";
    public static final String OPEN = "open";
    public static final String OPEN_REPOSITORY = "repositoryOpen";
    public static final String PREFERENCES = "preferences";
    public static final String PRINT = "print";
    public static final String QUIT = "quit";
    public static final String QUIZ_RESULTS = "quizResults";
    public static final String RELOAD = "reload";
    public static final String SAVE = "save";
    public static final String SAVE_AS = "saveAs";
    public static final String THREE_BUTTON_MOUSE = "mouseLMR";
    public static final String TOGGLE_ANIMATION_OVERVIEW = "animOverview";
    public static final String TOGGLE_ANIMATION_WINDOW = "animWin";
    public static final String TOGGLE_ANNOTATION_WINDOW = "annotationWin";
    public static final String TOGGLE_DRAWING_WINDOW = "drawWin";
    public static final String TOGGLE_OBJECTS_WINDOW = "objectsWin";
    public static final String TOGGLE_TIME_LINE_WINDOW = "timeLineWin";
    public static final String TUTORIAL = "tutorial";
    public static final String TWO_BUTTON_MOUSE = "mouseLRM";
    public static final String TOGGLE_VARIABLE_VIEW = "GUIResources.variableView";
    private Animal animalInstance;
    private AnimalMainWindow animalMainWindow;
    private JMenuItem animationOverviewItem;
    private JMenuItem animationWindowItem;
    private JMenuItem annotationWindowItem;
    private JMenuItem drawWindowItem;
    protected JMenu editMenu;
    protected JMenu fileMenu;
    protected JMenu helpMenu;
    protected JMenu languageMenu;
    private boolean mouseTypeIsThreeButtonMouse = true;
    private JMenuItem objectsWindowItem;
    protected JMenu optionMenu;
    private JMenuItem threeButtonMouseItem;
    private JMenuItem timeLineWindowItem;
    private JMenuItem twoButtonMouseItem;
    private JMenuItem variableViewItem;

    public MainMenuBar(String title, AnimalMainWindow mainWindow, Animal animalObj) {
        this.animalMainWindow = mainWindow;
        this.animalInstance = animalObj == null ? Animal.get() : animalObj;
        this.buildMenuBar();
    }

    public void buildMenuBar() {
        this.getAccessibleContext().setAccessibleName(AnimalTranslator.translateMessage("mainMenuBar"));
        this.buildFileMenu();
        this.buildWindowsMenu();
        this.buildOptionMenu();
        this.buildLanguageMenu();
        this.buildHelpMenu();
    }

    private void buildFileMenu() {
        this.fileMenu = AnimalTranslator.getGUIBuilder().generateJMenu("file", null);
        FileMenuController fileMenuController = new FileMenuController(this.animalInstance);
        this.fileMenu.add(this.createMenuItem(NEW, fileMenuController));
        this.fileMenu.add(this.createMenuItem(COLLECT_GARBAGE_NOW, fileMenuController));
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.createMenuItem(OPEN, fileMenuController));
        this.fileMenu.add(this.createMenuItem(RELOAD, fileMenuController));
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.createMenuItem(GENERATOR, fileMenuController));
        this.fileMenu.add(this.createMenuItem(OPEN_REPOSITORY, fileMenuController));
        this.fileMenu.add(this.createMenuItem(DEMO_ANIMATION, fileMenuController));
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.createMenuItem(PRINT, fileMenuController));
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.createMenuItem(SAVE, fileMenuController));
        this.fileMenu.add(this.createMenuItem(SAVE_AS, fileMenuController));
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.createMenuItem(QUIT, fileMenuController));
        this.add(this.fileMenu);
    }

    private void buildWindowsMenu() {
        this.editMenu = AnimalTranslator.getGUIBuilder().generateJMenu("windows", null);
        WindowCoordinator coordinator = AnimalMainWindow.WINDOW_COORDINATOR;
        EditMenuController editMenuController = new EditMenuController(coordinator);
        this.drawWindowItem = this.createMenuItem(TOGGLE_DRAWING_WINDOW, editMenuController);
        this.editMenu.add(this.drawWindowItem);
        this.animationOverviewItem = this.createMenuItem(TOGGLE_ANIMATION_OVERVIEW, editMenuController);
        this.editMenu.add(this.animationOverviewItem);
        this.animationWindowItem = this.createMenuItem(TOGGLE_ANIMATION_WINDOW, editMenuController);
        this.editMenu.add(this.animationWindowItem);
        this.editMenu.add(this.createMenuItem(INPUT_SCRIPTING, editMenuController));
        this.timeLineWindowItem = this.createMenuItem(TOGGLE_TIME_LINE_WINDOW, editMenuController);
        this.editMenu.add(this.timeLineWindowItem);
        this.objectsWindowItem = this.createMenuItem(TOGGLE_OBJECTS_WINDOW, editMenuController);
        this.editMenu.add(this.objectsWindowItem);
        this.variableViewItem = this.createMenuItem(TOGGLE_VARIABLE_VIEW, editMenuController);
        this.editMenu.add(this.variableViewItem);
        this.add(this.editMenu);
    }

    private void buildOptionMenu() {
        this.optionMenu = AnimalTranslator.getGUIBuilder().generateJMenu("optionsMenu", null);
        OptionMenuController optionMenuController = new OptionMenuController(this.animalInstance);
        this.optionMenu.add(this.createMenuItem(PREFERENCES, optionMenuController));
        this.threeButtonMouseItem = this.createToggleMenuItem(THREE_BUTTON_MOUSE, this.threeButtonMouseMode(), optionMenuController);
        this.optionMenu.add(this.threeButtonMouseItem);
        this.twoButtonMouseItem = this.createToggleMenuItem(TWO_BUTTON_MOUSE, !this.threeButtonMouseMode(), optionMenuController);
        this.optionMenu.add(this.twoButtonMouseItem);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.twoButtonMouseItem);
        buttonGroup.add(this.threeButtonMouseItem);
        this.optionMenu.add(this.createMenuItem(COMPONENT_CONFIGURATION, optionMenuController));
        this.optionMenu.add(this.createMenuItem(BOUNDING_BOX, optionMenuController));
        this.add(this.optionMenu);
    }

    private void buildLanguageMenu() {
        this.languageMenu = AnimalTranslator.getGUIBuilder().generateJMenu("locale", null);
        XProperties languageProperties = this.animalMainWindow.retrieveLanguageDefinitions();
        if (this.animalMainWindow.languages == null) {
            this.animalMainWindow.languages = new Vector(20);
        }
        LanguageMenuController languageMenuController = new LanguageMenuController(this.animalInstance);
        int nrLang = 0;
        boolean isOK = true;
        while (isOK) {
            String localeString = languageProperties.getProperty(String.valueOf(nrLang), "n");
            boolean bl = isOK = !localeString.equalsIgnoreCase("n");
            if (isOK) {
                this.addLanguageSupportEntry(localeString, languageMenuController, languageProperties);
            }
            ++nrLang;
        }
        this.add(this.languageMenu);
    }

    private void addLanguageSupportEntry(String localeString, ActionListener listener, XProperties languageProperties) {
        StringTokenizer stok = new StringTokenizer(localeString, " _");
        String baseCode = stok.nextToken();
        String codeToUse = localeString;
        String languageEntry = languageProperties.getProperty(String.valueOf(localeString) + ".label");
        char mnemonic = languageProperties.getProperty(String.valueOf(localeString) + ".mnemonic").charAt(0);
        String toolTipText = languageProperties.getProperty(String.valueOf(localeString) + ".toolTipText");
        String iconName = languageProperties.getProperty(String.valueOf(localeString) + ".iconName");
        String localeStringInternal = languageProperties.getProperty(String.valueOf(localeString) + ".locale");
        if (languageEntry.equalsIgnoreCase(codeToUse)) {
            codeToUse = baseCode;
        }
        JMenuItem menuItem = new JMenuItem(languageEntry);
        menuItem.setMnemonic(mnemonic);
        menuItem.setToolTipText(toolTipText);
        menuItem.addActionListener(listener);
        menuItem.setActionCommand(localeStringInternal);
        if (iconName != null && iconName.length() > 0) {
            menuItem.setIcon(AnimalTranslator.getGUIBuilder().getImageIcon(iconName));
        }
        if (this.languageMenu == null) {
            this.languageMenu = AnimalTranslator.getGUIBuilder().generateJMenu("locale", null);
        }
        this.languageMenu.add(menuItem);
    }

    private void buildHelpMenu() {
        this.helpMenu = AnimalTranslator.getGUIBuilder().generateJMenu("help", null);
        HelpMenuController helpMenuController = new HelpMenuController();
        try {
            this.setHelpMenu(this.helpMenu);
        }
        catch (Error error) {
            // empty catch block
        }
        this.helpMenu.add(this.createMenuItem(ABOUT, helpMenuController));
        this.helpMenu.add(this.createMenuItem(ANIMATION_INFORMATION, helpMenuController));
        this.helpMenu.add(this.createMenuItem(ANIMALSCRIPT_DEFINITION, helpMenuController));
        this.helpMenu.add(this.createMenuItem(TUTORIAL, helpMenuController));
        this.helpMenu.add(this.createMenuItem(ANIMATION_WINDOW_SIZE, helpMenuController));
        this.helpMenu.add(this.createMenuItem(QUIZ_RESULTS, helpMenuController));
        this.add(this.helpMenu);
    }

    public void setThreeButtonMouseMode(boolean hasThreeButtons) {
        this.mouseTypeIsThreeButtonMouse = hasThreeButtons;
    }

    public boolean threeButtonMouseMode() {
        return this.mouseTypeIsThreeButtonMouse;
    }

    private JMenuItem createMenuItem(String key, ActionListener listener) {
        return this.createMenuItem(key, key, listener);
    }

    private JMenuItem createMenuItem(String key, String command, ActionListener listener) {
        JMenuItem helper = AnimalTranslator.getGUIBuilder().generateJMenuItem(key, true);
        helper.addActionListener(listener);
        helper.setActionCommand(command);
        return helper;
    }

    private JMenuItem createToggleMenuItem(String key, boolean initialValue, ActionListener listener) {
        return this.createToggleMenuItem(key, initialValue, key, listener);
    }

    private JMenuItem createToggleMenuItem(String key, boolean initialValue, String command, ActionListener listener) {
        JMenuItem helper = AnimalTranslator.getGUIBuilder().generateToggleableJMenuItem(key, null, true, initialValue);
        helper.addActionListener(listener);
        helper.setActionCommand(command);
        return helper;
    }
}

