/*
 * Decompiled with CFR 0.152.
 */
package animal.gui;

import animal.exchange.AnimationExporter;
import animal.exchange.AnimationImporter;
import animal.exchange.AnimationPrintJob;
import animal.main.Animal;
import animal.main.Animation;
import animal.misc.MessageDisplay;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import translator.AnimalTranslator;

public class FileMenuController
implements ActionListener {
    private Animal animal;

    public FileMenuController(Animal animalInstance) {
        this.animal = animalInstance;
    }

    public void actionPerformed(ActionEvent event) {
        String command;
        if (this.animal == null) {
            this.animal = Animal.get();
        }
        if ((command = event.getActionCommand()).equals("garbageCollection")) {
            System.gc();
            JOptionPane.showMessageDialog(this.animal, AnimalTranslator.translateMessage("garbageCollected"));
        } else if (command.equals("demoAnimation")) {
            this.animal.demoAnimation();
        } else if (command.equals("new")) {
            this.animal.newFile();
        } else if (command.equals("open")) {
            AnimationImporter.importAnimation();
        } else if (command.equals("repositoryOpen")) {
            this.animal.openRepository();
        } else if (command.equals("generator")) {
            this.animal.openGenerator();
        } else if (command.equals("print")) {
            new AnimationPrintJob(this.animal);
        } else if (command.equals("reload")) {
            this.animal.reloadFile();
        } else if (command.equals("quit")) {
            this.animal.quitAnimal();
        } else if (command.equals("save")) {
            Animation currentAnimation = this.animal.getAnimation();
            if (currentAnimation != null) {
                AnimationExporter.saveAnimation(currentAnimation);
            }
        } else if (command.equals("saveAs")) {
            Animation currentAnimation = this.animal.getAnimation();
            if (currentAnimation != null) {
                AnimationExporter.exportAnimation(currentAnimation);
            }
        } else {
            MessageDisplay.errorMsg("nothingAssoc", command, 4);
        }
    }
}

