/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics.meta;

import animal.graphics.PTGraphicObject;
import animal.graphics.meta.ArrowablePrimitive;
import animal.main.AnimalConfiguration;
import animal.misc.MSMath;
import animal.misc.MessageDisplay;
import animal.misc.XProperties;
import java.awt.Graphics;
import java.awt.Point;
import translator.AnimalTranslator;

public abstract class OpenLineBasedShape
extends PTGraphicObject
implements ArrowablePrimitive {
    protected boolean hasBackwardArrow;
    protected boolean hasForwardArrow;

    public static void drawArrow(Graphics g, Point tip, Point tail) {
        if (tip == null || tail == null) {
            MessageDisplay.errorMsg(AnimalTranslator.translateMessage("internalError", new String[]{"tip / tail null", "PTLine.drawArrow"}), 16);
            return;
        }
        int xDiff = tail.x - tip.x;
        int yDiff = tail.y - tip.y;
        int dist = MSMath.dist(tip, tail);
        if (dist > 0) {
            if (dist < 20) {
                dist = 20;
            }
            xDiff = xDiff * 20 / dist;
            yDiff = yDiff * 20 / dist;
            int[] x = new int[]{tip.x, tip.x + yDiff / 2 + xDiff, tip.x + xDiff / 2, tip.x - yDiff / 2 + xDiff};
            int[] y = new int[]{tip.y, tip.y - xDiff / 2 + yDiff, tip.y + yDiff / 2, tip.y + xDiff / 2 + yDiff};
            g.fillPolygon(x, y, 4);
        }
    }

    public boolean hasBWArrow() {
        return this.hasBackwardArrow;
    }

    public boolean hasFWArrow() {
        return this.hasForwardArrow;
    }

    public void initializeWithDefaults(String primitiveName) {
        super.initializeWithDefaults(primitiveName);
        AnimalConfiguration config = AnimalConfiguration.getDefaultConfiguration();
        this.hasBackwardArrow = config.getDefaultBooleanValue(primitiveName, "bwArrow", false);
        this.hasForwardArrow = config.getDefaultBooleanValue(primitiveName, "fwArrow", false);
    }

    public void setBWArrow(boolean shallHaveBackwardArrow) {
        this.hasBackwardArrow = shallHaveBackwardArrow;
    }

    public void setFWArrow(boolean shallHaveForwardArrow) {
        this.hasForwardArrow = shallHaveForwardArrow;
    }

    public void updateDefaults(XProperties defaultProperties) {
        super.updateDefaults(defaultProperties);
        defaultProperties.put(String.valueOf(this.getType()) + ".bwArrow", this.hasBWArrow());
        defaultProperties.put(String.valueOf(this.getType()) + ".fwArrow", this.hasFWArrow());
    }

    protected void cloneCommonFeaturesInto(OpenLineBasedShape targetShape) {
        super.cloneCommonFeaturesInto(targetShape);
        targetShape.setFWArrow(this.hasForwardArrow);
        targetShape.setBWArrow(this.hasBackwardArrow);
    }
}

