/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics.meta;

import animal.graphics.meta.ArcBasedShape;
import animal.graphics.meta.ArrowablePrimitive;
import animal.main.AnimalConfiguration;
import animal.misc.MSMath;
import animal.misc.MessageDisplay;
import java.awt.Graphics;
import java.awt.Point;
import translator.AnimalTranslator;

public abstract class OpenArcBasedShape
extends ArcBasedShape
implements ArrowablePrimitive {
    protected boolean hasBackwardArrow;
    protected boolean hasForwardArrow;

    protected void drawArrow(Graphics g, double angle, int xRadius, int yRadius, boolean clockwise) {
        double before = angle + (double)(clockwise ? 1 : -1) * 1.0 / 100.0;
        double tipX = (double)this.center.x + (double)xRadius * Math.cos(angle);
        double tipY = (double)this.center.y - (double)yRadius * Math.sin(angle);
        double inclinationX = (double)this.center.x + (double)xRadius * Math.cos(before) - tipX;
        double inclinationY = (double)this.center.y - (double)yRadius * Math.sin(before) - tipY;
        double length = Math.sqrt(inclinationX * inclinationX + inclinationY * inclinationY);
        Point from = new Point((int)(tipX + inclinationX * (double)xRadius / length), (int)(tipY + inclinationY * (double)yRadius / length));
        this.drawArrow(g, new Point((int)tipX, (int)tipY), from);
    }

    protected void drawArrow(Graphics g, Point tip, Point tail) {
        if (tip == null || tail == null) {
            MessageDisplay.errorMsg(AnimalTranslator.translateMessage("internalError", new String[]{"tip / tail null", "PTPolyline.drawArrow"}), 16);
            return;
        }
        int xDiff = tail.x - tip.x;
        int yDiff = tail.y - tip.y;
        int dist = MSMath.dist(tip, tail);
        if (dist > 0) {
            if (dist < 20) {
                dist = 20;
            }
            xDiff = xDiff * 20 / dist;
            yDiff = yDiff * 20 / dist;
            int[] x = new int[]{tip.x, tip.x + yDiff / 2 + xDiff, tip.x + xDiff / 2, tip.x - yDiff / 2 + xDiff};
            int[] y = new int[]{tip.y, tip.y - xDiff / 2 + yDiff, tip.y + yDiff / 2, tip.y + xDiff / 2 + yDiff};
            g.fillPolygon(x, y, 4);
        }
    }

    public boolean hasBWArrow() {
        return this.hasBackwardArrow;
    }

    public boolean hasFWArrow() {
        return this.hasForwardArrow;
    }

    public void initializeWithDefaults(String primitiveName) {
        super.initializeWithDefaults(primitiveName);
        this.center = new Point(0, 0);
        AnimalConfiguration config = AnimalConfiguration.getDefaultConfiguration();
        this.hasBackwardArrow = config.getDefaultBooleanValue(primitiveName, "bwArrow", false);
        this.hasForwardArrow = config.getDefaultBooleanValue(primitiveName, "fwArrow", false);
    }

    public void setBWArrow(boolean shallHaveBackwardArrow) {
        this.hasBackwardArrow = shallHaveBackwardArrow;
    }

    public void setFWArrow(boolean shallHaveForwardArrow) {
        this.hasForwardArrow = shallHaveForwardArrow;
    }

    protected void cloneCommonFeaturesInto(OpenArcBasedShape targetShape) {
        super.cloneCommonFeaturesInto(targetShape);
        targetShape.setCenter(this.getCenter().x, this.getCenter().y);
        targetShape.setFWArrow(this.hasForwardArrow);
        targetShape.setBWArrow(this.hasBackwardArrow);
    }
}

